<?php

/**
 * @Packge     : Marino
 * @Version    : 1.0
 * @Author     : Vecurosoft
 * @Author URI : https://www.vecurosoft.com/
 *
 */

    // Block direct access

    if( ! defined( 'ABSPATH' ) ){

        exit();

    }

/**

 * Admin Custom Login Logo

 */

function marino_custom_login_logo() {

    $logo = ! empty( marino_opt( 'marino_admin_login_logo', 'url' ) ) ? marino_opt( 'marino_admin_login_logo', 'url' ) : '' ;

    if( isset( $logo ) && ! empty( $logo ) ){

        echo '<style type="text/css">body.login div#login h1 a { background-image:url('.esc_url( $logo ).'); }</style>';
    }
}

add_action( 'login_enqueue_scripts', 'marino_custom_login_logo' );

/**
* Admin Custom css
*/

add_action( 'admin_enqueue_scripts', 'marino_admin_styles' );

function marino_admin_styles() {

  if ( ! empty( $marino_admin_custom_css ) ) {
        $marino_admin_custom_css = str_replace(array("\r\n", "\r", "\n", "\t", '    '), '', $marino_admin_custom_css);
        echo '<style rel="stylesheet" id="marino-admin-custom-css" >';
            echo esc_html( $marino_admin_custom_css );
        echo '</style>';
    }
}

 // share button code

 function marino_social_sharing_buttons( ) {

    // Get page URL

    $URL        = get_permalink();
    $Sitetitle  = get_bloginfo('name');
    // Get page title

    $Title  = str_replace( ' ', '%20', get_the_title());

    // Construct sharing URL without using any script

    $twitterURL     = 'https://twitter.com/share?text='.esc_html( $Title ).'&url='.esc_url( $URL );

    $facebookURL    = 'https://www.facebook.com/sharer/sharer.php?u='.esc_url( $URL );

    $pinteresturl   = 'http://pinterest.com/pin/create/link/?url='.esc_url( $URL ).'&media='.esc_url(get_the_post_thumbnail_url()).'&description='.wp_kses_post(get_the_title());

    $linkedin       = 'https://www.linkedin.com/shareArticle?mini=true&url='.esc_url( $URL ).'&title='.esc_html( $Title );

    // Add sharing button at the end of page/page content

    $content = '';

    $content .= '<li><a class="facebook" href="'.esc_url( $facebookURL ).'" target="_blank"><i class="fab fa-facebook-f"></i></a></li>';

    $content .= '<li><a class="twitter" href="'. esc_url( $twitterURL ) .'" target="_blank"><i class="fab fa-twitter"></i></a></li>';

    $content .= '<li><a class="pinterest" href="'.esc_url( $pinteresturl ).'" target="_blank"><i class="fab fa-pinterest"></i></a></li>';

    $content .= '<li><a class="linkedin" href="'.esc_url( $linkedin ).'" target="_blank"><i class="fab fa-linkedin-in"></i></a></li>';

    return $content;

};



//add SVG to allowed file uploads

function marino_mime_types( $mimes ) {

    $mimes['svg'] = 'image/svg+xml';
    $mimes['svgz'] = 'image/svgz+xml';
    $mimes['exe'] = 'program/exe';
    $mimes['dwg'] = 'image/vnd.dwg';
    return $mimes;

}

add_filter('upload_mimes', 'marino_mime_types');



function marino_wp_check_filetype_and_ext( $data, $file, $filename, $mimes ) {

    $wp_filetype = wp_check_filetype( $filename, $mimes );
    $ext         = $wp_filetype['ext'];
    $type        = $wp_filetype['type'];
    $proper_filename = $data['proper_filename'];

    return compact( 'ext', 'type', 'proper_filename' );

}

add_filter( 'wp_check_filetype_and_ext', 'marino_wp_check_filetype_and_ext', 10, 4 );


// Service Post Type

add_action( 'init','marino_service', 0 );



function marino_service(){

    $labels = array(

        'name'               => esc_html__( 'Services', 'post Category general name', 'marino' ),
        'singular_name'      => esc_html__( 'Service', 'post Category singular name', 'marino' ),
        'menu_name'          => esc_html__( 'Services', 'admin menu', 'marino' ),
        'name_admin_bar'     => esc_html__( 'Service', 'add new on admin bar', 'marino' ),
        'add_new'            => esc_html__( 'Add New', 'Service', 'marino' ),
        'add_new_item'       => esc_html__( 'Add New Service', 'marino' ),
        'new_item'           => esc_html__( 'New Service', 'marino' ),
        'edit_item'          => esc_html__( 'Edit Service', 'marino' ),
        'view_item'          => esc_html__( 'View Service', 'marino' ),
        'all_items'          => esc_html__( 'All Services', 'marino' ),
        'search_items'       => esc_html__( 'Search Services', 'marino' ),
        'parent_item_colon'  => esc_html__( 'Parent Services:', 'marino' ),
        'not_found'          => esc_html__( 'No Services found.', 'marino' ),
        'not_found_in_trash' => esc_html__( 'No Services found in Trash.', 'marino' ),
    );



    $args = array(

        'labels'             => $labels,
        'description'        => esc_html__( 'Description.', 'marino' ),
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'has_archive'        => true,
        'hierarchical'       => false,
        'menu_position'      => null,
        'show_in_rest'       => true,
        'menu_icon'          => 'dashicons-nametag',
        'supports'           => array( 'title', 'thumbnail', 'editor', 'excerpt', 'elementor' ),
        'rewrite'            => array( 'slug' => 'all-services' ),
    );

    register_post_type( 'marino_service', $args );


    $labels = array(

        'name'                       => esc_html__( 'Categories', 'taxonomy general name', 'marino' ),
        'singular_name'              => esc_html__( 'Category', 'taxonomy singular name', 'marino' ),
        'search_items'               => esc_html__( 'Search Categorys', 'marino' ),
        'popular_items'              => esc_html__( 'Popular Categorys', 'marino' ),
        'all_items'                  => esc_html__( 'All Categorys', 'marino' ),
        'parent_item'                => null,
        'parent_item_colon'          => null,
        'edit_item'                  => esc_html__( 'Edit Category', 'marino' ),
        'update_item'                => esc_html__( 'Update Category', 'marino' ),
        'add_new_item'               => esc_html__( 'Add New Category', 'marino' ),
        'new_item_name'              => esc_html__( 'New Category Name', 'marino' ),
        'separate_items_with_commas' => esc_html__( 'Separate Categorys with commas', 'marino' ),
        'add_or_remove_items'        => esc_html__( 'Add or remove Categorys', 'marino' ),
        'choose_from_most_used'      => esc_html__( 'Choose from the most used Categorys', 'marino' ),
        'not_found'                  => esc_html__( 'No Categorys found.', 'marino' ),
        'menu_name'                  => esc_html__( 'Categories', 'marino' ),
    );



    $args = array(

        'hierarchical'          => true,
        'labels'                => $labels,
        'show_ui'               => true,
        'show_admin_column'     => true,
        'update_count_callback' => '_update_post_term_count',
        'query_var'             => true,
        'show_in_rest'          => true,
        'rewrite'               => array( 'slug' => 'service-category' ),
    );

    register_taxonomy( 'service_category', 'marino_service', $args );



    // Add new taxonomy, NOT hierarchical (like tags)

    $labels = array(

        'name'                       => esc_html__( 'Tags', 'taxonomy general name', 'marino' ),
        'singular_name'              => esc_html__( 'Tag', 'taxonomy singular name', 'marino' ),
        'search_items'               => esc_html__( 'Search Tags', 'marino' ),
        'popular_items'              => esc_html__( 'Popular Tags', 'marino' ),
        'all_items'                  => esc_html__( 'All Tags', 'marino' ),
        'parent_item'                => null,
        'parent_item_colon'          => null,
        'edit_item'                  => esc_html__( 'Edit Tag', 'marino' ),
        'update_item'                => esc_html__( 'Update Tag', 'marino' ),
        'add_new_item'               => esc_html__( 'Add New Tag', 'marino' ),
        'new_item_name'              => esc_html__( 'New Tag Name', 'marino' ),
        'separate_items_with_commas' => esc_html__( 'Separate Tags with commas', 'marino' ),
        'add_or_remove_items'        => esc_html__( 'Add or remove Tags', 'marino' ),
        'choose_from_most_used'      => esc_html__( 'Choose from the most used Tags', 'marino' ),
        'not_found'                  => esc_html__( 'No Tags found.', 'marino' ),
        'menu_name'                  => esc_html__( 'Tags', 'marino' ),

    );

    $args = array(

        'hierarchical'          => false,
        'labels'                => $labels,
        'show_ui'               => true,
        'show_admin_column'     => true,
        'update_count_callback' => '_update_post_term_count',
        'query_var'             => true,
        'show_in_rest'          => true,
        'rewrite'               => array( 'slug' => 'service-tag' ),
    );

    register_taxonomy( 'service_tag', 'marino_service', $args );
}


if( ! function_exists( 'marino_services_category' ) ){
    function marino_services_category(){
        $cat_array = array();
        $cat_array[] = esc_html__( 'Select a category','marino' );
        $terms = get_terms( array(
            'taxonomy'      => 'service_category',
            'hide_empty'    => true
        ) );
        if( is_array( $terms ) && $terms ){
            foreach( $terms as $term ){
                $cat_array[$term->slug] = $term->name;
            }
        }
        return $cat_array;
    }
}

/**
 * Single Template
 */

add_filter( 'single_template', 'marino_core_template_redirect' );

if( ! function_exists( 'marino_core_template_redirect' ) ){

    function marino_core_template_redirect( $single_template ){

        global $post;


        if( $post ){

            if( $post->post_type == 'marino_service' ){

                $single_template = MARINO_CORE_PLUGIN_TEMP . 'single-marino_service.php';

            }elseif( $post->post_type == 'marino_doctors' ){

                $single_template = MARINO_CORE_PLUGIN_TEMP . 'single-marino_doctor.php';
            }
        }

        return $single_template;
    }

}

/**
 * Archive Template
 */

add_filter( 'archive_template', 'marino_core_template_archive' );

if( ! function_exists( 'marino_core_template_archive' ) ){

    function marino_core_template_archive( $archive_template ){

        global $post;


        if( $post ){

            if( $post->post_type == 'marino_service' ){

                $archive_template = MARINO_CORE_PLUGIN_TEMP . 'archive-marino_service.php';

            }
        }

        return $archive_template;
    }

}

// Add Image Size

add_filter('wpcf7_autop_or_not', '__return_false');
add_image_size( 'marino_90X80', 90, 80, true );
add_image_size( 'marino_70X70', 70, 70, true );
add_image_size( 'marino_202x202', 202, 202, true );