<?php
    /**
     * Class For Builder
     */
    class MarinoBuilder{

        function __construct(){
            // register admin menus
        	add_action( 'admin_menu', [$this, 'register_settings_menus'] );

            // Custom Footer Builder With Post Type
			add_action( 'init',[ $this,'post_type' ],0 );

 		    add_action( 'elementor/frontend/after_enqueue_scripts', [ $this,'widget_scripts'] );

			add_filter( 'single_template', [ $this, 'load_canvas_template' ] );

            add_action( 'elementor/element/wp-page/document_settings/after_section_end', [ $this,'marino_add_elementor_page_settings_controls' ],10,2 );

		}

		public function widget_scripts( ) {
			wp_enqueue_script( 'marino-core',MARINO_PLUGDIRURI.'assets/js/marino-core.js',array( 'jquery' ),'1.0',true );
		}


        public function marino_add_elementor_page_settings_controls( \Elementor\Core\DocumentTypes\Page $page ){

			$page->start_controls_section(
                'marino_header_option',
                [
                    'label'     => __( 'Header Option', 'marino' ),
                    'tab'       => \Elementor\Controls_Manager::TAB_SETTINGS,
                ]
            );
			
			
            $page->add_control(
                'marino_header_style',
                [
                    'label'     => __( 'Header Option', 'marino' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => [
    					'prebuilt'             => __( 'Pre Built', 'marino' ),
    					'header_builder'       => __( 'Header Builder', 'marino' ),
    				],
                    'default'   => 'prebuilt',
                ]
			);
			
            $page->add_control(
                'marino_header_builder_option',
                [
                    'label'     => __( 'Header Name', 'marino' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => $this->marino_header_choose_option(),
                    'condition' => [ 'marino_header_style' => 'header_builder'],
                    'default'	=> ''
                ]
            );

            $page->end_controls_section();

            $page->start_controls_section(
                'marino_footer_option',
                [
                    'label'     => __( 'Footer Option', 'marino' ),
                    'tab'       => \Elementor\Controls_Manager::TAB_SETTINGS,
                ]
            );
            $page->add_control(
    			'marino_footer_choice',
    			[
    				'label'         => __( 'Enable Footer?', 'marino' ),
    				'type'          => \Elementor\Controls_Manager::SWITCHER,
    				'label_on'      => __( 'Yes', 'marino' ),
    				'label_off'     => __( 'No', 'marino' ),
    				'return_value'  => 'yes',
    				'default'       => 'yes',
    			]
    		);
            $page->add_control(
                'marino_footer_style',
                [
                    'label'     => __( 'Footer Style', 'marino' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => [
    					'prebuilt'             => __( 'Pre Built', 'marino' ),
    					'footer_builder'       => __( 'Footer Builder', 'marino' ),
    				],
                    'default'   => 'prebuilt',
                    'condition' => [ 'marino_footer_choice' => 'yes' ],
                ]
            );
            $page->add_control(
                'marino_footer_builder_option',
                [
                    'label'     => __( 'Footer Name', 'marino' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => $this->marino_footer_choose_option(),
                    'condition' => [ 'marino_footer_style' => 'footer_builder','marino_footer_choice' => 'yes' ],
                    'default'	=> ''
                ]
            );

			$page->end_controls_section();

        }

		public function register_settings_menus(){
			add_menu_page(
				esc_html__( 'Marino Builder', 'marino' ),
            	esc_html__( 'Marino Builder', 'marino' ),
				'manage_options',
				'marino',
				[$this,'register_settings_contents__settings'],
				'dashicons-admin-site',
				2
			);

			add_submenu_page('marino', esc_html__('Footer Builder', 'marino'), esc_html__('Footer Builder', 'marino'), 'manage_options', 'edit.php?post_type=marino_footer_build');
			add_submenu_page('marino', esc_html__('Header Builder', 'marino'), esc_html__('Header Builder', 'marino'), 'manage_options', 'edit.php?post_type=marino_header_build');
			add_submenu_page('marino', esc_html__('Tab Builder', 'marino'), esc_html__('Tab Builder', 'marino'), 'manage_options', 'edit.php?post_type=marino_tab_build');
		}

		// Callback Function
		public function register_settings_contents__settings(){
            echo '<h2>';
			    echo esc_html__( 'Welcome To Header And Footer Builder Of This Theme','marino' );
            echo '</h2>';
		}

		public function post_type() {

			$labels = array(
				'name'               => __( 'Footer', 'marino' ),
				'singular_name'      => __( 'Footer', 'marino' ),
				'menu_name'          => __( 'Marino Footer Builder', 'marino' ),
				'name_admin_bar'     => __( 'Footer', 'marino' ),
				'add_new'            => __( 'Add New', 'marino' ),
				'add_new_item'       => __( 'Add New Footer', 'marino' ),
				'new_item'           => __( 'New Footer', 'marino' ),
				'edit_item'          => __( 'Edit Footer', 'marino' ),
				'view_item'          => __( 'View Footer', 'marino' ),
				'all_items'          => __( 'All Footer', 'marino' ),
				'search_items'       => __( 'Search Footer', 'marino' ),
				'parent_item_colon'  => __( 'Parent Footer:', 'marino' ),
				'not_found'          => __( 'No Footer found.', 'marino' ),
				'not_found_in_trash' => __( 'No Footer found in Trash.', 'marino' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'marino_footer_build', $args );

			$labels = array(
				'name'               => __( 'Header', 'marino' ),
				'singular_name'      => __( 'Header', 'marino' ),
				'menu_name'          => __( 'Marino Header Builder', 'marino' ),
				'name_admin_bar'     => __( 'Header', 'marino' ),
				'add_new'            => __( 'Add New', 'marino' ),
				'add_new_item'       => __( 'Add New Header', 'marino' ),
				'new_item'           => __( 'New Header', 'marino' ),
				'edit_item'          => __( 'Edit Header', 'marino' ),
				'view_item'          => __( 'View Header', 'marino' ),
				'all_items'          => __( 'All Header', 'marino' ),
				'search_items'       => __( 'Search Header', 'marino' ),
				'parent_item_colon'  => __( 'Parent Header:', 'marino' ),
				'not_found'          => __( 'No Header found.', 'marino' ),
				'not_found_in_trash' => __( 'No Header found in Trash.', 'marino' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'marino_header_build', $args );

			$labels = array(
				'name'               => __( 'Tab', 'marino' ),
				'singular_name'      => __( 'Tab', 'marino' ),
				'menu_name'          => __( 'Marino Header Builder', 'marino' ),
				'name_admin_bar'     => __( 'Tab', 'marino' ),
				'add_new'            => __( 'Add New', 'marino' ),
				'add_new_item'       => __( 'Add New Tab', 'marino' ),
				'new_item'           => __( 'New Header', 'marino' ),
				'edit_item'          => __( 'Edit Tab', 'marino' ),
				'view_item'          => __( 'View Tab', 'marino' ),
				'all_items'          => __( 'All Header', 'marino' ),
				'search_items'       => __( 'Search Tab', 'marino' ),
				'parent_item_colon'  => __( 'Parent Tab:', 'marino' ),
				'not_found'          => __( 'No Header found.', 'marino' ),
				'not_found_in_trash' => __( 'No Header found in Trash.', 'marino' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'marino_tab_build', $args );
		}

		function load_canvas_template( $single_template ) {

			global $post;

			if ( 'marino_footer_build' == $post->post_type || 'marino_header_build' == $post->post_type || 'marino_tab_build' == $post->post_type ) {

				$elementor_2_0_canvas = ELEMENTOR_PATH . '/modules/page-templates/templates/canvas.php';

				if ( file_exists( $elementor_2_0_canvas ) ) {
					return $elementor_2_0_canvas;
				} else {
					return ELEMENTOR_PATH . '/includes/page-templates/canvas.php';
				}
			}

			return $single_template;
		}

        public function marino_footer_choose_option(){

			$marino_post_query = new WP_Query( array(
				'post_type'			=> 'marino_footer_build',
				'posts_per_page'	    => -1,
			) );

			$marino_builder_post_title = array();
			$marino_builder_post_title[''] = __('Select a Footer','Marino');

			while( $marino_post_query->have_posts() ) {
				$marino_post_query->the_post();
				$marino_builder_post_title[ get_the_ID() ] =  get_the_title();
			}
			wp_reset_postdata();

			return $marino_builder_post_title;

		}
		
		public function marino_header_choose_option(){

			$marino_post_query = new WP_Query( array(
				'post_type'			=> 'marino_header_build',
				'posts_per_page'	    => -1,
			) );

			$marino_builder_post_title = array();
			$marino_builder_post_title[''] = __('Select a Header','Marino');

			while( $marino_post_query->have_posts() ) {
				$marino_post_query->the_post();
				$marino_builder_post_title[ get_the_ID() ] =  get_the_title();
			}
			wp_reset_postdata();

			return $marino_builder_post_title;

        }

    }

    $builder_execute = new MarinoBuilder();