<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;

/**
 *
 * Section Title Widget .
 *
 */
class Marino_Section_Title_Widget extends Widget_Base {

	public function get_name() {
		return 'marinosectiontitle';
	}

	public function get_title() {
		return __('Section Title', 'marino');
	}

	public function get_icon() {
		return 'eicon-code';
	}

	public function get_categories() {
		return ['marino'];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_title_section',
			[
				'label'		 	=> __('Section Title', 'marino'),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'section_title_style',
			[
				'label' 	=> __('Title Style', 'marino'),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __('Style One', 'marino'),
					'2' 		=> __('Style Two', 'marino'),
				],
			]
		);
		$this->add_control(
			'section_title',
			[
				'label' 	=> __('Section Title', 'marino'),
				'type' 		=> Controls_Manager::TEXTAREA,
				'default'  	=> __('Section Title', 'marino')
			]
		);
		$this->add_control(
			'section_title_tag',
			[
				'label' 	=> __('Title Tag', 'marino'),
				'type' 		=> Controls_Manager::SELECT,
				'options' 	=> [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h3',
			]
		);

		$this->add_control(
			'section_subtitle',
			[
				'label' 	=> __('Section Subtitle', 'marino'),
				'type' 		=> Controls_Manager::TEXTAREA,
				'default'  	=> __('Section Subtitle', 'marino')
			]
		);

		$this->add_control(
			'section_subtitle_tag',
			[
				'label' 	=> __('Subitle Tag', 'marino'),
				'type' 		=> Controls_Manager::SELECT,
				'options' 	=> [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
					'p'  => 'P',
				],
				'default' 	=> 'h2',
				'condition'	=> ['section_subtitle!' => '']
			]
		);

		$this->add_control(
			'section_description',
			[
				'label' 	=> __('Section Description', 'marino'),
				'type' 		=> Controls_Manager::TEXTAREA,
				'default'  	=> __('Section Description', 'marino')
			]
		);

		$this->add_responsive_control(
			'section_title_align',
			[
				'label' 		=> __('Alignment', 'marino'),
				'type' 			=> Controls_Manager::CHOOSE,
				'options' 		=> [
					'left' 	=> [
						'title' 		=> __('Left', 'marino'),
						'icon' 			=> 'eicon-text-align-left',
					],
					'center' 	=> [
						'title' 		=> __('Center', 'marino'),
						'icon' 			=> 'eicon-text-align-center',
					],
					'right' 	=> [
						'title' 		=> __('Right', 'marino'),
						'icon' 			=> 'eicon-text-align-right',
					],
				],
				'default' 	=> 'left',
				'toggle' 	=> true,
				'prefix_class'	=> 'marino-section-title ',
				'selectors' 	=> [
					'{{WRAPPER}} .title-area' => 'text-align: {{VALUE}};',
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_title_style_section',
			[
				'label' => __('Section Title Style', 'marino'),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'section_wrapper_margin',
			[
				'label' 		=> __('Section Wrapper Margin', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .title-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->add_responsive_control(
			'section_wrapper_padding',
			[
				'label' 		=> __('Section Wrapper Padding', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .title-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' 	=> 'after'
			]
		);

		$this->add_control(
			'section_title_color',
			[
				'label' 	=> __('Section Title Color', 'marino'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .title-selector' => 'color: {{VALUE}}',
				],
				'condition' => [
					'section_title!'    => ''
				]
			]
		);

		$this->add_control(
			'section_title_before-color',
			[
				'label' 	=> __('Section Shape Bg Color', 'marino'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-line::before' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'section_title!'    => ''
				]
			]
		);
		$this->add_control(
			'section_title_before-color-top',
			[
				'label' 	=> __('Section Shape Color', 'marino'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-line::after' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'section_title!'    => ''
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'section_title_typography',
				'label' 	=> __('Section Title Typography', 'marino'),
				'selector' 	=> '{{WRAPPER}} .title-selector',
				'condition' => [
					'section_title!'    => ''
				]
			]
		);

		$this->add_responsive_control(
			'section_title_margin',
			[
				'label' 		=> __('Section Title Margin', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .title-selector' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'section_title!'    => ''
				]
			]
		);

		$this->add_responsive_control(
			'section_title_padding',
			[
				'label' 		=> __('Section Title Padding', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .title-selector' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' 	=> [
					'section_title!'    => ''
				]
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'border',
				'label' 	=> __('Border', 'marino'),
				'selector' 	=> '{{WRAPPER}} .title-selector',
				'condition' => [
					'section_title!'    => ''
				],
				'separator' => 'after'
			]
		);

		$this->add_control(
			'section_subtitle_color',
			[
				'label' 		=> __('Section Subtitle Color', 'marino'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .subtitle-selector' => 'color: {{VALUE}}',
				],
				'condition' 	=> [
					'section_subtitle!'    => ''
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'section_subtitle_typography',
				'label' 	=> __('Section Subtitle Typography', 'marino'),
				'selector' 	=> '{{WRAPPER}} .subtitle-selector',
				'condition' => [
					'section_subtitle!'    => ''
				],
			]
		);

		$this->add_responsive_control(
			'section_subtitle_margin',
			[
				'label' 		=> __('Section Subtitle Margin', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .subtitle-selector' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'section_subtitle!'    => ''
				],
			]
		);
		$this->add_control(
			'section_description_color',
			[
				'label' 	=> __('Section Description Color', 'marino'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .title-area .desc' => 'color: {{VALUE}}',
				],
				'condition' => [
					'section_description!'    => ''
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'section_description_typography',
				'label' 	=> __('Section Description Typography', 'marino'),
				'selector' 	=> '{{WRAPPER}} .title-area .desc',
				'condition' => [
					'section_description!'    => ''
				],
			]
		);

		$this->add_responsive_control(
			'section_description_margin',
			[
				'label' 		=> __('Section Description Margin', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .title-area .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' 	=> [
					'section_description!'    => ''
				],
			]
		);
		$this->end_controls_section();
	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		$this->add_render_attribute('wrapper', 'class', 'title-area');
		$this->add_render_attribute('wrapper', 'class', $settings['section_title_align']);

		echo '<!-- Section Title -->';
		echo '<div ' . $this->get_render_attribute_string('wrapper') . ' >';

		if (!empty($settings['section_subtitle'])) {
			echo '<' . esc_attr($settings['section_subtitle_tag']) . ' class="sec-subtitle subtitle-selector">';
			echo wp_kses_post($settings['section_subtitle']) . '</' . esc_attr($settings['section_subtitle_tag']) . '>';
		}
		if (!empty($settings['section_title'])) {
			echo '<' . esc_attr($settings['section_title_tag']) . ' class="sec-title title-selector h1">' . wp_kses_post($settings['section_title']) . '</' . esc_attr($settings['section_title_tag']) . '>';
		}

		if (!empty($settings['section_description'])) {
			echo marino_paragraph_tag(array(
				'text'	=> wp_kses_post($settings['section_description']),
				'class'	=> 'desc'
			));
		}
		if ($settings['section_title_style'] == '1') {
			echo '<div class="sec-line"></div>';
		}
		echo '</div>';
		echo '<!-- End Section Title -->';
	}
}
