<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;

/**
 *
 * Slider Widget .
 *
 */
class Marino_Testimonial_Slider extends Widget_Base {

	public function get_name() {
		return 'marinotestimonialslider';
	}

	public function get_title() {
		return __('Testimonial Slider', 'marino');
	}

	public function get_icon() {
		return 'eicon-code';
	}

	public function get_categories() {
		return ['marino'];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'testimonial_slider_section',
			[
				'label' 	=> __('Testimonial Slider', 'marino'),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'testimonial_style',
			[
				'label' 		=> __('Testimonial Style', 'marino'),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options'		=> [
					'1'  			=> __('Style One', 'marino'),
					'2' 			=> __('Style Two', 'marino'),
					'3' 			=> __('Style Three', 'marino'),
					'4' 			=> __('Style Four', 'marino'),
				],
			]
		);
		$this->add_control(
			'title',
			[
				'label'         => __('Title', 'marino'),
				'type'          => Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default'       => __('What Clients Say?', 'marino'),
				'label_block'   => true,
			]
		);
		$this->add_control(
			'sub_title',
			[
				'label'         => __('Sub Title', 'marino'),
				'type'          => Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default'       => __('Testimonials', 'marino'),
				'label_block'   => true,
			]
		);
		$this->add_control(
			'button_text',
			[
				'label' 	=> esc_html__('Button Text', 'marino'),
				'type' 		=> Controls_Manager::TEXT,
				'default'  	=> esc_html__('Button Text', 'marino'),
				'condition'    => ['testimonial_style' => ['3']]
			]
		);

		$this->add_control(
			'button_link',
			[
				'label' 		=> esc_html__('Link', 'marino'),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__('https://your-link.com', 'marino'),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
				'condition'    => ['testimonial_style' => ['3']]
			]
		);

		$this->add_control(
			'bg_image',
			[
				'label'     => __('Background Image', 'marino'),
				'type'      => Controls_Manager::MEDIA,
				'default' 	=> [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition'    => ['testimonial_style!' => ['4']]
			]
		);


		$repeater = new Repeater();

		$repeater->add_control(
			'client_avater_image',
			[
				'label' 		=> __('Client Avater Image', 'marino'),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'client_image',
			[
				'label' 		=> __('Client Image', 'marino'),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'client_name',
			[
				'label' 		=> __('Client Name', 'marino'),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __('Rubaida Kanom', 'marino'),
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'client_designation',
			[
				'label' 		=> __('Client Designation', 'marino'),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __('Chef Leader', 'marino'),
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'client_feedback',
			[
				'label' 		=> __('Client Feedback', 'marino'),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __('Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco ', 'marino'),
				'label_block' 	=> true,
			]
		);


		$this->add_control(
			'slides',
			[
				'label' 		=> __('Slides', 'marino'),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'client_name' 		=> __('Marko Polo', 'marino'),
						'client_feedback' 	=> __('“Fishing has been delighted in for a great many years and must fuse three angles: fishing hardware, style, and area to gain a fishing success.In request to angle you have to get the best possible gear: a bar, draw, and a couple of different frill”', 'marino'),
						'client_image' 		=> Utils::get_placeholder_image_src(),
					],
					[
						'client_name' 		=> __('Vivi Marian', 'marino'),
						'client_feedback' 	=> __('“Fishing has been delighted in for a great many years and must fuse three angles: fishing hardware, style, and area to gain a fishing success.In request to angle you have to get the best possible gear: a bar, draw, and a couple of different frill”', 'marino'),
						'client_image' 		=> Utils::get_placeholder_image_src(),
					],
					[
						'client_name' 		=> __('Customer', 'marino'),
						'client_feedback' 	=> __('“Fishing has been delighted in for a great many years and must fuse three angles: fishing hardware, style, and area to gain a fishing success.In request to angle you have to get the best possible gear: a bar, draw, and a couple of different frill”', 'marino'),
						'client_image' 		=> Utils::get_placeholder_image_src(),
					],
				],
				'title_field' 	=> '{{{ client_name }}}',
			]
		);

		$this->end_controls_section();

		//-------------------------------- heading subtitle-------------------------------------------------//

		$this->start_controls_section(
			'heading_style_section',
			[
				'label' 	=> __('Heading Subtitle', 'marino'),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'heading_subtitle_color',
			[
				'label' 		=> __('Subtitle Color', 'marino'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testi_style1 .sec-subtitle' => 'color: {{VALUE}}!important',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'heading_subtitle_typography',
				'label' 	=> __('Subtitle Typography', 'marino'),
				'selector' 	=> '{{WRAPPER}} .testi_style1 .sec-subtitle',
			]
		);

		$this->add_responsive_control(
			'heading_subtitle_margin',
			[
				'label' 		=> __('Subtitle Margin', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .testi_style1 .sec-subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'heading_subtitle_padding',
			[
				'label' 		=> __('Subtitle Padding', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .testi_style1 .sec-subtitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->end_controls_section();


		//-------------------------------- heading titel-------------------------------------------------//

		$this->start_controls_section(
			'heading_titel_style_section',
			[
				'label' 	=> __('Heading Title', 'marino'),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'heading_title_color',
			[
				'label' 		=> __('Title Color', 'marino'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testi_style1 .sec_title' => 'color: {{VALUE}}!important',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'heading_title_typography',
				'label' 	=> __('Title Typography', 'marino'),
				'selector' 	=> '{{WRAPPER}} .testi_style1 .sec_title',
			]
		);

		$this->add_responsive_control(
			'heading_title_margin',
			[
				'label' 		=> __('Title Margin', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .testi_style1 .sec_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'heading_title_padding',
			[
				'label' 		=> __('Title Padding', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .testi_style1 .sec_title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->end_controls_section();
		//-------------------------------- Summary titel-------------------------------------------------//

		$this->start_controls_section(
			'summary_style_section',
			[
				'label' 	=> __('Summary', 'marino'),
				'tab' 		=> Controls_Manager::TAB_STYLE,
				'condition'    => ['testimonial_style' => ['3']]
			]
		);

		$this->add_control(
			'summary_color',
			[
				'label' 		=> __('Color', 'marino'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testi_style1 .testi_text' => 'color: {{VALUE}}!important',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'summary_typography',
				'label' 	=> __('Summary Typography', 'marino'),
				'selector' 	=> '{{WRAPPER}} .testi_style1 .testi_text',
			]
		);

		$this->add_responsive_control(
			'summary_margin',
			[
				'label' 		=> __('Summary Margin', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .testi_style1 .testi_text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'summary_padding',
			[
				'label' 		=> __('Summary Padding', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .testi_style1 .testi_text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->end_controls_section();

		//-------------------------------- name-------------------------------------------------//

		$this->start_controls_section(
			'testimonial_slider_client_name_style_section',
			[
				'label' 	=> __('Client Name', 'marino'),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'testimonial_slider_client_name_color',
			[
				'label' 		=> __('Client Name Color', 'marino'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testi_style1 .testi_author,{{WRAPPER}} .testimonial-layout1 .testi-content .testi-desc .testi_author' => 'color: {{VALUE}}!important',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'testimonial_slider_client_name_typography',
				'label' 	=> __('Client Name Typography', 'marino'),
				'selector' 	=> '{{WRAPPER}} .testi_style1 .testi_author,{{WRAPPER}} .testimonial-layout1 .testi-content .testi-desc .testi_author',
			]
		);

		$this->add_responsive_control(
			'testimonial_slider_client_name_margin',
			[
				'label' 		=> __('Client Name Margin', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .testi_style1 .testi_author,{{WRAPPER}} .testimonial-layout1 .testi-content .testi-desc .testi_author' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'testimonial_slider_client_name_padding',
			[
				'label' 		=> __('Client Name Padding', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .testi_style1 .testi_author,{{WRAPPER}} .testimonial-layout1 .testi-content .testi-desc .testi_author' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->end_controls_section();

		//-------------------------------- feddback-------------------------------------------------//

		$this->start_controls_section(
			'testimonial_slider_client_feedback_style_section',
			[
				'label' 	=> __('Client Feedback', 'marino'),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'testimonial_slider_client_feedback_color',
			[
				'label' 	=> __('Client Feedback Color', 'marino'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testi_style1 .testi_text,{{WRAPPER}} .testimonial-layout1 .testi_text p' => 'color: {{VALUE}} !important',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'testimonial_slider_client_feedback_typography',
				'label' 	=> __('Client Feedback Typography', 'marino'),
				'selector' 	=> '{{WRAPPER}} .testi_style1 .testi_text,{{WRAPPER}} .testimonial-layout1 .testi_text p',
			]
		);

		$this->add_responsive_control(
			'testimonial_slider_client_feedback_margin',
			[
				'label' 		=> __('Client Feedback Margin', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .testi_style1 .testi_text,{{WRAPPER}} .testimonial-layout1 .testi_text p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'testimonial_slider_client_feedback_padding',
			[
				'label' 		=> __('Client Feedback Padding', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .testi_style1 .testi_text, {{WRAPPER}} .testimonial-layout1 .testi_text p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->end_controls_section();

		//-------------------------------- designation-------------------------------------------------//

		$this->start_controls_section(
			'testimonial_slider_designation_style_section',
			[
				'label' 		=> __('Designation', 'marino'),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'testimonial_slider_designation_color',
			[
				'label' 	=> __('Client Designation Color', 'marino'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testi_style1 .testi_degi,{{WRAPPER}} .testimonial-layout1 .testi-content .testi-desc .testi_degi' => 'color: {{VALUE}} !important',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'testimonial_slider_designation_typography',
				'label' 	=> __('Client Designation Typography', 'marino'),
				'selector' 	=> '{{WRAPPER}} .testi_style1 .testi_degi,{{WRAPPER}} .testimonial-layout1 .testi-content .testi-desc .testi_degi',
			]
		);

		$this->add_responsive_control(
			'testimonial_slider_designation_margin',
			[
				'label' 		=> __('Client Designation Margin', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .testi_style1 .testi_degi,{{WRAPPER}} .testimonial-layout1 .testi-content .testi-desc .testi_degi' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'testimonial_slider_designation_padding',
			[
				'label' 		=> __('Client Designation Padding', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .testi_style1 .testi_degi,{{WRAPPER}} .testimonial-layout1 .testi-content .testi-desc .testi_degi' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
		$this->end_controls_section();
	}

	protected function render() {

		$settings = $this->get_settings_for_display();

?>
		<?php if ($settings['testimonial_style'] == '1' || $settings['testimonial_style'] == '2') { ?>
			<section class="testimonial-wrapper">
				<div class="vs-container1">
					<?php if ($settings['testimonial_style'] == '1') { ?>
						<div class="testi_wrap1 background-image" style="background-image:url(<?php echo esc_url($settings['bg_image']['url']); ?>)">

							<div class="row gx-0 align-items-center">
								<div class="col-lg-6">

									<div class="testi_style1">

										<?php if (!empty($settings['sub_title'])) : ?>
											<span class="sec-subtitle">
												<?php echo esc_html($settings['sub_title']); ?>
											</span>
										<?php endif; ?>

										<?php if (!empty($settings['title'])) : ?>
											<h2 class="sec_title h3">
												<?php echo esc_html($settings['title']); ?>
											</h2>
										<?php endif; ?>

										<div id="testis_4_1">

											<?php foreach ($settings['slides'] as $slide) : ?>
												<div class="testi_inner">
													<div class="testi_quote">
														<i class="fas fa-quote-right"></i>
													</div>
													<?php if (!empty($slide['client_feedback'])) : ?>
														<p class="testi_text">
															<?php echo esc_html($slide['client_feedback']); ?>
														</p>
													<?php endif; ?>

													<?php if (!empty($slide['client_name'])) : ?>
														<h3 class="testi_author"><?php echo esc_html($slide['client_name']); ?></h3>
													<?php endif; ?>

													<?php if (!empty($slide['client_designation'])) : ?>
														<span class="testi_degi"><?php echo esc_html($slide['client_designation']); ?></span>
													<?php endif; ?>

												</div>
											<?php endforeach; ?>

										</div>
									</div>
								</div>
								<div class="col-lg-auto position-relative">
									<div class="testi_avater1">
										<div id="testis_4_2">
											<?php foreach ($settings['slides'] as $slide) : ?>
												<?php if (!empty($slide['client_avater_image']['url'])) : ?>
													<div>
														<div class="avater">
															<?php echo marino_img_tag(array(
																'url'	=> esc_url($slide['client_avater_image']['url']),
																'alt'   => 'author',
															));
															?>
														</div>
													</div>
												<?php endif; ?>
											<?php endforeach; ?>
										</div>
									</div>
								</div>

								<div class="col-lg-6">
									<div class="testi-img1" id="testis_4_3">
										<?php foreach ($settings['slides'] as $slide) : ?>
											<?php if (!empty($slide['client_image']['url'])) : ?>
												<div>
													<?php echo marino_img_tag(array(
														'url'	=> esc_url($slide['client_image']['url']),
														'alt'   => 'testimonial',
													));
													?>
												</div>
											<?php endif; ?>
										<?php endforeach; ?>
									</div>
								</div>
							</div>
						</div>
					<?php } else { ?>
						<div class="testi_wrap2">

							<div class="row gx-0 align-items-center">
								<div class="col-lg-6">
									<div class="testi-img1" id="testis_4_3">
										<?php foreach ($settings['slides'] as $slide) : ?>
											<?php if (!empty($slide['client_image']['url'])) : ?>
												<div>
													<?php echo marino_img_tag(array(
														'url'	=> esc_url($slide['client_image']['url']),
														'alt'   => 'testimonial',
													));
													?>
												</div>
											<?php endif; ?>
										<?php endforeach; ?>
									</div>
								</div>
								<div class="col-lg-auto position-relative">
									<div class="testi_avater1 style2">
										<div id="testis_4_2">
											<?php foreach ($settings['slides'] as $slide) : ?>
												<?php if (!empty($slide['client_avater_image']['url'])) : ?>
													<div>
														<div class="avater">
															<?php echo marino_img_tag(array(
																'url'	=> esc_url($slide['client_avater_image']['url']),
																'alt'   => 'author',
															));
															?>
														</div>
													</div>
												<?php endif; ?>
											<?php endforeach; ?>
										</div>
									</div>
								</div>
								<div class="col-lg-6">

									<div class="testi_style1 style2">
										<div class="title-area">
											<?php if (!empty($settings['sub_title'])) : ?>
												<span class="sec-subtitle">
													<?php echo esc_html($settings['sub_title']); ?>
												</span>
											<?php endif; ?>

											<?php if (!empty($settings['title'])) : ?>
												<h2 class="sec_title h3">
													<?php echo esc_html($settings['title']); ?>
												</h2>
											<?php endif; ?>
										</div>
										<div id="testis_4_1">

											<?php foreach ($settings['slides'] as $slide) : ?>
												<div class="testi_inner">
													<div class="testi_quote">
														<i class="fas fa-quote-right"></i>
													</div>
													<?php if (!empty($slide['client_feedback'])) : ?>
														<p class="testi_text">
															<?php echo esc_html($slide['client_feedback']); ?>
														</p>
													<?php endif; ?>

													<?php if (!empty($slide['client_name'])) : ?>
														<h3 class="testi_author"><?php echo esc_html($slide['client_name']); ?></h3>
													<?php endif; ?>

													<?php if (!empty($slide['client_designation'])) : ?>
														<span class="testi_degi"><?php echo esc_html($slide['client_designation']); ?></span>
													<?php endif; ?>

												</div>
											<?php endforeach; ?>

										</div>
									</div>
								</div>
							</div>
						</div>
					<?php } ?>
				</div>
			</section>
		<?php
		} elseif ($settings['testimonial_style'] == '3') { ?>
			<section class="testimonial-layout1 space-top" data-bg-src="<?php echo esc_url($settings['bg_image']['url']); ?>">
				<div class="container">
					<div class="testi_wra1">
						<div class="row g-5 align-items-center">
							<div class="col-xl-6 col-lg-6 col-12 mt-0">
								<div class="testi_style1">
									<div class="title-area mb-4 wow fadeInUp wow-animated" data-wow-delay="0.3s">
										<?php if (!empty($settings['sub_title'])) : ?>
											<span class="sec-subtitle">
												<?php echo esc_html($settings['sub_title']); ?>
											</span>
										<?php endif; ?>
										<?php if (!empty($settings['title'])) : ?>
											<h2 class="sec_title h3">
												<?php echo esc_html($settings['title']); ?>
											</h2>
										<?php endif; ?>
										<div class="sec-line"></div>
									</div>
									<div id="testis_4_1">
										<?php foreach ($settings['slides'] as $slide) : ?>
											<div class="testi_inner">
												<?php if (!empty($slide['client_feedback'])) : ?>
													<p class="testi_text">
														<?php echo esc_html($slide['client_feedback']); ?>
													</p>
												<?php endif; ?>
												<?php if (!empty($settings['button_text'])) : ?>
													<a href="<?php echo esc_url($settings['button_link']['url']) ?>" class="vs-btn"><?php echo esc_html($settings['button_text']) ?></a>
												<?php endif; ?>
											</div>
										<?php endforeach; ?>
									</div>
								</div>
							</div>
							<div class="col-xl-6 col-12">
								<div class="testi-items" id="testis_4_4">
									<?php foreach ($settings['slides'] as $slide) : ?>
										<div class="testi-item">
											<div class="testi-content">
												<?php if (!empty($slide['client_avater_image']['url'])) : ?>
													<div class="testi-img">
														<?php echo marino_img_tag(array(
															'url'	=> esc_url($slide['client_avater_image']['url']),
															'alt'   => 'author',
														));
														?>
														<span class="testi_quote"><i class="fas fa-quote-right"></i></span>
													</div>
												<?php endif; ?>
												<div class="testi-inner">
													<?php if (!empty($slide['client_feedback'])) : ?>
														<div class="testi-text">
															<p><?php echo esc_html($slide['client_feedback']); ?></p>
														</div>
													<?php endif; ?>

													<div class="testi-desc">
														<div>
															<?php if (!empty($slide['client_name'])) : ?>
																<h3 class="testi_author"><?php echo esc_html($slide['client_name']); ?></h3>
															<?php endif; ?>

															<?php if (!empty($slide['client_designation'])) : ?>
																<span class="testi_degi"><?php echo esc_html($slide['client_designation']); ?></span>
															<?php endif; ?>
														</div>
														<div class="testi-rating">
															<i class="fas fa-star"></i>
															<i class="fas fa-star"></i>
															<i class="fas fa-star"></i>
															<i class="fas fa-star"></i>
															<i class="fas fa-star"></i>
														</div>
													</div>
												</div>
											</div>
										</div>
									<?php endforeach; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>
		<?php } elseif ($settings['testimonial_style'] == '4') { ?>
			<section class="testimonial-layout1 style2 arrow-wrap">
				<div class="container">
					<div class="row vs-carousel" data-arrows="true" data-wow-delay="0.4s" data-slide-show="2" data-lg-slide-show="1" data-md-slide-show="1" data-center-mode="true" data-xl-center-mode="true" data-ml-center-mode="true" data-lg-center-mode="true" data-md-center-mode="true" data-sm-center-mode="true">
						<?php foreach ($settings['slides'] as $slide) : ?>
							<div class="col-auto">
								<div class="testi-item">
									<div class="testi-content">
										<?php if (!empty($slide['client_avater_image']['url'])) : ?>
											<div class="testi-img">
												<?php echo marino_img_tag(array(
													'url'	=> esc_url($slide['client_avater_image']['url']),
													'alt'   => 'author',
												));
												?>
												<span class="testi_quote"><i class="fas fa-quote-right"></i></span>
											</div>
										<?php endif; ?>
										<div class="testi-inner">
											<?php if (!empty($slide['client_feedback'])) : ?>
												<div class="testi-text">
													<p><?php echo esc_html($slide['client_feedback']); ?></p>
												</div>
											<?php endif; ?>
											<div class="testi-desc">
												<div>
													<h3 class="testi_author">amit Parker</h3>
													<span class="testi_degi">Lion Hunter</span>
												</div>
												<div class="testi-rating">
													<i class="fas fa-star"></i>
													<i class="fas fa-star"></i>
													<i class="fas fa-star"></i>
													<i class="fas fa-star"></i>
													<i class="fas fa-star"></i>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
			</section>
<?php }
	}
}
