<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;

/**
 *
 * Team Widget .
 *
 */
class Marino_Team_Member extends Widget_Base {

	public function get_name() {
		return 'marinoteammember';
	}

	public function get_title() {
		return __('Team Member', 'marino');
	}

	public function get_icon() {
		return 'eicon-code';
	}

	public function get_categories() {
		return ['marino'];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'team_section',
			[
				'label'     => __('Team Member', 'marino'),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'team_style',
			[
				'label' 		=> __('Team Style', 'marino'),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options'		=> [
					'1'  			=> __('Style One', 'marino'),
					'2' 			=> __('Style Two', 'marino'),
					'3' 			=> __('Style Three', 'marino'),
				],
			]
		);

		$this->add_control(
			'slider_grid',
			[
				'label' 		=> __('Slider Or Grid', 'marino'),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  			=> __('Slider', 'marino'),
					'2' 			=> __('Grid', 'marino')
				],
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'team_member_image',
			[
				'label'     => __('Team Member Image', 'marino'),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'person_name',
			[
				'label'         => __('Person Name', 'marino'),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __('John Steven', 'marino'),
				'label_block'   => true,
			]
		);
		$repeater->add_control(
			'person_details_url',
			[
				'label' 		=> __('Person Details Url', 'marino'),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __('https://your-link.com', 'marino'),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);
		$repeater->add_control(
			'person_designation',
			[
				'label'         => __('Person Designation', 'marino'),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __('Founder', 'marino'),
				'label_block'   => true,
			]
		);
		$repeater->add_control(
			'social_icon_one',
			[
				'label' 		=> __('Social Icon One', 'marino'),
				'type' 			=> Controls_Manager::ICONS,
				'default' 		=> [
					'value' 		=> 'fab fa-facebook-f',
					'library' 		=> 'solid',
				],
			]
		);
		$repeater->add_control(
			'social_icon_one_link',
			[
				'label' 		=> __('Social Icon Link One', 'marino'),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __('https://your-link.com', 'marino'),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> 'www.facebook.com',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);
		$repeater->add_control(
			'social_icon_two',
			[
				'label' 		=> __('Social Icon Two', 'marino'),
				'type' 			=> Controls_Manager::ICONS,
				'default' 		=> [
					'value' 		=> 'fab fa-twitter',
					'library' 		=> 'solid',
				],
			]
		);
		$repeater->add_control(
			'social_icon_two_link',
			[
				'label' 		=> __('Social Icon Link Two', 'marino'),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __('https://your-link.com', 'marino'),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> 'www.twitter.com',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);
		$repeater->add_control(
			'social_icon_three',
			[
				'label' 		=> __('Social Icon Three', 'marino'),
				'type' 			=> Controls_Manager::ICONS,
				'default' 		=> [
					'value' 		=> 'fab fa-instagram',
					'library' 		=> 'solid',
				],
			]
		);
		$repeater->add_control(
			'social_icon_three_link',
			[
				'label' 		=> __('Social Icon Link Three', 'marino'),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __('https://your-link.com', 'marino'),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> 'www.instagram.com',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);
		$repeater->add_control(
			'social_icon_four',
			[
				'label' 		=> __('Social Icon Four', 'marino'),
				'type' 			=> Controls_Manager::ICONS,
				'default' 		=> [
					'value' 		=> 'fab fa-linkedin',
					'library' 		=> 'solid',
				],
			]
		);
		$repeater->add_control(
			'social_icon_four_link',
			[
				'label' 		=> __('Social Icon Link Four', 'marino'),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __('https://your-link.com', 'marino'),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> 'www.linkedin.com',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);

		$repeater->add_control(
			'email',
			[
				'label'         => __('Email', 'marino'),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __('info@example.com', 'marino'),
				'label_block'   => true,
			]
		);

		$this->add_control(
			'slides',
			[
				'label' 		=> __('Team Member', 'marino'),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'image' 	=> Utils::get_placeholder_image_src(),
					],
					[
						'image' 	=> Utils::get_placeholder_image_src(),
					],
				],
				'title_field' 	=> '{{person_name}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'slider_control_section',
			[
				'label' 		=> __('Slider Control', 'marino'),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'slide_to_show',
			[
				'label' 		=> __('Slide To Show', 'marino'),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> ['px'],
				'range' 		=> [
					'px' 			=> [
						'min' 			=> 0,
						'max' 			=> 10,
						'step'			=> 1,
					],
				],
				'default' 	=> [
					'unit' 		=> 'px',
					'size' 		=> 3,
				],
			]
		);
		$this->add_control(
			'slide_to_show1500',
			[
				'label' 		=> __('Slide To Show 1500', 'marino'),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> ['px'],
				'range' 		=> [
					'px' 			=> [
						'min' 			=> 0,
						'max' 			=> 10,
						'step'			=> 1,
					],
				],
				'default' 	=> [
					'unit' 		=> 'px',
					'size' 		=> 3,
				],
			]
		);
		$this->add_control(
			'slide_to_show1200',
			[
				'label' 		=> __('Slide To Show 1200', 'marino'),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> ['px'],
				'range' 		=> [
					'px' 			=> [
						'min' 			=> 0,
						'max' 			=> 10,
						'step'			=> 1,
					],
				],
				'default' 	=> [
					'unit' 		=> 'px',
					'size' 		=> 3,
				],
			]
		);
		$this->add_control(
			'slide_to_show992',
			[
				'label' 		=> __('Slide To Show 992', 'marino'),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> ['px'],
				'range' 		=> [
					'px' 			=> [
						'min' 			=> 0,
						'max' 			=> 10,
						'step'			=> 1,
					],
				],
				'default' 	=> [
					'unit' 		=> 'px',
					'size' 		=> 2,
				],
			]
		);
		$this->add_control(
			'slide_to_show768',
			[
				'label' 		=> __('Slide To Show 768', 'marino'),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> ['px'],
				'range' 		=> [
					'px' 			=> [
						'min' 			=> 0,
						'max' 			=> 10,
						'step'			=> 1,
					],
				],
				'default' 	=> [
					'unit' 		=> 'px',
					'size' 		=> 2,
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'general',
			[
				'label' 	=> __('General', 'marino'),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'social_icon_color',
			[
				'label' 		=> __('Social Icon Color', 'marino'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .team-style1 .team-social a' => 'color: {{VALUE}}',
				]
			]
		);

		$this->add_control(
			'social_icon_hover_color',
			[
				'label' 		=> __('Social Icon Hover Color', 'marino'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .team-style1 .team-social a:hover i' => 'color: {{VALUE}}',
				]
			]
		);

		$this->add_control(
			'social_icon_bg_color',
			[
				'label' 		=> __('Social Icon Bg Color', 'marino'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .team-style1 .team-links' => 'background-color: {{VALUE}}',
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'team_member_style_option',
			[
				'label' 	=> __('Team Member Style', 'marino'),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'person_name_color',
			[
				'label' 		=> __('Person Name Color', 'marino'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .team-style1 .team-content .team-name,{{wrapper}} .team_style2 .team_name,{{wrapper}} .team-style2 .team-content .team-name' => 'color: {{VALUE}}',
				]
			]
		);
		$this->add_control(
			'person_name_color_hover',
			[
				'label' 		=> __('Person Name Color Hover', 'marino'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .team-style1 .team-content .team-name,{{wrapper}} .team_style2 .team_name a:hover,,{{wrapper}} .team-style2 .team-content .team-name a:hover' => 'color: {{VALUE}}',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'          => 'person_name_typography',
				'label'         => __('Person Name Typography', 'marino'),
				'selector'      => '{{WRAPPER}} .team-style1 .team-content .team-name,{{wrapper}} .team_style2 .team_name',
			]
		);
		$this->add_responsive_control(
			'person_name_margin',
			[
				'label'         => __('Person Name Margin', 'marino'),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => ['px', '%', 'em'],
				'selectors'     => [
					'{{WRAPPER}} .team-style1 .team-content .team-name,{{wrapper}} .team_style2 .team_name,{{WRAPPER}} .team-style2 .team-content .team-degi' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'person_name_padding',
			[
				'label'         => __('Person Name Padding', 'marino'),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => ['px', '%', 'em'],
				'selectors'     => [
					'{{WRAPPER}} .team-style1 .team-content .team-name,{{wrapper}} .team_style2 .team_name,{{WRAPPER}} .team-style2 .team-content .team-degi' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'		=> 'after',
			]
		);
		$this->add_control(
			'person_designation_color',
			[
				'label' 		=> __('Person Designation Color', 'marino'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .team-style1 .team-content .team-degi,{{wrapper}} .team_style2 .team_degi,{{WRAPPER}} .team-style2 .team-content .team-degi' => 'color: {{VALUE}}',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'          => 'person_designation_typography',
				'label'         => __('Person Designation Typography', 'marino'),
				'selector'      => '{{WRAPPER}} .team-style1 .team-content .team-degi,{{wrapper}} .team_style2 .team_degi,{{WRAPPER}} .team-style2 .team-content .team-degi',
			]
		);
		$this->add_responsive_control(
			'person_designation_margin',
			[
				'label'         => __('Person Designation Margin', 'marino'),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => ['px', '%', 'em'],
				'selectors'     => [
					'{{WRAPPER}} .team-style1 .team-content .team-degi,{{wrapper}} .team_style2 .team_degi,{{WRAPPER}} .team-style2 .team-content .team-degi' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'person_designation_padding',
			[
				'label'         => __('Person Designation Padding', 'marino'),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => ['px', '%', 'em'],
				'selectors'     => [
					'{{WRAPPER}} .team-style1 .team-content .team-degi,{{wrapper}} .team_style2 .team_degi,{{WRAPPER}} .team-style2 .team-content .team-degi' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		if ($settings['slider_grid'] == '1') {
			$this->add_render_attribute('wrapper', 'class', 'row vs-carousel');
			$this->add_render_attribute('wrapper', 'data-slick-arrows', 'true');
			$this->add_render_attribute('wrapper', 'data-slick-autoplay', 'false');
			$this->add_render_attribute('wrapper', 'data-slide-to-show', $settings['slide_to_show']['size']);
			$this->add_render_attribute('wrapper', 'data-slide-to-show1500', $settings['slide_to_show1500']['size']);
			$this->add_render_attribute('wrapper', 'data-slide-to-show1200', $settings['slide_to_show1200']['size']);
			$this->add_render_attribute('wrapper', 'data-slide-to-show992', $settings['slide_to_show992']['size']);
			$this->add_render_attribute('wrapper', 'data-slide-to-show768', $settings['slide_to_show768']['size']);
		} else {
			$this->add_render_attribute('wrapper', 'class', 'row');
		}

		if ($settings['team_style'] == '1') {
			$this->add_render_attribute('wrapper', 'class', 'slick-arrow2');
		}

		if ($settings['team_style'] == '1' || $settings['team_style'] == '2') {
			echo '<section class="vs-team-wrapper arrow-wrap">';
			echo '<div class="container">';
			echo '<div ' . $this->get_render_attribute_string('wrapper') . '>';
			foreach ($settings['slides'] as $team_member) {
				$target_team 	= $team_member['person_details_url']['is_external'] ? ' target="_blank"' : '';
				$nofollow_team 	= $team_member['person_details_url']['nofollow'] ? ' rel="nofollow"' : '';
				// Icon One
				$target_social_one 		= $team_member['social_icon_one_link']['is_external'] ? ' target="_blank"' : '';
				$nofollow_social_one 	= $team_member['social_icon_one_link']['nofollow'] ? ' rel="nofollow"' : '';
				// Icon Two
				$target_social_two 		= $team_member['social_icon_two_link']['is_external'] ? ' target="_blank"' : '';
				$nofollow_social_two 	= $team_member['social_icon_two_link']['nofollow'] ? ' rel="nofollow"' : '';
				// Icon Three
				$target_social_three 	= $team_member['social_icon_three_link']['is_external'] ? ' target="_blank"' : '';
				$nofollow_social_three 	= $team_member['social_icon_three_link']['nofollow'] ? ' rel="nofollow"' : '';
				// Icon Four
				$target_social_four 	= $team_member['social_icon_four_link']['is_external'] ? ' target="_blank"' : '';
				$nofollow_social_four 	= $team_member['social_icon_four_link']['nofollow'] ? ' rel="nofollow"' : '';
				//Remove ' ' , '-', ' - ' from number
				$email			= $team_member['email'];
				$replace 		= array(' ', '-', ' - ');
				$with 			= array('', '', '');

				$emailurl 	    = str_replace($replace, $with, $email);

				echo '<div class="team-column col-xl-4 col-md-6">';
				if ($settings['team_style'] == '1') {
					echo '<div class="team-style1">';
					echo '<div class="team-img">';
					echo '<a href="' . esc_url($team_member['person_details_url']['url']) . '" ' . wp_kses_post($target_team . $nofollow_team) . '>';
					echo marino_img_tag(array(
						'url'	=> esc_url($team_member['team_member_image']['url']),
					));
					echo '</a>';
					echo '</div>';

					echo '<div class="social-media2">';
					if (!empty($team_member['social_icon_one']['value'])) {
						echo '<a ' . wp_kses_post($target_social_one . $nofollow_social_one) . ' href="' . esc_url($team_member['social_icon_one_link']['url']) . '"><i class="' . esc_attr($team_member['social_icon_one']['value']) . '"></i></a>';
					}
					if (!empty($team_member['social_icon_two']['value'])) {
						echo '<a ' . wp_kses_post($target_social_two . $nofollow_social_two) . ' href="' . esc_url($team_member['social_icon_two_link']['url']) . '"><i class="' . esc_attr($team_member['social_icon_two']['value']) . '"></i></a>';
					}
					if (!empty($team_member['social_icon_three']['value'])) {
						echo '<a ' . wp_kses_post($target_social_three . $nofollow_social_three) . ' href="' . esc_url($team_member['social_icon_three_link']['url']) . '"><i class="' . esc_attr($team_member['social_icon_three']['value']) . '"></i></a>';
					}
					if (!empty($team_member['social_icon_four']['value'])) {
						echo '<a ' . wp_kses_post($target_social_four . $nofollow_social_four) . ' href="' . esc_url($team_member['social_icon_four_link']['url']) . '"><i class="' . esc_attr($team_member['social_icon_four']['value']) . '"></i></a>';
					}
					echo '</div>';
					echo '<div class="team-content">';
					if (!empty($team_member['person_name'])) {
						echo '<h3 class="team-name h4"><a href="' . esc_url($team_member['person_details_url']['url']) . '" ' . wp_kses_post($target_team . $nofollow_team) . '>' . esc_html($team_member['person_name']) . '</a></h3>';
					}
					if (!empty($team_member['person_designation'])) {
						echo '<span class="team-degi">' . esc_html($team_member['person_designation']) . '</span>';
					}
					echo '</div>';
					echo '</div>';
				} else {
					echo '<div class="team_style2">';
					echo '<div class="team_img">';
					echo '<a href="' . esc_url($team_member['person_details_url']['url']) . '" ' . wp_kses_post($target_team . $nofollow_team) . '>';
					echo marino_img_tag(array(
						'url'	=> esc_url($team_member['team_member_image']['url']),
					));
					echo '</a>';
					echo '</div>';
					echo '<div class="team_content">';
					echo '<div class="team_info">';
					if (!empty($team_member['person_name'])) {
						echo '<h3 class="team_name h4"><a href="' . esc_url($team_member['person_details_url']['url']) . '" ' . wp_kses_post($target_team . $nofollow_team) . '>' . esc_html($team_member['person_name']) . '</a></h3>';
					}
					if (!empty($team_member['person_designation'])) {
						echo '<p class="team_degi">' . esc_html($team_member['person_designation']) . '</p>';
					}
					echo '<a href="mailto:' . esc_attr($emailurl) . '" class="team_mail">';
					echo '<i class="fas fa-envelope"></i>';
					echo esc_html($email);
					echo '</a>';
					echo '</div>';
					echo '<div class="team_social">';
					if (!empty($team_member['social_icon_one']['value'])) {
						echo '<a ' . wp_kses_post($target_social_one . $nofollow_social_one) . ' href="' . esc_url($team_member['social_icon_one_link']['url']) . '"><i class="' . esc_attr($team_member['social_icon_one']['value']) . '"></i></a>';
					}
					if (!empty($team_member['social_icon_two']['value'])) {
						echo '<a ' . wp_kses_post($target_social_two . $nofollow_social_two) . ' href="' . esc_url($team_member['social_icon_two_link']['url']) . '"><i class="' . esc_attr($team_member['social_icon_two']['value']) . '"></i></a>';
					}
					if (!empty($team_member['social_icon_three']['value'])) {
						echo '<a ' . wp_kses_post($target_social_three . $nofollow_social_three) . ' href="' . esc_url($team_member['social_icon_three_link']['url']) . '"><i class="' . esc_attr($team_member['social_icon_three']['value']) . '"></i></a>';
					}
					if (!empty($team_member['social_icon_four']['value'])) {
						echo '<a ' . wp_kses_post($target_social_four . $nofollow_social_four) . ' href="' . esc_url($team_member['social_icon_four_link']['url']) . '"><i class="' . esc_attr($team_member['social_icon_four']['value']) . '"></i></a>';
					}
					echo '</div>';
					echo '</div>';
					echo '</div>';
				}
				echo '</div>';
			}
			echo '</div>';
			echo '</div>';
			echo '</section>';
		} elseif ($settings['team_style'] == '3') { ?>
			<section class="team-layout1">
				<div class="container">
					<div <?php echo $this->get_render_attribute_string('wrapper'); ?>>
						<?php foreach ($settings['slides'] as $team_member) :
							$target_team 	= $team_member['person_details_url']['is_external'] ? ' target="_blank"' : '';
							$nofollow_team 	= $team_member['person_details_url']['nofollow'] ? ' rel="nofollow"' : '';
							// Icon One
							$target_social_one 		= $team_member['social_icon_one_link']['is_external'] ? ' target="_blank"' : '';
							$nofollow_social_one 	= $team_member['social_icon_one_link']['nofollow'] ? ' rel="nofollow"' : '';
							// Icon Two
							$target_social_two 		= $team_member['social_icon_two_link']['is_external'] ? ' target="_blank"' : '';
							$nofollow_social_two 	= $team_member['social_icon_two_link']['nofollow'] ? ' rel="nofollow"' : '';
							// Icon Three
							$target_social_three 	= $team_member['social_icon_three_link']['is_external'] ? ' target="_blank"' : '';
							$nofollow_social_three 	= $team_member['social_icon_three_link']['nofollow'] ? ' rel="nofollow"' : '';
							// Icon Four
							$target_social_four 	= $team_member['social_icon_four_link']['is_external'] ? ' target="_blank"' : '';
							$nofollow_social_four 	= $team_member['social_icon_four_link']['nofollow'] ? ' rel="nofollow"' : '';
							//Remove ' ' , '-', ' - ' from number
							$email			= $team_member['email'];
							$replace 		= array(' ', '-', ' - ');
							$with 			= array('', '', '');

							$emailurl 	    = str_replace($replace, $with, $email); ?>
							<div class="col-lg-4">
								<div class="team-style2">
									<div class="team-img">
										<?php echo '<a href="' . esc_url($team_member['person_details_url']['url']) . '" ' . wp_kses_post($target_team . $nofollow_team) . '>';
										echo marino_img_tag(array(
											'url'	=> esc_url($team_member['team_member_image']['url']),
										));
										echo '</a>'; ?>
									</div>
									<div class="team-content">
										<?php if (!empty($team_member['person_name'])) {
											echo '<h3 class="team-name h4"><a href="' . esc_url($team_member['person_details_url']['url']) . '" ' . wp_kses_post($target_team . $nofollow_team) . '>' . esc_html($team_member['person_name']) . '</a></h3>';
										}; ?>
										<?php if (!empty($team_member['person_designation'])) {
											echo '<p class="team-degi">' . esc_html($team_member['person_designation']) . '</p>';
										}; ?>
										<div class="social-media4">
											<a href="#"><i class="fas fa-share-alt"></i></a>
											<?php if (!empty($team_member['social_icon_one']['value'])) {
												echo '<a ' . wp_kses_post($target_social_one . $nofollow_social_one) . ' href="' . esc_url($team_member['social_icon_one_link']['url']) . '"><i class="' . esc_attr($team_member['social_icon_one']['value']) . '"></i></a>';
											}
											if (!empty($team_member['social_icon_two']['value'])) {
												echo '<a ' . wp_kses_post($target_social_two . $nofollow_social_two) . ' href="' . esc_url($team_member['social_icon_two_link']['url']) . '"><i class="' . esc_attr($team_member['social_icon_two']['value']) . '"></i></a>';
											}
											if (!empty($team_member['social_icon_three']['value'])) {
												echo '<a ' . wp_kses_post($target_social_three . $nofollow_social_three) . ' href="' . esc_url($team_member['social_icon_three_link']['url']) . '"><i class="' . esc_attr($team_member['social_icon_three']['value']) . '"></i></a>';
											}
											if (!empty($team_member['social_icon_four']['value'])) {
												echo '<a ' . wp_kses_post($target_social_four . $nofollow_social_four) . ' href="' . esc_url($team_member['social_icon_four_link']['url']) . '"><i class="' . esc_attr($team_member['social_icon_four']['value']) . '"></i></a>';
											}; ?>
										</div>
									</div>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
			</section>
<?php }
	}
}
