<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;

/**
 *
 * Service Slider Widget .
 *
 */
class Marino_Service_Slider extends Widget_Base {

	public function get_name() {
		return 'marinoservice';
	}

	public function get_title() {
		return __('Service', 'marino');
	}

	public function get_icon() {
		return 'eicon-code';
	}

	public function get_categories() {
		return ['marino'];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'counter_section',
			[
				'label' 	=> __('Service', 'marino'),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'service_style',
			[
				'label' 		=> __('Service Style', 'marino'),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  			=> __('Style One', 'marino'),
					'2' 			=> __('Style Two', 'marino'),
					'3' 			=> __('Style Three', 'marino'),
					'4' 			=> __('Style Four', 'marino'),
					'5' 			=> __('Style Five', 'marino'),
				],
			]
		);
		$this->add_control(
			'active_slider',
			[
				'label'     => esc_html__('Slider?', 'marino'),
				'type'      => Controls_Manager::SWITCHER,
				'label_on'  => esc_html__('Show', 'marino'),
				'label_off' => esc_html__('Hide', 'marino'),
				'return_value' => 'yes',
				'default'   => 'yes',
			]
		);

		$this->add_control(
			'service_column',
			[
				'label' 		=> __('Service Column', 'mixlax'),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '3',
				'options'		=> [
					'12'  			=> __('Full Width', 'mixlax'),
					'6' 			=> __('2 Column', 'mixlax'),
					'4' 			=> __('3 Column', 'mixlax'),
					'3' 			=> __('4 Column', 'mixlax'),
					'2' 			=> __('6 Column', 'mixlax'),
				],
				'condition'		=> ['active_slider' => '']
			]
		);
		$this->add_control(
			'post_from',
			[
				'label' 		=> __('Post From', 'marino'),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'all',
				'options' 		=> [
					'all'  			=> __('All', 'marino'),
					'categories' 	=> __('Categories', 'marino'),
				],
			]
		);
		$this->add_control(
			'categories',
			[
				'label' 		=> __('Post From', 'marino'),
				'type' 			=> Controls_Manager::SELECT,
				'options' 		=> marino_services_category(),
				'condition' 	=> ['post_from' => 'categories'],
			]
		);
		$this->add_control(
			'post_limit',
			[
				'label' 		=> __('Post Limit', 'marino'),
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> __('Only Number Work. Like 4 or 6', 'marino'),
			]
		);
		$this->add_control(
			'order',
			[
				'label' 		=> __('Order', 'marino'),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'ASC',
				'options' 		=> [
					'ASC'  			=> __('Ascending', 'marino'),
					'DESC' 			=> __('Descending', 'marino'),
				],
			]
		);
		$this->add_control(
			'order_by',
			[
				'label' 		=> __('Order By', 'marino'),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'name',
				'options' 		=> [
					'none'  		=> __('None', 'marino'),
					'type' 			=> __('Type', 'marino'),
					'title' 		=> __('Title', 'marino'),
					'name' 			=> __('Name', 'marino'),
					'name' 			=> __('Name', 'marino'),
				],
			]
		);
		$this->add_control(
			'read_more',
			[
				'label' 		=> __('Read More test', 'marino'),
				'type' 			=> Controls_Manager::TEXT,
				'placeholder'	=> __('Read More', 'marino'),
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'slider_control_section',
			[
				'label' 		=> __('Slider Control', 'marino'),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
				'condition'		=> ['active_slider' => 'yes']
			]
		);

		$this->add_control(
			'desktop_items',
			[
				'label' 		=> __('Desktop Items', 'marino'),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> ['%'],
				'range' 		=> [
					'%' 	=> [
						'min' 	=> 0,
						'step' 	=> 1,
						'max' 	=> 10,
					],
				],
				'default' 	=> [
					'unit' 		=> '%',
					'size' 		=> 2,
				],
			]
		);

		$this->add_control(
			'slider_autoplay',
			[
				'label' 		=> __('Autoplay', 'marino'),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __('Yes', 'marino'),
				'label_off' 	=> __('No', 'marino'),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

		$this->add_control(
			'slider_arrows',
			[
				'label' 		=> __('Arrows', 'marino'),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __('Yes', 'marino'),
				'label_off' 	=> __('No', 'marino'),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'service_style_section',
			[
				'label' => __('Service Slider Style', 'marino'),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'service_title_color',
			[
				'label' 	=> __('Service Title Color', 'marino'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .service-wrapper .service-title,.service-wrapper .feature-title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'service_title_hover_color',
			[
				'label' 	=> __('Service Title Hover Color', 'marino'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .service-wrapper .service-title a:hover,.service-wrapper .feature-title a:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'service_title_typography',
				'label' 	=> __('Service Title Typography', 'marino'),
				'selector' 	=> '{{WRAPPER}} .service-wrapper .service-title,.service-wrapper .feature-title',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'service_style_dis',
			[
				'label' => __('Description', 'marino'),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'service_desc_color',
			[
				'label' 	=> __('Color', 'marino'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .service-wrapper .service-text,.service-wrapper .feature-text' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'service_desc_typography',
				'label' 	=> __('Service Desc Typography', 'marino'),
				'selector' 	=> '{{WRAPPER}} .service-wrapper .service-text,.service-wrapper .feature-text',
			]
		);
		$this->end_controls_section();


		$this->start_controls_section(
			'service_style_box',
			[
				'label' => __('Box', 'marino'),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' 		=> 'background',
				'label' 	=> __('Background', 'marino'),
				'types' 	=> ['classic', 'gradient', 'video'],
				'selector' 	=> '{{WRAPPER}} .service-style1, {{WRAPPER}} .service-style2,{{WRAPPER}} .feature-content',
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' 		=> 'background_hover',
				'label' 	=> __('Hover Background', 'marino'),
				'types' 	=> ['classic', 'gradient', 'video'],
				'selector' 	=> '{{WRAPPER}} .service-style1:hover, {{WRAPPER}} .service-style2:hover,{{WRAPPER}} .feature-style1 .feature-body:hover',

			]
		);


		$this->add_control(
			'service_title_color_hover',
			[
				'label' 	=> __('Hover Title Color', 'marino'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [

					'{{WRAPPER}} .service-style5:hover .service-text,  {{WRAPPER}}, .service-style5:hover .service-title a' => 'color: {{VALUE}}!important',
				],

			]
		);
		$this->end_controls_section();
	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

		if ($settings['post_from'] == "categories") {
			$service = array(
				'post_type'         => 'marino_service',
				'posts_per_page'    => esc_attr($settings['post_limit']),
				'order'             => esc_attr($settings['order']),
				'orderby'           => esc_attr($settings['order_by']),
				'tax_query'         => array(
					array(
						'taxonomy'  => 'service_category',
						'field'     => 'slug',
						'terms'     => esc_attr($settings['categories']),
					)
				),
				'paged'             => $paged,
			);
		} else {
			$service = array(
				'post_type'         => 'marino_service',
				'posts_per_page'    => esc_attr($settings['post_limit']),
				'order'             => esc_attr($settings['order']),
				'orderby'           => esc_attr($settings['order_by']),
				'paged'             => $paged,
			);
		}

		$marino_service = new WP_Query($service);

		if ('yes'  == $settings['active_slider']) {
			$this->add_render_attribute('wrapper', 'class', 'row service-carousel');
			$this->add_render_attribute('wrapper', 'data-slide-to-show', $settings['desktop_items']['size']);
			$this->add_render_attribute('wrapper', 'data-slick-dots', 'false');
			// arrows
			if ($settings['slider_arrows'] == 'yes') {
				$this->add_render_attribute('wrapper', 'data-slick-arrows', 'true');
			} else {
				$this->add_render_attribute('wrapper', 'data-slick-arrows', 'false');
			}
			// autoplay
			if ($settings['slider_autoplay'] == 'yes') {
				$this->add_render_attribute('wrapper', 'data-slick-autoplay', 'true');
			} else {
				$this->add_render_attribute('wrapper', 'data-slick-autoplay', 'false');
			}
			$column_class = '4';
		} else {
			$this->add_render_attribute('wrapper', 'class', 'row');
			$column_class = $settings['service_column'];
		}


		if ('1' ==  $settings['service_style']) {
			echo '<div class="service-wrapper service-wrap1 arrow-wrap">';
			echo '<div class="container">';
			echo '<div ' . $this->get_render_attribute_string('wrapper') . '>';
			while ($marino_service->have_posts()) :
				$marino_service->the_post();

				$marino_icon = marino_meta('service_icon', 'url');
				echo '<div class="col-md-6 col-lg-4 col-xl-' . esc_attr($column_class) . '">';
				echo '<div class="service-style1">';
				if (has_post_thumbnail()) {
					echo '<div class="service-img">';
					the_post_thumbnail();
					echo '</div>';
				}
				if (!empty($marino_icon)) {
					echo '<div class="service-icon">';
					echo marino_img_tag(array(
						'url' => esc_url($marino_icon)
					));
					echo '</div>';
				}
				echo '<h3 class="service-title h6">';
				echo '<a class="text-inherit" href="' . esc_url(get_permalink()) . '">' . get_the_title() . '</a>';
				echo '</h3>';
				echo '<p class="service-text">' . get_the_excerpt() . '</p>';
				echo '<div class="link-btn">';
				echo '<a href="' . esc_url(get_permalink()) . '" tabindex="-1">' . esc_html($settings['read_more']) . ' <i class="far fa-arrow-right"></i></a>';
				echo '</div>';
				echo '</div>';
				echo '</div>';
			endwhile;
			wp_reset_postdata();
			echo '</div>';
			echo '</div>';
			echo '</div>';
		} elseif ('2' ==  $settings['service_style']) {
			echo '<div class="service-wrapper arrow-wrap">';
			echo '<div class="container">';
			echo '<div ' . $this->get_render_attribute_string('wrapper') . '>';
			while ($marino_service->have_posts()) :
				$marino_service->the_post();

				$marino_icon = marino_meta('service_icon', 'url');
				echo '<div class="col-md-6 col-lg-4 col-xl-' . esc_attr($column_class) . '">';
				echo '<div class="service-style2">';
				if (has_post_thumbnail()) {
					echo '<div class="service-img">';
					the_post_thumbnail();
					echo '</div>';
				}
				echo '<div class="service-inner">';
				if (!empty($marino_icon)) {
					echo '<div class="service-icon">';
					echo marino_img_tag(array(
						'url' => esc_url($marino_icon)
					));
					echo '</div>';
				}
				echo '<h3 class="service-title h6">';
				echo '<a class="text-inherit" href="' . esc_url(get_permalink()) . '">' . get_the_title() . '</a>';
				echo '</h3>';
				echo '<p class="service-text">' . get_the_excerpt() . '</p>';
				echo '<div class="link-btn">';
				echo '<a href="' . esc_url(get_permalink()) . '">' . esc_html($settings['read_more']) . ' <i class="far fa-arrow-right"></i></a>';
				echo '</div>';
				echo '</div>';
				echo '</div>';
				echo '</div>';
			endwhile;
			wp_reset_postdata();
			echo '</div>';
			echo '</div>';
			echo '</div>';
		} elseif ('3' ==  $settings['service_style']) {
			echo '<div class="service-wrapper arrow-wrap">';
			echo '<div class="container">';
			echo '<div ' . $this->get_render_attribute_string('wrapper') . '>';
			while ($marino_service->have_posts()) :
				$marino_service->the_post();

				$marino_icon = marino_meta('service_icon', 'url');
				echo '<div class="col-lg-12 col-xl-' . esc_attr($column_class) . '">';
				echo '<div class="feature-style1">';
				echo '<div class="feature-body">';
				echo '<div class="row align-items-center">';
				echo '<div class="col-md-auto col-12 position-relative">';
				if (has_post_thumbnail()) {
					echo '<div class="feature-img">';
					the_post_thumbnail('marino_202x202');
					echo '</div>';
				}
				echo '<div class="icon-box1">';
				if (!empty($marino_icon)) {
					echo '<div class="feature-icon">';
					echo marino_img_tag(array(
						'url' => esc_url($marino_icon)
					));
					echo '</div>';
				}
				echo '</div>';
				echo '</div>';
				echo '<div class="col">';
				echo '<div class="feature-content">';
				echo '<h3 class="feature-title">';
				echo '<a class="text-inherit" href="' . esc_url(get_permalink()) . '">' . get_the_title() . '</a>';
				echo '</h3>';
				echo '<p class="feature-text">' . get_the_excerpt() . '</p>';
				echo '<a href="' . esc_url(get_permalink()) . '" class="vs-btn style3">' . esc_html($settings['read_more']) . ' <i class="far fa-arrow-right"></i>';
				echo '</a>';
				echo '</div>';
				echo '</div>';
				echo '</div>';
				echo '</div>';
				echo '</div>';
				echo '</div>';
			endwhile;
			wp_reset_postdata();
			echo '</div>';
			echo '</div>';
			echo '</div>';
		} elseif ('4' ==  $settings['service_style']) { ?>
			<section class="service-layout3 overflow-hidden position-relative">
				<div class="container">
					<div <?php echo $this->get_render_attribute_string('wrapper'); ?>>
						<?php while ($marino_service->have_posts()) :
							$marino_service->the_post();
							$marino_icon = marino_meta('service_icon', 'url');
						?>
							<div class="col-4">
								<div class="service-style3" data-bg-src="<?php the_post_thumbnail_url(); ?>">
									<div class="service-content">
										<?php if (!empty($marino_icon)) {
											echo '<div class="service-icon">';
											echo marino_img_tag(array(
												'url' => esc_url($marino_icon)
											));
											echo '</div>';
										} ?>
										<?php echo '<h3 class="service-title h6">';
										echo '<a class="text-inherit" href="' . esc_url(get_permalink()) . '">' . get_the_title() . '</a>';
										echo '</h3>'; ?>
										<?php echo '<p class="service-text">' . get_the_excerpt() . '</p>'; ?>
									</div>
									<div class="vs-btn">
										<a href="<?php echo esc_url(get_permalink()) ?>"><?php echo esc_html($settings['read_more']); ?></a>
									</div>
								</div>
							</div>
						<?php endwhile;
						wp_reset_postdata(); ?>
					</div>
				</div>
			</section>
		<?php } elseif ('5' ==  $settings['service_style']) { ?>
			<section class="service-layout4 position-relative background-image">
				<div class="container">
					<div class="row vs-carousel-service" data-slide-show="3" data-lg-slide-show="2" data-md-slide-show="2" data-center-mode="true" data-xl-center-mode="true" data-ml-center-mode="true" data-lg-center-mode="true" data-md-center-mode="true" data-sm-center-mode="true" data-xs-center-mode="true" data-arrows="false" data-dots="true">
						<?php while ($marino_service->have_posts()) :
							$marino_service->the_post();
							$marino_icon = marino_meta('service_icon', 'url');
						?>
							<div class="col-auto">
								<div class="service-style4" data-bg-src="<?php the_post_thumbnail_url(); ?>">
									<div class="service-content">
										<?php if (!empty($marino_icon)) {
											echo '<div class="service-icon">';
											echo marino_img_tag(array(
												'url' => esc_url($marino_icon)
											));
											echo '</div>';
										} ?>
										<?php echo '<h3 class="service-title h6">';
										echo '<a class="text-inherit" href="' . esc_url(get_permalink()) . '">' . get_the_title() . '</a>';
										echo '</h3>'; ?>
										<?php echo '<p class="service-text">' . get_the_excerpt() . '</p>'; ?>
										<div class="vs-btn">
											<a href="<?php echo esc_url(get_permalink()) ?>"><?php echo esc_html($settings['read_more']); ?></a>
										</div>
									</div>
								</div>
							</div>
						<?php endwhile; ?>
					</div>
				</div>
			</section>
<?php }
	}
}
