<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
/**
 *
 * Product Widget .
 *
 */
class Marino_Product_Slider extends Widget_Base {

	public function get_name() {
		return 'marinoproductslider';
	}

	public function get_title() {
		return __( 'Product Slider', 'marino' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'marino' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'product_slider_section',
			[
				'label' 	=> __( 'Product Slider', 'marino' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'product_style',
			[
				'label' 	=> __( 'Product Style', 'marino' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options'   => [
					'1'  		=> __( 'Style One', 'marino' ),
					'2' 		=> __( 'Style Two', 'marino' ),
					'3' 		=> __( 'Style Three', 'marino' ),
				],
			]
		);

        $this->add_control(
			'product_count',
			[
				'label' 		=> __( 'Product Count', 'marino' ),
				'type' 			=> Controls_Manager::NUMBER,
				'min' 			=> 1,
				'max' 			=> 50,
				'step' 			=> 1,
				'default' 		=> 6,
			]
		);

        $this->add_control(
			'product_cats',
			[
				'label' 		=> __( 'Product Categories', 'marino' ),
                'type' 			=> Controls_Manager::SELECT2,
                'multiple' 		=> true,
                'label_block'   => true,
                'options' 		=> $this->product_cats_get(),
			]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'slider_control_section',
			[
				'label' 		=> __( 'Slider Control', 'marino' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'desktop_items',
			[
				'label' 		=> __( 'Desktop Items', 'marino' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ '%' ],
				'range' 		=> [
					'%' 	=> [
						'min' 	=> 0,
						'step' 	=> 1,
						'max' 	=> 10,
					],
				],
				'default' 	=> [
					'unit' 		=> '%',
					'size' 		=> 3,
				],
			]
		);

		$this->add_control(
			'slider_autoplay',
			[
				'label' 		=> __( 'Autoplay', 'marino' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'marino' ),
				'label_off' 	=> __( 'No', 'marino' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

		$this->add_control(
			'slider_arrows',
			[
				'label' 		=> __( 'Arrows', 'marino' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'marino' ),
				'label_off' 	=> __( 'No', 'marino' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'general',
			[
				'label' 	=> __( 'General', 'marino' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

		$this->add_control(
			'star_color',
			[
				'label' 	=> __( 'Star Color', 'marino' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .star-rating:before,{{WRAPPER}} .star-rating span:before' => 'color: {{VALUE}}',
                ],
			]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'product_title_style_section',
			[
				'label' 	=> __( 'Product Title Style', 'marino' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'product_title_color',
			[
				'label' 	=> __( 'Product Title Color', 'marino' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .vs-product .product-content .product-title a' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'product_title_hover_color',
			[
				'label' 	=> __( 'Product Title Hover Color', 'marino' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .vs-product .product-content .product-title a:hover' => 'color: {{VALUE}}',
                ],
			]
        );


        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'product_title_typography',
				'label' 	=> __( 'Product Title Typography', 'marino' ),
                'selector' 	=> '{{WRAPPER}} .vs-product .product-content .product-title',
			]
        );

        $this->add_responsive_control(
			'product_title_margin',
			[
				'label' 		=> __( 'Product Title Margin', 'marino' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-product .product-content .product-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'product_title_padding',
			[
				'label' 		=> __( 'Product Title Padding', 'marino' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-product .product-content .product-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'product_price_style_section',
			[
				'label' 	=> __( 'Product Price Style', 'marino' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

		$this->add_control(
			'product_price_color',
			[
				'label' 		=> __( 'Product Price Color', 'marino' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .vs-product .product-content span.price,{{WRAPPER}} .vs-product-box1 .product-content span.price' => 'color: {{VALUE}}',
                ]
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'product_price_typography',
				'label' 	=> __( 'Product Price Typography', 'marino' ),
                'selector' 	=> '{{WRAPPER}} .vs-product .product-content span.price,{{WRAPPER}} .vs-product-box1 .product-content span.price',
			]
        );

        $this->add_responsive_control(
			'product_price_margin',
			[
				'label' 		=> __( 'Product Price Margin', 'marino' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-product .product-content span.price,{{WRAPPER}} .vs-product-box1 .product-content span.price' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'product_price_padding',
			[
				'label' 		=> __( 'Product Price Padding', 'marino' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .vs-product .product-content span.price,{{WRAPPER}} .vs-product-box1 .product-content span.price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

		$this->end_controls_section();

    }

    protected function product_cats_get() {
        $terms = get_terms( array( 'taxonomy' => 'product_cat' ) );
        $term_array = array();
        if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
            foreach ( $terms as $term ) {
                $term_array[$term->slug] = $term->name;
            }
        }

        return $term_array;
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

		$this->add_render_attribute( 'wrapper', 'class', 'row vs-carousel');

		$this->add_render_attribute( 'wrapper', 'data-slide-to-show', $settings['desktop_items']['size']);

		if( $settings['slider_arrows'] == 'yes' ) {
			$this->add_render_attribute( 'wrapper','data-slick-arrows','true' );
		} else {
			$this->add_render_attribute( 'wrapper','data-slick-arrows','false' );
		}

		if( $settings['slider_autoplay'] == 'yes' ) {
			$this->add_render_attribute( 'wrapper', 'data-slick-autoplay', 'true' );
		} else {
			$this->add_render_attribute( 'wrapper', 'data-slick-autoplay', 'false' );
		}

        $args = array(
            "post_type" 		=> "product",
            "posts_per_page"    => esc_attr( $settings['product_count'] )
		);

		$args['order'] 		= 'ASC';
		$args['orderby'] 	= 'title';

        if( ! empty( $settings['product_cats'] ) ) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'product_cat',
                    'field'    => 'slug',
                    'terms'    => $settings['product_cats'],
                ),
            );
        }

        $prods = new WP_Query( $args );

		echo '<section class="product-wrapper">';
			echo '<div class="container">';
		        echo '<div '.$this->get_render_attribute_string( 'wrapper' ).'>';
		            while( $prods->have_posts() ) {
		                $prods->the_post();
						echo '<div class="col-xl-2 col-sm-6">';
							if( $settings['product_style'] == '1' ){
								wc_get_template( 'content-product.php' );
							}elseif( $settings['product_style'] == '2' ){
			                	wc_get_template( 'content-horizontal-product.php' );
                            }elseif( $settings['product_style'] == '3' ){
			                	wc_get_template( 'content-product-two.php' );
                            }
						echo '</div>';
		            }
		            wp_reset_postdata();
		        echo '</div>';
	        echo '</div>';
	    echo '</section>';
	}
}