<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;

/**
 *
 * Image Widget .
 *
 */
class Marino_Image extends Widget_Base {

	public function get_name() {
		return 'marinoimage';
	}

	public function get_title() {
		return __('Image', 'marino');
	}


	public function get_icon() {
		return 'eicon-code';
	}


	public function get_categories() {
		return ['marino'];
	}


	protected function _register_controls() {

		$this->start_controls_section(
			'image_section',
			[
				'label' 	=> __('Image', 'marino'),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'image_style',
			[
				'label' 		=> __('Image Style', 'marino'),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options'		=> [
					'1'  			=> __('Style One', 'marino'),
					'2' 			=> __('Style Two', 'marino'),
					'3' 			=> __('Style Three', 'marino'),
				],
			]
		);

		$this->add_control(
			'image',
			[
				'label' 		=> __('Choose Image', 'marino'),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'title',
			[
				'label'         => __('Title', 'marino'),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __('Awesome Title', 'marino'),
				'label_block'   => true,
				'condition'     => ['image_style' => ['2','3']]
			]
		);

		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
				'name' 			=> 'image', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `image_size` and `image_custom_dimension`.
				'default' 		=> 'large',
				'separator' 	=> 'none',
			]
		);

		$this->add_responsive_control(
			'image_align',
			[
				'label' 		=> __('Alignment', 'marino'),
				'type' 			=> Controls_Manager::CHOOSE,
				'options' 		=> [
					'left' 	=> [
						'title' 		=> __('Left', 'marino'),
						'icon' 			=> 'fa fa-align-left',
					],
					'center' 	=> [
						'title' 		=> __('Center', 'marino'),
						'icon' 			=> 'fa fa-align-center',
					],
					'right' 	=> [
						'title' 		=> __('Right', 'marino'),
						'icon' 			=> 'fa fa-align-right',
					],
				],
				'default' 	=> 'left',
				'toggle' 	=> true,
				'selectors' => [
					'{{WRAPPER}} .marino-img' => 'text-align: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'link',
			[
				'label' 		=> __('Link', 'marino'),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __('https://your-link.com', 'marino'),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);
		$this->add_control(
			'video_btn',
			[
				'label' 		=> __('Video Button', 'marino'),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __('Yes', 'marino'),
				'label_off' 	=> __('No', 'marino'),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);
		$this->add_control(
			'video_icon',
			[
				'label' 		=> __('Choose Icon', 'marino'),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
				'condition'	=> ['video_btn' => 'yes']
			]
		);
		$this->add_control(
			'video_link',
			[
				'label' 		=> __('Video Link', 'marino'),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __('https://your-link.com', 'marino'),
				'default' 		=> [
					'url' => '#',
				],
				'condition'	=> ['video_btn' => 'yes']
			]
		);
		$this->add_control(
			'image_wrapper_class',
			[
				'label'     => __('Image Wrapper Class', 'marino'),
				'type'      => Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'image_class',
			[
				'label'     => __('Image Class', 'marino'),
				'type'      => Controls_Manager::TEXT,
			]
		);
		$this->end_controls_section();


		$this->start_controls_section(
			'image_style_section',
			[
				'label' 	=> __('Image Style', 'marino'),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'width',
			[
				'label' 	=> __('Width', 'marino'),
				'type' 		=> Controls_Manager::SLIDER,
				'default' 	=> [
					'unit' 		=> '%',
				],
				'tablet_default' => [
					'unit' => '%',
				],
				'mobile_default' => [
					'unit' => '%',
				],
				'size_units' => ['%', 'px', 'vw'],
				'range' => [
					'%' => [
						'min' => 1,
						'max' => 100,
					],
					'px' => [
						'min' => 1,
						'max' => 1000,
					],
					'vw' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .marino-img img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'space',
			[
				'label' 	=> __('Max Width', 'marino') . ' (%)',
				'type' 		=> Controls_Manager::SLIDER,
				'default' 	=> [
					'unit' 		=> '%',
				],
				'tablet_default' => [
					'unit' => '%',
				],
				'mobile_default' => [
					'unit' => '%',
				],
				'size_units' => ['%'],
				'range' => [
					'%' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .marino-img img' => 'max-width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'separator_panel_style',
			[
				'type' 	=> Controls_Manager::DIVIDER,
				'style' => 'thick',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'image_border',
				'selector' 	=> '{{WRAPPER}} .marino-img img',
			]
		);

		$this->add_responsive_control(
			'image_border_radius',
			[
				'label' 		=> __('Border Radius', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%'],
				'selectors' 	=> [
					'{{WRAPPER}} .marino-img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' 		=> 'image_box_shadow',
				'exclude' 	=> [
					'box_shadow_position',
				],
				'selector' => '{{WRAPPER}} .marino-img img',
			]
		);

		$this->end_controls_section();
	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		$this->add_render_attribute('wrapper', 'class', 'marino-img');

		$this->add_render_attribute('wrapper', 'class', esc_attr($settings['image_wrapper_class']));

		if (!empty($settings['link']['url'])) {
			$this->add_render_attribute('link', 'href', esc_url($settings['link']['url']));
		}

		if (!empty($settings['link']['nofollow'])) {
			$this->add_render_attribute('link', 'rel', 'nofollow');
		}

		if (!empty($settings['link']['is_external'])) {
			$this->add_render_attribute('link', 'target', '_blank');
		}

		if ($settings['image_style'] == '1') {
			echo '<div ' . $this->get_render_attribute_string('wrapper') . '>';
			if (!empty($settings['link']['url'])) {
				echo '<a ' . $this->get_render_attribute_string('link') . '>';
			}

			echo '<img class="' . esc_attr($settings['image_class']) . '" src="' . esc_url(Group_Control_Image_Size::get_attachment_image_src($settings['image']['id'], 'image', $settings)) . '" alt="' . esc_attr(marino_image_alt(Group_Control_Image_Size::get_attachment_image_src($settings['image']['id'], 'image', $settings))) . '" >';

			if (!empty($settings['link']['url'])) {
				echo '</a>';
			}
			if ($settings['video_btn'] == 'yes' && !empty($settings['video_link']['url'])) {
				echo '<div class="video-box">';
				echo '<a href="' . esc_url($settings['video_link']['url']) . '" class="play-btn2 popup-video"><i class="fas fa-play"></i></a>';
				echo '</div>';
			}
			echo '</div>';
		} elseif ($settings['image_style'] == '2') { ?>
			<div class="video-layout1">
				<div class="container">
					<div class="video-body space" data-bg-src="<?php echo esc_url($settings['image']['url']); ?>">
						<div class="row">
							<div class="col-lg-6">
								<?php if ($settings['video_btn'] == 'yes' && !empty($settings['video_link']['url'])) : ?>
									<a href="<?php echo esc_url($settings['video_link']['url']); ?>" class="play-btn2 style2 popup-video">
										<?php echo marino_img_tag(array(
											'url'	=> esc_url($settings['video_icon']['url']),
										));
										?>
									</a>
								<?php endif; ?>
								<h2 class="video-title"><?php echo esc_html($settings['title']) ?></h2>
							</div>
						</div>
					</div>
				</div>
			</div>
		<?php } elseif ($settings['image_style'] == '3') { ?>
			<div class="video-layout2">
				<div class="container">
					<div class="video-bg" data-bg-src="<?php echo esc_url($settings['image']['url']); ?>"></div>
					<div class="video-body space">
						<div class="container">
							<div class="row justify-content-lg-end justify-content-center">
								<div class="col-lg-6">
									<div class="text-lg-end text-center">
										<a href="<?php echo esc_url($settings['video_link']['url']); ?>" class="play-btn2 style2 popup-video">
											<?php echo marino_img_tag(array(
												'url'	=> esc_url($settings['video_icon']['url']),
											));
											?>
										</a>
										<h2 class="video-title"><?php echo esc_html($settings['title']) ?></h2>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
<?php }
	}
}
