<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;

/**
 *
 * Image Widget .
 *
 */
class Marino_Image_Box extends Widget_Base {

	public function get_name() {
		return 'marinoimagebox';
	}

	public function get_title() {
		return __('Image Box', 'marino');
	}

	public function get_icon() {
		return 'eicon-code';
	}

	public function get_categories() {
		return ['marino'];
	}


	protected function _register_controls() {

		$this->start_controls_section(
			'image_box_section',
			[
				'label' 	=> __('Image Box', 'marino'),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'imagebox_style',
			[
				'label'     => __('Style', 'marino'),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => '1',
				'options'   => [
					'1'         => __('Style One', 'marino'),
					'2'         => __('Style Two', 'marino'),
				],
			]
		);

		$this->add_control(
			'image_one',
			[
				'label' 		=> __('Choose Image', 'marino'),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'image_two',
			[
				'label' 		=> __('Choose Image', 'marino'),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'box_one_title',
			[
				'label' 		=> esc_html__('Box One Title', 'marino'),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> esc_html__('15+ Great', 'marino'),
				'label_block' 	=> true,
			]
		);
		$this->add_control(
			'box_one_subtitle',
			[
				'label' 		=> esc_html__('Box One SubTitle', 'marino'),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> esc_html__('Hunting Shot', 'marino'),
				'label_block' 	=> true,
			]
		);
		$this->add_control(
			'box_two_title',
			[
				'label' 		=> esc_html__('Box Two Title', 'marino'),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> esc_html__('25+ Great', 'marino'),
				'label_block' 	=> true,
				'condition'     => [
					'imagebox_style' => ['1']
				]
			]
		);
		$this->add_control(
			'box_two_subtitle',
			[
				'label' 		=> esc_html__('Box Two SubTitle', 'marino'),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> esc_html__('Of Experience', 'marino'),
				'label_block' 	=> true,
				'condition'     => [
					'imagebox_style' => ['1']
				]
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'box_style_section',
			[
				'label' => __('Box Style', 'marino'),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);


		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' 		=> 'background',
				'label' 	=> __('Background', 'marino'),
				'types' 	=> ['classic'],
				'selector' 	=> '{{WRAPPER}} .img_box1 .exp_box1',
			]
		);

		$this->add_control(
			'box_title_color',
			[
				'label' 	=> __('Title Color', 'marino'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .img_box1 .exp_box_title' => 'color: {{VALUE}}!important',
				],
			]
		);

		$this->add_control(
			'box_title_sub_color',
			[
				'label' 	=> __('Sub Title Color', 'marino'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .img_box1 .exp_box_text' => 'color: {{VALUE}}!important',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'box_title_typography',
				'label' 	=> __('Title Typography', 'marino'),
				'selector' 	=> '{{WRAPPER}} .img_box1 .exp_box_title',
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'box_sub_title_typography',
				'label' 	=> __('Title Typography', 'marino'),
				'selector' 	=> '{{WRAPPER}} .img_box1 .exp_box_text',
			]
		);
		$this->end_controls_section();
	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		if ($settings['imagebox_style'] == '1') {
			echo '<div class="img_box1">';
			if (!empty($settings['image_one']['url'])) {
				echo '<div class="img_1 mega-hover">';
				echo marino_img_tag(array(
					'url'   => $settings['image_one']['url'],
				));
				echo '</div>';
			}
			if (!empty($settings['image_two']['url'])) {
				echo '<div class="img_2 mega-hover">';
				echo marino_img_tag(array(
					'url'   => $settings['image_two']['url'],
				));
				echo '</div>';
			}
			echo '<div class="exp_box1">';
			if (!empty($settings['box_one_title'])) {
				echo '<h3 class="exp_box_title">' . esc_html($settings['box_one_title']) . '</h3>';
			}
			if (!empty($settings['box_one_subtitle'])) {
				echo '<p class="exp_box_text">' . esc_html($settings['box_one_subtitle']) . '</p>';
			}
			echo '</div>';
			echo '<div class="exp_box1">';
			if (!empty($settings['box_two_title'])) {
				echo '<h3 class="exp_box_title">' . esc_html($settings['box_two_title']) . '</h3>';
			}
			if (!empty($settings['box_two_subtitle'])) {
				echo '<p class="exp_box_text">' . esc_html($settings['box_two_subtitle']) . '</p>';
			}
			echo '</div>';
			echo '</div>';
		} elseif ($settings['imagebox_style'] == '2') { ?>
			<div class="picture-box1">
				<?php if (!empty($settings['image_one']['url'])) : ?>
					<div class="img-1">
						<?php echo marino_img_tag(array(
							'url'   => $settings['image_one']['url'],
						)); ?>
					</div>
				<?php endif; ?>
				<div class="img-2">
					<div class="position-relative">
						<?php if (!empty($settings['image_two']['url'])) : ?>
							<?php echo marino_img_tag(array(
								'url'   => $settings['image_two']['url'],
							)); ?>
						<?php endif; ?>
						<?php if (!empty($settings['box_one_title']) || $settings['box_one_subtitle']) : ?>
							<div class="about-content">
								<?php if (!empty($settings['box_one_title'])) {
									echo '<h2 class="shep-title">' . esc_html($settings['box_one_title']) . '</h2>';
								} ?>
								<?php if (!empty($settings['box_one_subtitle'])) {
									echo '<p class="shep-text">' . esc_html($settings['box_one_subtitle']) . '</p>';
								} ?>
							</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
<?php }
	}
}
