<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Image_Size;

/**
 *
 * Hunter Spot Widget .
 *
 */
class Marino_Huntar_Spot_Widget extends Widget_Base {

	public function get_name() {
		return 'marinohuntarspot';
	}

	public function get_title() {
		return __('Hunter Spot', 'marino');
	}

	public function get_icon() {
		return 'eicon-code';
	}

	public function get_categories() {
		return ['marino'];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'chose_us_content',
			[
				'label'		=> __('Hunter Spot', 'marino'),
				'tab'		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'hunter_style',
			[
				'label' 		=> __('Hunter Style', 'marino'),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options'		=> [
					'1'  			=> __('Style One', 'marino'),
					'2' 			=> __('Style Two', 'marino'),
				],
			]
		);
		/*-----------------------------------------style one ------------------------------------*/
		$repeater = new Repeater();

		$repeater->add_control(
			'image',
			[
				'label'     => __('Hunting Image', 'marino'),
				'type'      => Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater->add_control(
			'title',
			[
				'label' 		=> __('Title', 'marino'),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __('Safe Cleaning Supplies', 'marino'),
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'desc',
			[
				'label' 		=> __('Content', 'marino'),
				'type' 			=> Controls_Manager::WYSIWYG,
				'default' 		=> __('Safe Cleaning Supplies', 'marino'),
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'button_text',
			[
				'label' 		=> esc_html__('Button Text', 'marino'),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __('Read More', 'marino'),
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'button_link',
			[
				'label' 		=> esc_html__('Link', 'marino'),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__('https://your-link.com', 'marino'),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$this->add_control(
			'hunting_spot',
			[
				'label' 		=> __('Huntings', 'marino'),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __('Safe Cleaning Supplies', 'marino'),
					],
				],
				'title_field' 	=> '{{{ title }}}',
			]
		);

		$this->end_controls_section();
		/*-----------------------------------------title styling------------------------------------*/


		$this->start_controls_section(
			'title_styling',
			[
				'label' 	=> __('Title Styling', 'marino'),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'service_title_color',
			[
				'label' 		=> __('Title Color', 'marino'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .service_style3 .service_title'	=> 'color: {{VALUE}}!important;',
				]
			]
		);
		$this->add_control(
			'service_title_hvr_color',
			[
				'label' 		=> __('Title Hover Color', 'marino'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .service_style3 .service_title a:hover'	=> 'color: {{VALUE}}!important;',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'service_title_typography',
				'label' 		=> esc_html__('Title Typography', 'marino'),
				'selector' 		=> '{{WRAPPER}} .service_style3 .service_title',
			]
		);

		$this->add_responsive_control(
			'service_title_margin',
			[
				'label' 		=> __('Title Margin', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .service_style3 .service_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'service_title_padding',
			[
				'label' 		=> __('Title Padding', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .service_style3 .service_title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();



		/*-----------------------------------------Button styling------------------------------------*/

		$this->start_controls_section(
			'button_style_section',
			[
				'label' 	=> __('Button Style', 'marino'),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'button_color',
			[
				'label' 		=> __('Color', 'marino'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .service_style3 .vs-btn' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_txt_color',
			[
				'label' 		=> __('Text Color', 'marino'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .service_style3 .vs-btn' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_color_hover',
			[
				'label' 		=> __('Hover Color', 'marino'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .service_style3 .vs-btn:hover' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'button_hover_txt_color',
			[
				'label' 		=> __('Hover Text Color', 'marino'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .service_style3 .vs-btn:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'button_typography',
				'label' 	=> __('Typography', 'marino'),
				'selector' 	=> '{{WRAPPER}} .service_style3 .vs-btn',
			]
		);
		$this->end_controls_section();
	}

	protected function render() {

		$settings = $this->get_settings_for_display();
		if ('1' == $settings['hunter_style']) {
			echo '<div class="service_style3">';
			foreach ($settings['hunting_spot'] as $data) {
				$link = !empty($data['button_link']['url']) ? $data['button_link']['url'] : '#';
				echo '<div class="service_inner">';
?>

				<?php if (!empty($data['image'])) : ?>
					<a href="<?php echo esc_url($link) ?>" class="service_img" style="background-image: url(<?php echo esc_url($data['image']['url']); ?>)"></a>
				<?php endif; ?>

				<?php
				echo '<div class="service_content">';
				if (!empty($data['title'])) {
					echo '<h3 class="service_title"><a href="' . esc_url($link) . '">' . esc_html($data['title']) . '</a></h3>';
				}
				if (!empty($data['desc'])) {
					echo '<span class="service_text">' . wp_kses_post($data['desc']) . '</span>';
				}
				?>
				<a href="<?php echo esc_html($link); ?>" class="vs-btn style3">
					<?php echo esc_html($data['button_text']); ?>
					<i class="fal fa-arrow-right"></i>
				</a>;
			<?php
				echo '</div>';
				echo '</div>';
			}
			echo '</div>';
		} elseif ('2' == $settings['hunter_style']) { ?>
			<div class="container-fluid">
				<div class="row vs-carousel" data-arrows="true" data-wow-delay="0.4s" data-slide-show="5" data-lg-slide-show="4" data-md-slide-show="2" data-center-mode="true" data-xl-center-mode="true" data-ml-center-mode="true" data-lg-center-mode="true" data-md-center-mode="true" data-sm-center-mode="true">
					<?php foreach ($settings['hunting_spot'] as $data) : ?>
						<div class="col-auto">
							<div class="service_style5">
								<div class="service_inner mega-hover">
									<?php if (!empty($data['image']['url'])) : ?>
										<div class="service_img">
											<?php echo marino_img_tag(array(
												'url'	=> esc_url($data['image']['url']),
											));
											?>
										</div>
									<?php endif; ?>

									<?php if ($data['button_link']['url']) : ?>
										<div class="service_icon">
											<a href="<?php echo esc_url($data['button_link']['url']); ?>" class="icon-btn"><i class="far fa-arrow-up"></i></a>
										</div>
									<?php endif; ?>

									<div class="service_content">
										<?php if (!empty($data['title'])) : ?>
											<a href="<?php echo esc_url($data['button_link']['url']); ?>">
												<h2 class="service_title"><?php echo esc_html($data['title']) ?></h2>
											</a>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
			</div>
<?php }
	}
}
