<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\HEADING;
use \Elementor\Repeater;
/**
 *
 * Image Widget .
 *
 */
class Marino_Hero_Video extends Widget_Base {

	public function get_name() {
		return 'marinoherovideo';
	} 

	public function get_title() {
		return __( 'Hero Video', 'marino' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'marino' ];
	}

	protected function register_controls() {

		//Top Content
		$this->start_controls_section(
			'slider_content',
			[
				'label' 	=> __( 'Slider Content', 'marino' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'bg_video',
            [
				'label'         => __( 'Background Video Url? Please set .mp4 extention video.', 'marino' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( '#' , 'marino' ),
				'label_block'   => true,
			]
		);
        $this->add_control(
			'shape_image',
			[
				'label'     => __( 'Shape Image', 'marino' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'title',
            [
				'label'         => __( 'Title', 'marino' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Skin Refresh' , 'marino' ),
				'label_block'   => true,
			]
		);
        $this->add_control(
			'sub_title',
            [
				'label'         => __( 'Sub Title', 'marino' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'skincare inspires' , 'marino' ),
				'label_block'   => true,
			]
		);
        $this->add_control(
			'button_text',
            [
				'label'         => __( 'Button Text', 'marino' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Appointment' , 'marino' ),
				'label_block'   => true,
			]
		);
		$this->add_control(
			'button_link',
			[
				'label' 		=> __( 'Button Url', 'marino' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'marino' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);
		$this->add_control(
			'video_url',
            [
				'label'         => __( 'Video Url?', 'marino' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( '#' , 'marino' ),
				'label_block'   => true,
			]
		);

        $this->end_controls_section();


		//Button  Style
		$this->start_controls_section(
			'slider_settings',
			[
				'label' 	=> __( 'Slider Settings', 'marino' ),
                'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
		$this->add_control(
			'slider_autoplay',
			[
				'label' 		=> __( 'Autoplay', 'marino' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'marino' ),
				'label_off' 	=> __( 'No', 'marino' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$this->add_control(
			'slider_dots',
			[
				'label' 		=> __( 'Slider Dots', 'marino' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'marino' ),
				'label_off' 	=> __( 'No', 'marino' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$this->add_control(
			'slider_arrows',
			[
				'label' 		=> __( 'Slider Arrows', 'marino' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'marino' ),
				'label_off' 	=> __( 'No', 'marino' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'title_style',
			[
				'label' 	=> __( 'Title', 'marino' ),
                'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_control(
			'title_color',
			[
				'label' 	=> __( 'Color', 'marino' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}  .hero-title' => 'color: {{VALUE}}',
                ],
			]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'title_typo',
				'label' 	=> __( 'Title Typo', 'marino' ),
                'selector' 	=> '{{WRAPPER}}  .hero-title',
			]
		);
		$this->end_controls_section();


		$this->start_controls_section(
			'subtitle_style',
			[
				'label' 	=> __( 'Subtitle', 'marino' ),
                'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_control(
			'subtitle_color',
			[
				'label' 	=> __( 'Color', 'marino' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hero-text' => 'color: {{VALUE}}',
                ],
			]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'sub_typo',
				'label' 	=> __( 'Button Typo', 'marino' ),
                'selector' 	=> '{{WRAPPER}} .hero-text',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'button_style',
			[
				'label' 	=> __( 'Button', 'marino' ),
                'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_control(
			'button_color',
			[
				'label' 	=> __( 'Color', 'marino' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .vs-btn' => 'color: {{VALUE}}',
                ],
			]
        );

		$this->add_control(
			'button_bg_color',
			[
				'label' 	=> __( 'Background Color', 'marino' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .vs-btn' => 'background-color: {{VALUE}}',
                ],
			]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'button_typo',
				'label' 	=> __( 'Button Typo', 'marino' ),
                'selector' 	=> '{{WRAPPER}} .vs-btn',
			]
		);

        $this->add_control(
			'button_icon_color',
			[
				'label' 	=> __( 'Button Icon Color', 'marino' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .vs-btn i' => 'color: {{VALUE}}',
                ],
			]
        );

		$this->add_control(
			'button_hover',
			[
				'label' => esc_html__( 'Button Hover', 'marino' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'button_color_active',
			[
				'label' 	=> __( 'Color', 'marino' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .vs-btn:hover' => 'color: {{VALUE}}',
                ],
			]
        );

		$this->add_control(
			'button_bg_color_active',
			[
				'label' 	=> __( 'Background Color', 'marino' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .vs-btn:before,{{WRAPPER}} .vs-btn:after' => 'background-color: {{VALUE}}',
                ],
			]
        );
		$this->end_controls_section();

		$this->start_controls_section(
			'video_btn',
			[
				'label' 	=> __( 'Video Button', 'marino' ),
                'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_control(
			'video_button_color',
			[
				'label' 	=> __( 'Button Color', 'marino' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .play-btn1 i' => 'color: {{VALUE}}',
                ],
			]
        );

		$this->add_control(
			'video_button_bg_color',
			[
				'label' 	=> __( 'Background Color', 'marino' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .play-btn1' => 'background-color: {{VALUE}}',
                ],
			]
        );

		$this->add_control(
			'video_button_hover',
			[
				'label' => esc_html__( 'Button Hover', 'marino' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'video_button_color_active',
			[
				'label' 	=> __( 'Color', 'marino' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .play-btn1:hover i' => 'color: {{VALUE}}',
                ],
			]
        );

		$this->add_control(
			'video_button_bg_color_active',
			[
				'label' 	=> __( 'Background Color', 'marino' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .play-btn1:hover' => 'background-color: {{VALUE}}',
                ],
			]
        );
		$this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();


        echo '<div class="hero-layout1 style3 shape-mockup-wrap position-relative">';
            echo '<div class="hero-inner">';
                if( ! empty( $settings['bg_video'] ) ){
                    echo '<video autoplay muted loop style>';
                        echo '<source src="'.esc_url( $settings['bg_video'] ).'">';
                    echo '</video>';
                }
                if( ! empty( $settings['shape_image']['url'] ) ){
                    echo '<div class="shape-mockup hero-shape jump-img d-none d-xxl-block">';
                        echo marino_img_tag( array(
                            'url'	=> esc_url( $settings['shape_image']['url'] ),
                        ) );
                    echo '</div>';
                }
                echo '<div class="container">';
                    echo '<div class="hero-content">';
                        if( ! empty( $settings['title'] ) ){
                            echo '<h1 class="hero-title animated">'.wp_kses_post( $settings['title'] ).'</h1>';
                        }
                        if( ! empty( $settings['sub_title'] ) ){
                            echo '<p class="hero-text animated">'.esc_html( $settings['sub_title'] ).'</p>';
                        }
                        
                        echo '<div class="hero-btns animated">';
                            if( ! empty( $settings['button_text'] ) ){
                                echo '<a href="'.esc_url( $settings['button_link']['url'] ).'" class="vs-btn me-3">'.esc_html( $settings['button_text'] ).' <i class="far fa-arrow-right"></i></a>';
                            }
                            if( ! empty( $settings['video_url'] ) ){
                                echo '<a href="'.esc_url( $settings['video_url'] ).'" class="play-btn1 popup-video"><i class="fas fa-play"></i></a>';
                            }
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        echo '</div>';
	}

}