<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\HEADING;
use \Elementor\Repeater;

/**
 *
 * Image Widget .
 *
 */
class Marino_Hero_Slider extends Widget_Base {

	public function get_name() {
		return 'marinoheroslider';
	}

	public function get_title() {
		return __('Hero Slider', 'marino');
	}

	public function get_icon() {
		return 'eicon-code';
	}

	public function get_categories() {
		return ['marino'];
	}

	protected function register_controls() {

		//Top Content
		$this->start_controls_section(
			'slider_content',
			[
				'label' 	=> __('Slider Content', 'marino'),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'slider_style',
			[
				'label'     => __('Slider Style', 'marino'),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => '1',
				'options'   => [
					'1'         => __('Style One', 'marino'),
					'2'         => __('Style Two', 'marino'),
					'3'         => __('Style Three', 'marino'),
					'4'         => __('Style Four', 'marino'),
				],
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'bg_image',
			[
				'label'     => __('Background Image', 'marino'),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'shape_image',
			[
				'label'     => __('Shape Image', 'marino'),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'title',
			[
				'label'         => __('Title', 'marino'),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __('Skin Refresh', 'marino'),
				'label_block'   => true,
			]
		);
		$repeater->add_control(
			'sub_title',
			[
				'label'         => __('Sub Title', 'marino'),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __('skincare inspires', 'marino'),
				'label_block'   => true,
			]
		);
		$repeater->add_control(
			'button_text',
			[
				'label'         => __('Button Text', 'marino'),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __('Appointment', 'marino'),
				'label_block'   => true,
			]
		);
		$repeater->add_control(
			'button_link',
			[
				'label' 		=> __('Button Url', 'marino'),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __('https://your-link.com', 'marino'),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> true,
					'nofollow' 		=> true,
				],
			]
		);
		$repeater->add_control(
			'video_url',
			[
				'label'         => __('Video Url?', 'marino'),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __('#', 'marino'),
				'label_block'   => true,
			]
		);
		$this->add_control(
			'hero_slider',
			[
				'label' 		=> __('Sliders', 'marino'),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'bg_image' 	  => Utils::get_placeholder_image_src(),
						'sub_title'   => __('Lorem ipsum dolor sit amet consectur adipiscing elit eiusmod ex tempor incididunt labore dolore magna aliquaenim ad minim veniam quis nostrud exercitation laboris.', 'marino'),
						'title'       => __('Let’s Go..!<br>Fishing With Marino', 'marino'),
						'button_text' => __('About Us', 'marino'),
						'button_link' => __('#', 'marino')
					],
					[
						'bg_image' 	  => Utils::get_placeholder_image_src(),
						'sub_title'   => __('Lorem ipsum dolor sit amet consectur adipiscing elit eiusmod ex tempor incididunt labore dolore magna aliquaenim ad minim veniam quis nostrud exercitation laboris.', 'marino'),
						'title'       => __('Wild Fishing...!<br>Fishing With Proffetional', 'marino'),
						'button_text' => __('About Us', 'marino'),
						'button_link' => __('#', 'marino')
					],
					[
						'bg_image' 	  => Utils::get_placeholder_image_src(),
						'sub_title'   => __('Lorem ipsum dolor sit amet consectur adipiscing elit eiusmod ex tempor incididunt labore dolore magna aliquaenim ad minim veniam quis nostrud exercitation laboris.', 'marino'),
						'title'       => __('Solo Fishing...<br>Lets Fishing Be fun', 'marino'),
						'button_text' => __('About Us', 'marino'),
						'button_link' => __('#', 'marino')
					],
				],
				'title_field' 	=> '{{title}}',
			]
		);

		$this->end_controls_section();


		//Button  Style
		$this->start_controls_section(
			'slider_settings',
			[
				'label' 	=> __('Slider Settings', 'marino'),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'slider_autoplay',
			[
				'label' 		=> __('Autoplay', 'marino'),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __('Yes', 'marino'),
				'label_off' 	=> __('No', 'marino'),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$this->add_control(
			'slider_dots',
			[
				'label' 		=> __('Slider Dots', 'marino'),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __('Yes', 'marino'),
				'label_off' 	=> __('No', 'marino'),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$this->add_control(
			'slider_arrows',
			[
				'label' 		=> __('Slider Arrows', 'marino'),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __('Yes', 'marino'),
				'label_off' 	=> __('No', 'marino'),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'title_style',
			[
				'label' 	=> __('Title', 'marino'),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' 	=> __('Color', 'marino'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}  .hero-title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'title_typo',
				'label' 	=> __('Title Typo', 'marino'),
				'selector' 	=> '{{WRAPPER}}  .hero-title',
			]
		);
		$this->end_controls_section();


		$this->start_controls_section(
			'subtitle_style',
			[
				'label' 	=> __('Subtitle', 'marino'),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'subtitle_color',
			[
				'label' 	=> __('Color', 'marino'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hero-text' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'sub_typo',
				'label' 	=> __('Button Typo', 'marino'),
				'selector' 	=> '{{WRAPPER}} .hero-text',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'button_style',
			[
				'label' 	=> __('Button', 'marino'),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'button_color',
			[
				'label' 	=> __('Color', 'marino'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .vs-btn' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_bg_color',
			[
				'label' 	=> __('Background Color', 'marino'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .vs-btn' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'button_typo',
				'label' 	=> __('Button Typo', 'marino'),
				'selector' 	=> '{{WRAPPER}} .vs-btn',
			]
		);

		$this->add_control(
			'button_icon_color',
			[
				'label' 	=> __('Button Icon Color', 'marino'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .vs-btn i' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_hover',
			[
				'label' => esc_html__('Button Hover', 'marino'),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'button_color_active',
			[
				'label' 	=> __('Color', 'marino'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .vs-btn:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_bg_color_active',
			[
				'label' 	=> __('Background Color', 'marino'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .vs-btn:before,{{WRAPPER}} .vs-btn:after' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'video_btn',
			[
				'label' 	=> __('Video Button', 'marino'),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'video_button_color',
			[
				'label' 	=> __('Button Color', 'marino'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .play-btn1 i' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'video_button_bg_color',
			[
				'label' 	=> __('Background Color', 'marino'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .play-btn1' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'video_button_hover',
			[
				'label' => esc_html__('Button Hover', 'marino'),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'video_button_color_active',
			[
				'label' 	=> __('Color', 'marino'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .play-btn1:hover i' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'video_button_bg_color_active',
			[
				'label' 	=> __('Background Color', 'marino'),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .play-btn1:hover' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		$this->add_render_attribute('wrapper', 'class', 'vs-carousel hero-slider');

		if ($settings['slider_autoplay'] == 'yes') {
			$this->add_render_attribute('wrapper', 'data-slick-autoplay', 'true');
		} else {
			$this->add_render_attribute('wrapper', 'data-slick-autoplay', 'false');
		}

		if ($settings['slider_arrows'] == 'yes') {
			$this->add_render_attribute('wrapper', 'data-slick-arrows', 'true');
		} else {
			$this->add_render_attribute('wrapper', 'data-slick-arrows', 'false');
		}

		if ($settings['slider_dots'] == 'yes') {
			$this->add_render_attribute('wrapper', 'data-slick-dots', 'true');
		} else {
			$this->add_render_attribute('wrapper', 'data-slick-dots', 'false');
		}

		$this->add_render_attribute('wrapper', 'data-slide-to-show', '1');

		if ($settings['slider_style'] == '1') {
			$section_class = 'hero-layout1';
		} else {
			$section_class = 'hero-layout1 style2';
		}

		if (!empty($settings['hero_slider'])) {
			if ($settings['slider_style'] == '1' || $settings['slider_style'] == '2') {
				echo '<section class="' . esc_attr($section_class) . '">';
				echo '<div ' . $this->get_render_attribute_string('wrapper') . '>';
				foreach ($settings['hero_slider'] as $singleslide) {
					echo '<div>';
					echo '<div class="hero-inner">';
					if (!empty($singleslide['bg_image']['url'])) {
						echo '<div class="hero-bg background-image" data-bg-src="' . esc_url($singleslide['bg_image']['url']) . '"></div>';
					}

					if (!empty($singleslide['shape_image']['url'])) {
						echo '<div class="shape-mockup hero-shape jump-img d-none d-xxl-block">';
						echo marino_img_tag(array(
							'url'	=> esc_url($singleslide['shape_image']['url']),
						));
						echo '</div>';
					}
					echo '<div class="container">';
					echo '<div class="hero-content">';
					if (!empty($singleslide['title'])) {
						echo '<h1 class="hero-title animated">' . wp_kses_post($singleslide['title']) . '</h1>';
					}
					if (!empty($singleslide['sub_title'])) {
						echo '<p class="hero-text animated">' . esc_html($singleslide['sub_title']) . '</p>';
					}

					echo '<div class="hero-btns animated">';
					if (!empty($singleslide['button_text'])) {
						echo '<a href="' . esc_url($singleslide['button_link']['url']) . '" class="vs-btn me-3">' . esc_html($singleslide['button_text']) . ' <i class="far fa-arrow-right"></i></a>';
					}
					if (!empty($singleslide['video_url'])) {
						echo '<a href="' . esc_url($singleslide['video_url']) . '" class="play-btn1 popup-video"><i class="fas fa-play"></i></a>';
					}
					echo '</div>';
					echo '</div>';
					echo '</div>';
					echo '</div>';
					echo '</div>';
				}
				echo '</div>';
				echo '</section>';
			} elseif ($settings['slider_style'] == '3') { ?>
				<div class="hero-layout2 position-relative">
					<div class="row vs-carousel2" data-arrows="true" data-dots="false">
						<?php foreach ($settings['hero_slider'] as $singleslide) : ?>
							<div class="hero-inner">
								<div class="hero-bg background-image" data-bg-src="<?php echo esc_url($singleslide['bg_image']['url']) ?>"></div>
								<div class="container">
									<div class="row justify-content-center">
										<div class="col-lg-9">
											<div class="hero-content">
												<?php
												if (!empty($singleslide['sub_title'])) {
													echo '<p class="hero-text">' . esc_html($singleslide['sub_title']) . '</p>';
												}
												if (!empty($singleslide['title'])) {
													echo '<h1 class="hero-title">' . wp_kses_post($singleslide['title']) . '</h1>';
												}
												?>
												<?php if (!empty($singleslide['button_text'])) : ?>
													<div class="hero-btns">
														<a href="<?php echo esc_url($singleslide['button_link']['url']); ?>" class="vs-btn me-3"><?php echo  esc_html($singleslide['button_text']) ?><i class="far fa-arrow-right"></i></a>
													</div>
												<?php endif; ?>
											</div>
										</div>
									</div>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
			<?php } elseif ($settings['slider_style'] == '4') { ?>
				<div class="hero-layout2 position-relative">
					<div class="row vs-carousel2" data-arrows="true" data-dots="false">
						<?php foreach ($settings['hero_slider'] as $singleslide) : ?>
							<div class="hero-inner">
								<div class="hero-bg background-image" data-bg-src="<?php echo esc_url($singleslide['bg_image']['url']) ?>"></div>
								<div class="container">
									<div class="row justify-content-start">
										<div class="col-lg-9">
											<div class="hero-content text-start">
												<?php
												if (!empty($singleslide['sub_title'])) {
													echo '<p class="hero-text">' . esc_html($singleslide['sub_title']) . '</p>';
												}
												if (!empty($singleslide['title'])) {
													echo '<h1 class="hero-title">' . wp_kses_post($singleslide['title']) . '</h1>';
												}
												?>
												<?php if (!empty($singleslide['button_text'])) : ?>
													<div class="hero-btns">
														<a href="<?php echo esc_url($singleslide['button_link']['url']); ?>" class="vs-btn me-3"><?php echo  esc_html($singleslide['button_text']) ?><i class="far fa-arrow-right"></i></a>
													</div>
												<?php endif; ?>
											</div>
										</div>
									</div>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
<?php }
		}
	}
}
