<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;

/**
 *
 * Counter Widget .
 *
 */
class Marino_Counterup extends Widget_Base {

	public function get_name() {
		return 'marinocounterup';
	}

	public function get_title() {
		return __('Counter Up', 'marino');
	}

	public function get_icon() {
		return 'eicon-code';
	}

	public function get_categories() {
		return ['marino'];
	}

	public function get_script_depends() {
		return ['counter-up'];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'counter_section',
			[
				'label' 	=> __('Content', 'marino'),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'counter_style',
			[
				'label'     => __('Style', 'marino'),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => '1',
				'options'   => [
					'1'         => __('Style One', 'marino'),
					'2'         => __('Style Two', 'marino'),
				],
			]
		);
		$this->add_control(
			'counter_bg_image',
			[
				'label' 	=> esc_html__('Counter Bg Image', 'marino'),
				'type' 		=> Controls_Manager::MEDIA,
				'default' => [
					'url' 	=> Utils::get_placeholder_image_src(),
				],
				'condition'     => [
					'counter_style' => ['1']
				]
			]
		);
		$this->add_control(
			'counter_icon_image',
			[
				'label' 	=> esc_html__('Counter Icon Image', 'marino'),
				'type' 		=> Controls_Manager::MEDIA,
				'default' => [
					'url' 	=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'counter_number',
			[
				'label'     => __('Counter Number', 'marino'),
				'type'      => Controls_Manager::TEXTAREA,
				'default' 	=> __('25', 'marino'),
			]
		);
		$this->add_control(
			'counter_text',
			[
				'label'     => __('Counter Text', 'marino'),
				'type'      => Controls_Manager::TEXTAREA,
				'default' 	=> __('Happy Clients', 'marino'),
			]
		);

		$this->add_control(
			'counter_suffix_text',
			[
				'label'     => __('Counter Suffix Text', 'marino'),
				'type'      => Controls_Manager::TEXTAREA,
				'default' 	=> __('+', 'marino'),
			]
		);



		$this->end_controls_section();

		$this->start_controls_section(
			'counterup_style_section',
			[
				'label' 	=> __('Counter Up Style', 'marino'),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'counterup_color',
			[
				'label' 		=> __('Counter Up Color', 'marino'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .media-counter .media-title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'counterup_typhography',
				'label' 		=> __('Counter Up Typography', 'marino'),
				'selector' 		=> '{{WRAPPER}} .media-counter .media-title',
			]
		);
		$this->add_control(
			'counterup_text_color',
			[
				'label' 		=> __('Counter Up Text Color', 'marino'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .media-style1 .media-text,{{WRAPPER}} .media-style3 .media-counter .media-text' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'counterup_text_typhography',
				'label' 		=> __('Counter Up Text Typography', 'marino'),
				'selector' 		=> '{{WRAPPER}} .media-style1 .media-text,{{WRAPPER}} .media-style3 .media-counter .media-text',
			]
		);

		$this->end_controls_section();
	}

	protected function render() {

		$settings = $this->get_settings_for_display();
		if ($settings['counter_style'] == '1') {
			echo '<div class="media-style1">';
			echo '<div class="media-icon">';
			if (!empty($settings['counter_bg_image']['url'])) {
				echo marino_img_tag(array(
					'url'   => esc_url($settings['counter_bg_image']['url'])
				));
			}
			if (!empty($settings['counter_icon_image']['url'])) {
				echo '<div class="icon">';
				echo marino_img_tag(array(
					'url'   => esc_url($settings['counter_icon_image']['url'])
				));
				echo '</div>';
			}
			echo '</div>';
			echo '<div class="media-counter">';
			if (!empty($settings['counter_number'])) {
				echo '<h2 class="media-title counter">' . esc_html($settings['counter_number']) . '</h2>';
			}
			if (!empty($settings['counter_suffix_text'])) {
				echo '<span class="media-count_icon">' . esc_html($settings['counter_suffix_text']) . '</span>';
			}
			echo '</div>';
			if (!empty($settings['counter_text'])) {
				echo '<p class="media-text">' . esc_html($settings['counter_text']) . '</p>';
			}
			echo '</div>';
		} elseif ($settings['counter_style'] == '2') { ?>
			<div class="media-style3">
				<?php if (!empty($settings['counter_icon_image']['url'])) : ?>
					<div class="media-icon">
						<div class="icon">
							<?php echo marino_img_tag(array(
								'url'   => esc_url($settings['counter_icon_image']['url'])
							)); ?>
						</div>
					</div>
				<?php endif; ?>
				<div class="media-counter">
					<?php if (!empty($settings['counter_number'])) :; ?>
						<h2 class="media-title counter-number" data-count="<?php echo esc_attr($settings['counter_number']) ?>"><?php echo esc_html($settings['counter_number']) ?></h2>
						<?php if (!empty($settings['counter_suffix_text'])) {
							echo '<span class="media-count_icon">' . esc_html($settings['counter_suffix_text']) . '</span>';
						} ?>
					<?php endif; ?>
					<?php if (!empty($settings['counter_text'])) {
						echo '<p class="media-text">' . esc_html($settings['counter_text']) . '</p>';
					} ?>
				</div>

			</div>
<?php }
	}
}
