<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
/**
 *
 * Header Widget .
 *
 */
class Marino_Offcanvas extends Widget_Base {

	public function get_name() {
		return 'marinooffcanvas';
	}

	public function get_title() {
		return __( 'Offcanvas', 'marino' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'marino_header_elements' ];
	}

	protected function _register_controls() {

        $this->start_controls_section(
			'cart_styling',
			[
				'label'     => __( 'Offcanvas Styling', 'marino' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'offcanvas_icon_color',
			[
				'label' 		=> __( 'Offcanvas Icon Color', 'foodelio' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bar-btn i' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'offcanvas_icon_hover_color',
			[
				'label' 		=> __( 'Offcanvas Icon Hover Color', 'foodelio' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bar-btn:hover i' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'offcanvas_icon_backgroound_color',
			[
				'label' 		=> __( 'Offcanvas Icon background Color', 'foodelio' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bar-btn' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'offcanvas_icon_backgroound_hover_color',
			[
				'label' 		=> __( 'Offcanvas Icon Background Hover Color', 'foodelio' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bar-btn:hover' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->end_controls_section();

    }


	protected function render() {

        $settings = $this->get_settings_for_display();

        echo '<a href="#" class="bar-btn sideMenuToggler d-none d-xl-block"><i class="far fa-bars"></i></a>';


       // Offcanvas Menu
		if( is_active_sidebar( 'marino-offcanvas-sidebar' ) ){
			echo '<div class="sidemenu-wrapper sidemenu-offcanvas d-none d-lg-block">';
		        echo '<div class="sidemenu-content">';
		            echo '<button class="closeButton sideMenuCls"><i class="far fa-times"></i></button>';
		           dynamic_sidebar( 'marino-offcanvas-sidebar' );
		        echo '</div>';
		    echo '</div>';
		}

	}
}