<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
/**
 *
 * Header Widget .
 *
 */
class Marino_Header_Info extends Widget_Base {

	public function get_name() {
		return 'marinoheaderinfo';
	}

	public function get_title() {
		return __( 'Header Info', 'marino' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'marino_header_elements' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'headerinfo_section',
			[
				'label' 	=> __( 'Header Info', 'marino' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'info_icon',
			[
				'label' 		=> __( 'Info Icon', 'marino' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'fas fa-phone-alt', 'marino' ),
			]
		);

		$this->add_control(
			'info_label_text',
			[
				'label' 		=> __( 'Info Label text', 'marino' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Call Now', 'marino' ),
			]
		);

		$this->add_control(
			'phone_number',
			[
				'label' 		=> __( 'Phone Number', 'marino' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( '(+269) 2156 2148', 'marino' ),
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'info_styling',
			[
				'label'     => __( 'Info Styling', 'marino' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
        );

		$this->add_control(
			'info_bg_color',
			[
				'label' 		=> __( 'Info Background Color', 'foodelio' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .header-info' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'icon_color',
			[
				'label' 		=> __( 'Icon Color', 'foodelio' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .header-info .icon-btn' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'label_text',
			[
				'label' 		=> __( 'Label Text Color', 'foodelio' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .header-info .header-info_label' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'phone_number_color',
			[
				'label' 		=> __( 'Number Text Color', 'foodelio' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .header-info .infobox-link' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'phone_number_color_hover',
			[
				'label' 		=> __( 'Number Text Color Hover', 'foodelio' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .header-info .infobox-link:hover' => 'color: {{VALUE}};',
				],
			]
		);

        $this->end_controls_section();

    }


	protected function render() {

        $settings = $this->get_settings_for_display();

        $phone          = ( !empty( $settings['phone_number'] ) ) ? $settings['phone_number'] : "";

        $replace        = array(' ','-',' - ');
        $with           = array('','','');
        $mobileurl      = str_replace( $replace, $with, $phone );

		echo '<div class="header-info">';
            if( ! empty( $settings['info_icon'] ) ){
                echo '<div class="icon-btn"><i class="'.esc_attr( $settings['info_icon'] ).'"></i></div>';
            }
            echo '<div class="media-body">';
                if( ! empty( $settings['info_label_text'] ) ){
                    echo '<span class="header-info_label">'.esc_html( $settings['info_label_text'] ).'</span>';
                }
                if( ! empty( $phone ) ){
					echo '<div class="header-info_link">';
                    	echo '<a href="tel:'.esc_attr( $mobileurl ).'" class="infobox-link">'.esc_html( $phone ).'</a>';
					echo '</div>';
                }
            echo '</div>';
        echo '</div>';

	}
}