<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
/**
 *
 * Header Widget .
 *
 */
class Marino_Cart_Count extends Widget_Base {

	public function get_name() {
		return 'marinocartcount';
	}

	public function get_title() {
		return __( 'Cart Count', 'marino' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'marino_header_elements' ];
	}

	protected function _register_controls() {

        $this->start_controls_section(
			'cart_styling',
			[
				'label'     => __( 'Cart Styling', 'marino' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'cart_icon_color',
			[
				'label' 		=> __( 'Cart Icon Color', 'foodelio' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .icon-btn i,{{WRAPPER}} .cart-btn i' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'cart_icon_hover_color',
			[
				'label' 		=> __( 'Cart Icon Hover Color', 'foodelio' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .icon-btn:hover i,{{WRAPPER}} .cart-btn:hover i' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'cart_icon_backgroound_color',
			[
				'label' 		=> __( 'Cart Icon background Color', 'foodelio' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .icon-btn,{{WRAPPER}} .cart-btn' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'cart_icon_backgroound_hover_color',
			[
				'label' 		=> __( 'Cart Icon Background Hover Color', 'foodelio' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .icon-btn:hover,{{WRAPPER}} .cart-btn:hover' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'cart_count_backgroound_color',
			[
				'label' 		=> __( 'Cart Count Background Color', 'foodelio' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .icon-btn .cart-count,{{WRAPPER}} .cart-btn .cart-count' => 'background-color: {{VALUE}}',
				],
				'separator'		=> 'after',
			]
		);

        $this->end_controls_section();

    }


	protected function render() {

        $settings = $this->get_settings_for_display();

		if( class_exists( 'woocommerce' ) ){
            global $woocommerce;
            if( ! empty( $woocommerce->cart->cart_contents_count ) ){
                $count = $woocommerce->cart->cart_contents_count;
            }else{
                $count = "0";
            }
            echo '<a href="#" class="icon-btn has-badge sideMenuToggler2"><i class="fal fa-shopping-cart"></i><span class="badge cart-count">'.esc_html( $count ).'</span></a>';
        }

        if( class_exists( 'woocommerce' ) ){
			echo '<div class="sidemenu-wrapper cart-offcanvas d-none d-lg-block">';
				echo '<div class="sidemenu-content">';
					echo '<button class="closeButton border-theme sideMenuCls"><i class="far fa-times"></i></button>';
					echo '<div class="widget widget_shopping_cart woocommerce-mini-cart-content">';
						echo '<h3 class="widget_title">'.esc_html__( 'Shopping Cart', 'foodelio' ).'</h3>';
						echo '<div class="woocommerce-mini-cart-content widget_shopping_cart_content ">';
							woocommerce_mini_cart();
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';
		}

	}
}