<?php
/**
 * @Packge     : Marino
 * @Version    : 1.0
 * @Author     : Vecurosoft
 * @Author URI : https://www.vecurosoft.com/
 *
 */

    // Block direct access
    if( ! defined( 'ABSPATH' ) ){
        exit();
    }

    if( class_exists( 'ReduxFramework' ) && defined('ELEMENTOR_VERSION') ) {
        if( is_page() || is_page_template('template-builder.php') ) {
            $marino_post_id = get_the_ID();

            // Get the page settings manager
            $marino_page_settings_manager = \Elementor\Core\Settings\Manager::get_settings_managers( 'page' );

            // Get the settings model for current post
            $marino_page_settings_model = $marino_page_settings_manager->get_model( $marino_post_id );

            // Retrieve the color we added before
            $marino_header_style = $marino_page_settings_model->get_settings( 'marino_header_style' );
            $marino_header_builder_option = $marino_page_settings_model->get_settings( 'marino_header_builder_option' );

            if( $marino_header_style == 'header_builder'  ) {

                if( !empty( $marino_header_builder_option ) ) {
                    $marinoheader = get_post( $marino_header_builder_option );
                    echo '<header class="header">';
                        echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $marinoheader->ID );
                    echo '</header>';
                }
            } else {
                // global options
                $marino_header_builder_trigger = marino_opt('marino_header_options');
                if( $marino_header_builder_trigger == '2' ) {
                    echo '<header>';
                    $marino_global_header_select = get_post( marino_opt( 'marino_header_select_options' ) );
                    $header_post = get_post( $marino_global_header_select );
                    echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $header_post->ID );
                    echo '</header>';
                } else {
                    // wordpress Header
                    marino_global_header_option();
                }
            }
        } else {
            $marino_header_options = marino_opt('marino_header_options');
            if( $marino_header_options == '1' ) {
                marino_global_header_option();
            } else {
                $marino_header_select_options = marino_opt('marino_header_select_options');
                $marinoheader = get_post( $marino_header_select_options );
                echo '<header class="header">';
                    echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $marinoheader->ID );
                echo '</header>';
            }
        }
    } else {
        marino_global_header_option();
    }