<?php
/**
 * @Packge     : Marino
 * @Version    : 1.0
 * @Author     : Vecurosoft
 * @Author URI : https://www.vecurosoft.com/
 *
 */

    // Block direct access
    if( !defined( 'ABSPATH' ) ){
        exit();
    }

    if( defined( 'CMB2_LOADED' )  ){
        if( !empty( marino_meta('page_breadcrumb_area') ) ) {
            $marino_page_breadcrumb_area  = marino_meta('page_breadcrumb_area');
        } else {
            $marino_page_breadcrumb_area = '1';
        }
    }else{
        $marino_page_breadcrumb_area = '1';
    }

    $allowhtml = array(
        'p'         => array(
            'class'     => array()
        ),
        'span'      => array(
            'class'     => array(),
        ),
        'a'         => array(
            'href'      => array(),
            'title'     => array()
        ),
        'br'        => array(),
        'em'        => array(),
        'strong'    => array(),
        'b'         => array(),
        'sub'       => array(),
        'sup'       => array(),
    );

    if(  is_page() || is_page_template( 'template-builder.php' )  ) {
        if( $marino_page_breadcrumb_area == '1' ) {
            echo '<!-- Page title -->';
            echo '<div class="breadcumb-wrapper background-image">';
                echo '<div class="container z-index-common">';
                    echo '<div class="breadcumb-content">';
                        if( defined('CMB2_LOADED') || class_exists('ReduxFramework') ) {
                            if( marino_meta('page_breadcrumb_settings') == 'page' ) {
                                $marino_page_title_switcher = marino_meta('page_title');
                            } elseif( marino_opt('marino_page_title_switcher') == true ) {
                                $marino_page_title_switcher = marino_opt('marino_page_title_switcher');
                            }else{
                                $marino_page_title_switcher = '1';
                            }
                        } else {
                            $marino_page_title_switcher = '1';
                        }

                        if( $marino_page_title_switcher == '1' ){
                            if( class_exists( 'ReduxFramework' ) ){
                                $marino_page_title_tag    = marino_opt('marino_page_title_tag');
                            }else{
                                $marino_page_title_tag    = 'h1';
                            }

                            if( defined( 'CMB2_LOADED' )  ){
                                if( !empty( marino_meta('page_title_settings') ) ) {
                                    $marino_custom_title = marino_meta('page_title_settings');
                                } else {
                                    $marino_custom_title = 'default';
                                }
                            }else{
                                $marino_custom_title = 'default';
                            }

                            if( $marino_custom_title == 'default' ) {
                                echo marino_heading_tag(
                                    array(
                                        "tag"   => esc_attr( $marino_page_title_tag ),
                                        "text"  => esc_html( get_the_title( ) ),
                                        'class' => 'breadcumb-title'
                                    )
                                );
                            } else {
                                echo marino_heading_tag(
                                    array(
                                        "tag"   => esc_attr( $marino_page_title_tag ),
                                        "text"  => esc_html( marino_meta('custom_page_title') ),
                                        'class' => 'breadcumb-title'
                                    )
                                );
                            }

                        }
                        
                        
                        echo '</div>';
                echo '</div>';
            echo '</div>';
            echo '<!-- End of Page title -->';
            if( defined('CMB2_LOADED') || class_exists('ReduxFramework') ) {

                if( marino_meta('page_breadcrumb_settings') == 'page' ) {
                    $marino_breadcrumb_switcher = marino_meta('page_breadcrumb_trigger');
                } else {
                    $marino_breadcrumb_switcher = marino_opt('marino_enable_breadcrumb');
                }

            } else {
                $marino_breadcrumb_switcher = '1';
            }
            if( $marino_breadcrumb_switcher && (  is_page() || is_page_template( 'template-builder.php' ) )) {
                marino_breadcrumbs(
                    array(
                        'breadcrumbs_classes' => 'nav',
                    )
                );
            }
        }
    } else {
        echo '<!-- Page title -->';
        echo '<div class="breadcumb-wrapper background-image">';
            echo '<div class="container z-index-common">';
                echo '<div class="breadcumb-content">';
                    if( class_exists( 'ReduxFramework' )  ){
                        $marino_page_title_switcher  = marino_opt('marino_page_title_switcher');
                    }else{
                        $marino_page_title_switcher = '1';
                    }

                    if( $marino_page_title_switcher ){
                        if( class_exists( 'ReduxFramework' ) ){
                            $marino_page_title_tag    = marino_opt('marino_page_title_tag');
                        }else{
                            $marino_page_title_tag    = 'h1';
                        }
                        if( class_exists('woocommerce') && is_shop() ) {
                            echo marino_heading_tag(
                                array(
                                    "tag"   => esc_attr( $marino_page_title_tag ),
                                    "text"  => wp_kses( woocommerce_page_title( false ), $allowhtml ),
                                    'class' => 'breadcumb-title'
                                )
                            );
                        }elseif ( isset($_GET['view']) && ( $_GET['view'] == 'student' || $_GET['view'] == 'instructor' ) ) {
                            echo marino_heading_tag(
                                array(
                                    "tag"   => esc_attr( $marino_page_title_tag ),
                                    "text"  => __( 'Profile', 'marino' ),
                                    'class' => 'breadcumb-title'
                                )
                            );
                        }elseif ( is_archive() ){
                            echo marino_heading_tag(
                                array(
                                    "tag"   => esc_attr( $marino_page_title_tag ),
                                    "text"  => wp_kses( get_the_archive_title(), $allowhtml ),
                                    'class' => 'breadcumb-title'
                                )
                            );
                        }elseif ( is_home() ){
                            $marino_blog_page_title_setting = marino_opt('marino_blog_page_title_setting');
                            $marino_blog_page_title_switcher = marino_opt('marino_blog_page_title_switcher');
                            $marino_blog_page_custom_title = marino_opt('marino_blog_page_custom_title');
                            if( class_exists('ReduxFramework') ){
                                if( $marino_blog_page_title_switcher ){
                                    echo marino_heading_tag(
                                        array(
                                            "tag"   => esc_attr( $marino_page_title_tag ),
                                            "text"  => !empty( $marino_blog_page_custom_title ) && $marino_blog_page_title_setting == 'custom' ? esc_html( $marino_blog_page_custom_title) : esc_html__( 'Blog', 'marino' ),
                                            'class' => 'breadcumb-title'
                                        )
                                    );
                                }
                            }else{
                                echo marino_heading_tag(
                                    array(
                                        "tag"   => "h1",
                                        "text"  => esc_html__( 'Blog', 'marino' ),
                                        'class' => 'breadcumb-title',
                                    )
                                );
                            }
                        }elseif( is_search() ){
                            echo marino_heading_tag(
                                array(
                                    "tag"   => esc_attr( $marino_page_title_tag ),
                                    "text"  => esc_html__( 'Search Result', 'marino' ),
                                    'class' => 'breadcumb-title'
                                )
                            );
                        }elseif( is_404() ){
                            echo marino_heading_tag(
                                array(
                                    "tag"   => esc_attr( $marino_page_title_tag ),
                                    "text"  => esc_html__( '404 PAGE', 'marino' ),
                                    'class' => 'breadcumb-title'
                                )
                            );
                        }elseif( is_singular( 'courses' ) ){
                            echo marino_heading_tag(
                                array(
                                    "tag"   => "h1",
                                    "text"  => esc_html__( 'Course Details', 'marino' ),
                                    'class' => 'breadcumb-title',
                                )
                            );
                        }elseif( is_singular( 'product' ) ){
                            $posttitle_position  = marino_opt('marino_product_details_title_position');
                            $postTitlePos = false;
                            if( class_exists( 'ReduxFramework' ) ){
                                if( $posttitle_position && $posttitle_position != 'header' ){
                                    $postTitlePos = true;
                                }
                            }else{
                                $postTitlePos = false;
                            }

                            if( $postTitlePos != true ){
                                echo marino_heading_tag(
                                    array(
                                        "tag"   => esc_attr( $marino_page_title_tag ),
                                        "text"  => wp_kses( get_the_title( ), $allowhtml ),
                                        'class' => 'breadcumb-title'
                                    )
                                );
                            } else {
                                if( class_exists( 'ReduxFramework' ) ){
                                    $marino_post_details_custom_title  = marino_opt('marino_product_details_custom_title');
                                }else{
                                    $marino_post_details_custom_title = __( 'Shop Details','marino' );
                                }

                                if( !empty( $marino_post_details_custom_title ) ) {
                                    echo marino_heading_tag(
                                        array(
                                            "tag"   => esc_attr( $marino_page_title_tag ),
                                            "text"  => wp_kses( $marino_post_details_custom_title, $allowhtml ),
                                            'class' => 'breadcumb-title'
                                        )
                                    );
                                }
                            }
                        }else{
                            $posttitle_position  = marino_opt('marino_post_details_title_position');
                            $postTitlePos = false;
                            if( is_singular( 'post' ) ){
                                if( class_exists( 'ReduxFramework' ) ){
                                    if( $posttitle_position && $posttitle_position != 'header' ){
                                        $postTitlePos = true;
                                    }
                                }else{
                                    $postTitlePos = false;
                                }
                            }
                            if( is_singular( 'product' ) ){
                                $posttitle_position  = marino_opt('marino_product_details_title_position');
                                $postTitlePos = false;
                                if( class_exists( 'ReduxFramework' ) ){
                                    if( $posttitle_position && $posttitle_position != 'header' ){
                                        $postTitlePos = true;
                                    }
                                }else{
                                    $postTitlePos = false;
                                }
                            }

                            if( $postTitlePos != true ){
                                echo marino_heading_tag(
                                    array(
                                        "tag"   => esc_attr( $marino_page_title_tag ),
                                        "text"  => wp_kses( get_the_title( ), $allowhtml ),
                                        'class' => 'breadcumb-title'
                                    )
                                );
                            } else {
                                if( class_exists( 'ReduxFramework' ) ){
                                    $marino_post_details_custom_title  = marino_opt('marino_post_details_custom_title');
                                }else{
                                    $marino_post_details_custom_title = __( 'Blog Details','marino' );
                                }

                                if( !empty( $marino_post_details_custom_title ) ) {
                                    echo marino_heading_tag(
                                        array(
                                            "tag"   => esc_attr( $marino_page_title_tag ),
                                            "text"  => wp_kses( $marino_post_details_custom_title, $allowhtml ),
                                            'class' => 'breadcumb-title'
                                        )
                                    );
                                }
                            }
                        }
                    }
                    
                echo '</div>';
            echo '</div>';
        echo '</div>';
        echo '<!-- End of Page title -->';
        if( class_exists('ReduxFramework') ) {
            $marino_breadcrumb_switcher = marino_opt( 'marino_enable_breadcrumb' );
        } else {
            $marino_breadcrumb_switcher = '1';
        }
        if( $marino_breadcrumb_switcher == '1' ) {
            marino_breadcrumbs(
                array(
                    'breadcrumbs_classes' => 'nav',
                )
            );
        }
    }