<?php
/**
 * @Packge     : Marino
 * @Version    : 1.0
 * @Author     : Vecurosoft
 * @Author URI : https://www.vecurosoft.com/
 *
 */

    // Block direct access
    if( ! defined( 'ABSPATH' ) ){
        exit();
    }

    marino_setPostViews( get_the_ID() );

    ?>
    <div <?php post_class(); ?> >
    <?php
        if( class_exists('ReduxFramework') ) {
            $marino_post_details_title_position = marino_opt('marino_post_details_title_position');
        } else {
            $marino_post_details_title_position = 'header';
        }

        $allowhtml = array(
            'p'         => array(
                'class'     => array()
            ),
            'span'      => array(),
            'a'         => array(
                'href'      => array(),
                'title'     => array(),
                'class'     => array(),
            ),
            'br'        => array(),
            'em'        => array(),
            'strong'    => array(),
            'b'         => array(),
        );
        
        // Blog Post Thumbnail
        do_action( 'marino_blog_post_thumb' );

        echo '<div class="blog-content">';
            // Blog Post Meta
            do_action( 'marino_blog_post_meta' );

            if( $marino_post_details_title_position != 'header' ) {
                echo '<h2 class="blog-title h1">'.wp_kses( get_the_title(), $allowhtml ).'</h2>';
            }
            
            // Blog COntent
            the_content();
            // Link Pages
            marino_link_pages();

        echo '</div>';


        $marino_post_tag = get_the_tags();

        if( class_exists('ReduxFramework') ) {
            $marino_post_details_share_options = marino_opt('marino_post_details_share_options');
        } else {
            $marino_post_details_share_options = false;
        }

        if( ! empty( $marino_post_tag ) || ( function_exists( 'marino_social_sharing_buttons' ) && $marino_post_details_share_options ) ){
            echo '<!-- Share Links Area -->';
            echo '<div class="share-links clearfix">';
                echo '<div class="row justify-content-between">';
                    if( is_array( $marino_post_tag ) && ! empty( $marino_post_tag ) ){
                        echo '<div class="col-xl-auto">';
                            if( count( $marino_post_tag ) > 1 ){
                                $tag_text = __( 'Tags:', 'marino' );
                            }else{
                                $tag_text = __( 'Tag:', 'marino' );
                            }
                            echo '<span class="share-links-title">'.$tag_text.'</span>';
                            echo '<div class="tagcloud">';
                                foreach( $marino_post_tag as $tags ){
                                    echo '<a href="'.esc_url( get_tag_link( $tags->term_id ) ).'">'.esc_html( $tags->name ).'</a>';
                                }
                            echo '</div>';
                        echo '</div>';
                    }
                    /**
                    *
                    * Hook for Blog Details Share Options
                    *
                    * Hook marino_blog_details_share_options
                    *
                    * @Hooked marino_blog_details_share_options_cb 10
                    *
                    */
                    do_action( 'marino_blog_details_share_options' );

                    echo '<!-- Share Links Area end -->';
                echo '</div>';
            echo '</div>';
        }
    echo '</div>';

    /**
    *
    * Hook for Blog Details Post Navigation Options
    *
    * Hook marino_blog_details_post_navigation
    *
    * @Hooked marino_blog_details_post_navigation_cb 10
    *
    */
    do_action( 'marino_blog_details_post_navigation' );

    /**
    *
    * Hook for Blog Details Author Bio
    *
    * Hook marino_blog_details_author_bio
    *
    * @Hooked marino_blog_details_author_bio_cb 10
    *
    */
    do_action( 'marino_blog_details_author_bio' );

    /**
    *
    * Hook for Blog Details Related Post
    *
    * Hook marino_blog_details_related_post
    *
    * @Hooked marino_blog_details_related_post_cb 10
    *
    */
    do_action( 'marino_blog_details_related_post' );

    /**
    *
    * Hook for Blog Details Comments
    *
    * Hook marino_blog_details_comments
    *
    * @Hooked marino_blog_details_comments_cb 10
    *
    */
    do_action( 'marino_blog_details_comments' );