<?php
// Block direct access
if (!defined('ABSPATH')) {
    exit();
}
/**
 * @Packge     : Marino
 * @Version    : 1.0
 * @Author     : Vecurosoft
 * @Author URI : https://www.vecurosoft.com/
 *
 */

// marino shop main content hook functions
if (!function_exists('marino_shop_main_content_cb')) {
    function marino_shop_main_content_cb() {

        if (is_shop() || is_product_category() || is_product_tag()) {
            echo '<section class="vs-shop-wrapper position-relative space">';
            if (class_exists('ReduxFramework')) {
                $marino_woo_product_col = marino_opt('marino_woo_product_col');
                if ($marino_woo_product_col == '2') {
                    echo '<div class="container">';
                } elseif ($marino_woo_product_col == '3') {
                    echo '<div class="container">';
                } elseif ($marino_woo_product_col == '4') {
                    echo '<div class="container">';
                } elseif ($marino_woo_product_col == '5') {
                    echo '<div class="marino-container">';
                } elseif ($marino_woo_product_col == '6') {
                    echo '<div class="marino-container">';
                }
            } else {
                echo '<div class="container">';
            }
        } else {
            echo '<section class="vs-shop-wrapper shop-details space-top space-extra-bottom">';
            echo '<div class="container">';
        }
        echo '<div class="row gutters-40">';
    }
}

// marino shop main content hook function
if (!function_exists('marino_shop_main_content_end_cb')) {
    function marino_shop_main_content_end_cb() {
        echo '</div>';
        echo '</div>';
        echo '</section>';
    }
}

// shop column start hook function
if (!function_exists('marino_shop_col_start_cb')) {
    function marino_shop_col_start_cb() {
        if (class_exists('ReduxFramework')) {
            if (class_exists('woocommerce') && is_shop()) {
                $marino_woo_shoppage_sidebar = marino_opt('marino_woo_shoppage_sidebar');
                if ($marino_woo_shoppage_sidebar == '2' && is_active_sidebar('marino-woo-sidebar')) {
                    echo '<div class="col-lg-8 order-last">';
                } elseif ($marino_woo_shoppage_sidebar == '3' && is_active_sidebar('marino-woo-sidebar')) {
                    echo '<div class="col-lg-8">';
                } else {
                    echo '<div class="col-lg-12">';
                } 
            } else {
                echo '<div class="col-lg-12">';
            }
        } else {
            if (class_exists('woocommerce') && is_shop()) {
                if (is_active_sidebar('marino-woo-sidebar')) {
                    echo '<div class="col-lg-8">';
                } else {
                    echo '<div class="col-lg-12">';
                }
            } else {
                echo '<div class="col-lg-12">';
            }
        }
    }
}

// shop column end hook function
if (!function_exists('marino_shop_col_end_cb')) {
    function marino_shop_col_end_cb() {
        echo '</div>';
    }
}

// marino woocommerce pagination hook function
if (!function_exists('marino_woocommerce_pagination')) {
    function marino_woocommerce_pagination() {
        if (!empty(marino_pagination())) {
            echo '<div class="row">';
            echo '<div class="col-12">';
            echo '<div class="pagination-wrapper pagination-layout1 list-style-none pt-lg-30">';
            echo '<ul>';
            $prev     = '<i class="fas fa-angle-left"></i>';
            $next     = '<i class="fas fa-angle-right"></i>';
            // previous
            if (get_previous_posts_link()) {
                echo '<li>';
                previous_posts_link($prev);
                echo '</li>';
            }
            echo marino_pagination();
            // next
            if (get_next_posts_link()) {
                echo '<li>';
                next_posts_link($next);
                echo '</li>';
            }
            echo '</ul>';
            echo '</div>';
            echo '</div>';
            echo '</div>';
        }
    }
}
// woocommerce filter wrapper hook function
if (!function_exists('marino_woocommerce_filter_wrapper')) {
    function marino_woocommerce_filter_wrapper() {
        echo '<div class="vs-sort-bar row justify-content-center justify-content-sm-between align-items-center pb-4 mb-1 ">';
        echo '<div class="col-auto mb-3 mb-sm-0">';
        echo '<div class="nav" role="tablist">';
        echo '<a href="#" class="icon-btn style3 active me-2" id="tab-shop-grid" data-bs-toggle="tab" data-bs-target="#tab-grid" role="tab" aria-controls="tab-grid" aria-selected="true"><i class="fas fa-th"></i></a>';
        echo '<a href="#" class="icon-btn style3" id="tab-shop-list" data-bs-toggle="tab" data-bs-target="#tab-list" role="tab" aria-controls="tab-grid" aria-selected="false"><i class="far fa-bars"></i></a>';
        echo '</div>';
        echo '</div>';
        echo '<div class="col d-none d-md-block">';
        echo '<div class="border-top"></div>';
        echo '</div>';
        echo '<div class="col-sm-9 col-md-auto">';
        echo '<div class="row justify-content-center justify-content-sm-end">';
        echo '<div class="col-auto d-flex align-items-center mb-3 mb-sm-0">';
        echo '<label class="text-body2">' . esc_html__('Sort By', 'marino') . '</label>';
        echo woocommerce_catalog_ordering();
        echo '</div>';
        echo '<div class="col-auto d-flex align-items-center">';
        echo '<label class="text-body2">' . woocommerce_result_count() . '</label>';
        echo '</div>';
        echo '</div>';
        echo '</div>';
        echo '</div>';
    }
}

// woocommerce tab content wrapper start hook function
if (!function_exists('marino_woocommerce_tab_content_wrapper_start')) {
    function marino_woocommerce_tab_content_wrapper_start() {
        echo '<!-- Tab Content -->';
        echo '<div class="tab-content" id="nav-tabContent">';
    }
}

// woocommerce tab content wrapper start hook function
if (!function_exists('marino_woocommerce_tab_content_wrapper_end')) {
    function marino_woocommerce_tab_content_wrapper_end() {
        echo '</div>';
        echo '<!-- End Tab Content -->';
    }
}
// marino grid tab content hook function
if (!function_exists('marino_grid_tab_content_cb')) {
    function marino_grid_tab_content_cb() {
        echo '<!-- Grid -->';
        echo '<div class="tab-pane fade show active" id="tab-grid" role="tabpanel" aria-labelledby="tab-shop-grid">';
        woocommerce_product_loop_start();
        if (class_exists('ReduxFramework')) {
            $marino_woo_product_col = marino_opt('marino_woo_product_col');
            if ($marino_woo_product_col == '2') {
                $marino_woo_product_col_val = 'col-lg-6 col-sm-6';
            } elseif ($marino_woo_product_col == '3') {
                $marino_woo_product_col_val = 'col-lg-4 col-sm-6';
            } elseif ($marino_woo_product_col == '4') {
                $marino_woo_product_col_val = 'col-lg-3 col-sm-6';
            } elseif ($marino_woo_product_col == '5') {
                $marino_woo_product_col_val = 'col-xl col-lg-4 col-sm-6';
            } elseif ($marino_woo_product_col == '6') {
                $marino_woo_product_col_val = 'col-lg-2 col-sm-6';
            }
        } else {
            $marino_woo_product_col_val = 'col-lg-4 col-sm-6';
        }

        if (wc_get_loop_prop('total')) {
            while (have_posts()) {
                the_post();

                echo '<div class="' . esc_attr($marino_woo_product_col_val) . '">';
                /**
                 * Hook: woocommerce_shop_loop.
                 */
                do_action('woocommerce_shop_loop');

                wc_get_template_part('content', 'product');

                echo '</div>';
            }
            wp_reset_postdata();
        }

        woocommerce_product_loop_end();
        echo '</div>';
        echo '<!-- End Grid -->';
    }
}

// marino list tab content hook function
if (!function_exists('marino_list_tab_content_cb')) {
    function marino_list_tab_content_cb() {
        echo '<!-- List -->';
        echo '<div class="tab-pane fade" id="tab-list" role="tabpanel" aria-labelledby="tab-shop-list">';
        woocommerce_product_loop_start();

        if (wc_get_loop_prop('total')) {
            while (have_posts()) {
                the_post();
                echo '<div class="col-sm-6 col-lg-6 col-xl-4">';
                /**
                 * Hook: woocommerce_shop_loop.
                 */
                do_action('woocommerce_shop_loop');

                wc_get_template_part('content-horizontal', 'product');
                echo '</div>';
            }
            wp_reset_postdata();
        }

        woocommerce_product_loop_end();
        echo '</div>';
        echo '<!-- End List -->';
    }
}

// marino woocommerce get sidebar hook function
if (!function_exists('marino_woocommerce_get_sidebar')) {
    function marino_woocommerce_get_sidebar() {
        if (class_exists('ReduxFramework')) {
            $marino_woo_shoppage_sidebar = marino_opt('marino_woo_shoppage_sidebar');
        } else {
            if (is_active_sidebar('marino-woo-sidebar')) {
                $marino_woo_shoppage_sidebar = '2';
            } else {
                $marino_woo_shoppage_sidebar = '1';
            }
        }

        if (is_shop()) {
            if ($marino_woo_shoppage_sidebar != '1') {
                get_sidebar('shop');
            }
        }
    }
}

// marino loop product thumbnail hook function
if (!function_exists('marino_loop_product_thumbnail')) {
    function marino_loop_product_thumbnail() {
        global $product;


        if (($product->is_on_sale() && $product->get_type() == 'simple') || $product->is_featured() || !$product->is_in_stock()) {
            echo '<div class="sale-wrapper">';
            if ($product->is_on_sale() && $product->get_type() == 'simple') {
                echo '<div class="onsale product-tag1">' . esc_html__('Sale', 'marino') . '</div>';
            }
            if ($product->is_featured()) {
                echo '<div class="featured woocommerce-badge product-tag1">' . esc_html__('Hot', 'marino') . '</div>';
            }
            if (!$product->is_in_stock()) {
                echo '<div class="outofstock woocommerce-badge product-tag1">' . esc_html__('Stock Out', 'marino') . '</div>';
            }
            echo '</div>';
        }
        echo '<div class="product-img">';
        if (has_post_thumbnail()) {
            echo '<a href="' . esc_url(get_permalink()) . '">';
            echo '<img class="w-100" src="' . esc_url(get_the_post_thumbnail_url()) . '" alt="' . esc_attr(marino_img_default_alt(get_the_post_thumbnail_url())) . '" >';
            echo '</a>';
        }
        echo '<div class="actions-btn">';
        // Cart Button
        woocommerce_template_loop_add_to_cart();
        // Quick View Button
        if (class_exists('WPCleverWoosq')) {
            echo do_shortcode('[woosq]');
        }
        // Wishlist Button
        if (class_exists('TInvWL_Admin_TInvWL')) {
            echo do_shortcode('[ti_wishlists_addtowishlist]');
        }
        // Compare Button
        if (class_exists('WPCleverWoosc')) {
            echo do_shortcode('[woosc]');
        }
        echo '</div>';
        echo '</div>';
    }
}

// marino loop product thumbnail hook function
if (!function_exists('marino_loop_product_two_thumbnail')) {
    function marino_loop_product_two_thumbnail() {
        global $product;
        echo '<div class="product-img">';
        echo '<div class="clipped">';
        if (has_post_thumbnail()) {
            echo '<a href="' . esc_url(get_permalink()) . '">';
            echo '<img class="w-100" src="' . esc_url(get_the_post_thumbnail_url()) . '" alt="' . esc_attr(marino_img_default_alt(get_the_post_thumbnail_url())) . '" >';
            echo '</a>';
        }
        echo '</div>';
        echo '</div>';
    }
}

// shop loop product summary
if (!function_exists('marino_loop_product_summary')) {
    function marino_loop_product_summary() {
        global $product;
        echo '<div class="product-content">';
        // Product Rating
        woocommerce_template_loop_rating();
        // Product Title
        echo '<h4 class="product-title h5"><a href="' . esc_url(get_permalink()) . '">' . esc_html(get_the_title()) . '</a></h4>';
        // Product Price
        echo woocommerce_template_loop_price();
        echo '</div>';
    }
}

// shop loop horizontal product summary
if (!function_exists('marino_horizontal_loop_product_summary')) {
    function marino_horizontal_loop_product_summary() {
        global $product;
        echo '<div class="product-content d-xl-flex align-items-center">';
        echo '<div>';
        // Product Title
        echo '<h4 class="product-title h5 mb-1"><a href="' . esc_url(get_permalink()) . '">' . esc_html(get_the_title()) . '</a></h4>';
        // Product Price
        echo woocommerce_template_loop_price();
        // Product Rating
        woocommerce_template_loop_rating();

        echo '</div>';
        echo '</div>';
    }
}
// shop loop product two summary
if (!function_exists('marino_product_two_loop_product_summary')) {
    function marino_product_two_loop_product_summary() {
        global $product;
        echo '<div class="product-body">';
        echo '<div class="product-img2">';
        echo '<img src="'. esc_url( get_template_directory_uri(). '/assets/img/shop-bg-shep.svg').'"alt="shop">';
        echo ' </div>';
        echo '<div class="product-content">';
        echo woocommerce_template_loop_price();
        echo '<h3 class="product-title"><a class="text-inherit" href="' . esc_url(get_permalink()) . '">' . esc_html(get_the_title()) . '</a></h3>';
        echo '<div class="product-rating">';
        woocommerce_template_loop_rating();
        echo '</div>';
        echo '</div>';
        echo '</div>';
    }
}

// single product price rating hook function
if (!function_exists('marino_woocommerce_single_product_price_rating')) {
    function marino_woocommerce_single_product_price_rating() {
        global $product;
        // Product Rating
        woocommerce_template_loop_rating();
        echo '<!-- Product Price -->';

        marino_woocommerce_single_product_title();

        woocommerce_template_single_price();
        echo '<!-- End Product Price -->';
    }
}

// single product title hook function
if (!function_exists('marino_woocommerce_single_product_title')) {
    function marino_woocommerce_single_product_title() {
        if (class_exists('ReduxFramework')) {
            $producttitle_position = marino_opt('marino_product_details_title_position');
        } else {
            $producttitle_position = 'header';
        }

        if ($producttitle_position != 'header') {
            echo '<!-- Product Title -->';
            echo '<h3 class="product-title mb-1">' . esc_html(get_the_title()) . '</h3>';
            echo '<!-- End Product Title -->';
        }
    }
}

// single product title hook function
if (!function_exists('marino_woocommerce_quickview_single_product_title')) {
    function marino_woocommerce_quickview_single_product_title() {
        echo '<!-- Product Title -->';
        echo '<h3 class="product-title mb-1">' . esc_html(get_the_title()) . '</h3>';
        echo '<!-- End Product Title -->';
    }
}

// single product excerpt hook function
if (!function_exists('marino_woocommerce_single_product_excerpt')) {
    function marino_woocommerce_single_product_excerpt() {
        echo '<!-- Product Description -->';
        woocommerce_template_single_excerpt();
        echo '<!-- End Product Description -->';
    }
}

// single product availability hook function
if (!function_exists('marino_woocommerce_single_product_availability')) {
    function marino_woocommerce_single_product_availability() {
        global $product;
        $availability = $product->get_availability();

        if (class_exists('ReduxFramework')) {
            $marino_stock_quantity = marino_opt('marino_woo_stock_quantity_show_hide');
        } else {
            $marino_stock_quantity = 1;
        }

        if ($marino_stock_quantity) {
            if ($availability['class'] != 'out-of-stock') {
                echo '<!-- Product Availability -->';
                echo '<div class="mt-2 link-inherit fs-xs">';
                echo '<p>';
                echo '<strong class="me-3 font-theme">' . esc_html__('Availability:', 'marino') . '</strong>';
                if ($product->get_stock_quantity()) {
                    echo '<span class="stock in-stock"><i class="far fa-check-square me-2"></i>' . esc_html($product->get_stock_quantity()) . '</span>';
                } else {
                    echo '<span class="stock in-stock"><i class="far fa-check-square me-2"></i>' . esc_html__('In Stock', 'marino') . '</span>';
                }
                echo '</p>';
                echo '</div>';
                echo '<!--End Product Availability -->';
            } else {
                echo '<!-- Product Availability -->';
                echo '<div class="mt-2 link-inherit fs-xs">';
                echo '<p>';
                echo '<strong class="me-3 font-theme">' . esc_html__('Availability:', 'marino') . '</strong>';
                echo '<span class="stock out-of-stock"><i class="far fa-check-square me-2"></i>' . esc_html__('Out Of Stock', 'marino') . '</span>';
                echo '</p>';
                echo '</div>';
                echo '<!--End Product Availability -->';
            }
        }
    }
}

// single product add to cart fuunction
if (!function_exists('marino_woocommerce_single_add_to_cart_button')) {
    function marino_woocommerce_single_add_to_cart_button() {
        woocommerce_template_single_add_to_cart();
    }
}

// single product ,eta hook function
if (!function_exists('marino_woocommerce_single_meta')) {
    function marino_woocommerce_single_meta() {
        global $product;
        echo '<div class="product_meta">';
        if (!empty($product->get_sku())) {
            echo '<span class="sku_wrapper">' . esc_html__('SKU:', 'marino') . '<span class="sku">' . $product->get_sku() . '</span></span>';
        }
        echo wc_get_product_category_list($product->get_id(), ', ', '<span class="posted_in">' . _n('Category:', 'Categories:', count($product->get_category_ids()), 'marino') . ' ', '</span>');
        echo '</div>';
    }
}

// single produt sidebar hook function
if (!function_exists('marino_woocommerce_single_product_sidebar_cb')) {
    function marino_woocommerce_single_product_sidebar_cb() {
        if (class_exists('ReduxFramework')) {
            $marino_woo_singlepage_sidebar = marino_opt('marino_woo_singlepage_sidebar');
            if (($marino_woo_singlepage_sidebar == '2' || $marino_woo_singlepage_sidebar == '3') && is_active_sidebar('marino-woo-sidebar')) {
                get_sidebar('shop');
            }
        } else {
            if (is_active_sidebar('marino-woo-sidebar')) {
                get_sidebar('shop');
            }
        }
    }
}

// reviewer meta hook function
if (!function_exists('marino_woocommerce_reviewer_meta')) {
    function marino_woocommerce_reviewer_meta($comment) {
        $verified = wc_review_is_from_verified_owner($comment->comment_ID);
        if ('0' === $comment->comment_approved) { ?>
            <em class="woocommerce-review__awaiting-approval">
                <?php esc_html_e('Your review is awaiting approval', 'marino'); ?>
            </em>

        <?php } else { ?>
            <div class="comment-author">
                <h4 class="name h5"><?php echo ucwords(get_comment_author()); ?> </h4>
                <span class="commented-on"><time class="woocommerce-review__published-date" datetime="<?php echo esc_attr(get_comment_date('c')); ?>"> <?php printf(esc_html__('%1$s at %2$s', 'marino'), get_comment_date(wc_date_format()),  get_comment_time()); ?> </time></span>
            </div>
            <?php
            if ('yes' === get_option('woocommerce_review_rating_verification_label') && $verified) {
                echo '<em class="woocommerce-review__verified verified">(' . esc_attr__('verified owner', 'marino') . ')</em> ';
            }

            ?>
<?php
        }

        woocommerce_review_display_rating();
    }
}

// woocommerce proceed to checkout hook function
if (!function_exists('marino_woocommerce_button_proceed_to_checkout')) {
    function marino_woocommerce_button_proceed_to_checkout() {
        echo '<a href="' . esc_url(wc_get_checkout_url()) . '" class="checkout-button button alt wc-forward vs-btn  shadow-none">';
        esc_html_e('Proceed to checkout', 'marino');
        echo '</a>';
    }
}

// marino woocommerce cross sell display hook function
if (!function_exists('marino_woocommerce_cross_sell_display')) {
    function marino_woocommerce_cross_sell_display() {
        woocommerce_cross_sell_display();
    }
}

// marino minicart view cart button hook function
if (!function_exists('marino_minicart_view_cart_button')) {
    function marino_minicart_view_cart_button() {
        echo '<a href="' . esc_url(wc_get_cart_url()) . '" class="button checkout wc-forward vs-btn style1">' . esc_html__('View cart', 'marino') . '</a>';
    }
}

// marino minicart checkout button hook function
if (!function_exists('marino_minicart_checkout_button')) {
    function marino_minicart_checkout_button() {
        echo '<a href="' . esc_url(wc_get_checkout_url()) . '" class="button wc-forward vs-btn style1">' . esc_html__('Checkout', 'marino') . '</a>';
    }
}

// marino woocommerce before checkout form
if (!function_exists('marino_woocommerce_before_checkout_form')) {
    function marino_woocommerce_before_checkout_form() {
        echo '<div class="row">';
        if (!is_user_logged_in() && 'yes' === get_option('woocommerce_enable_checkout_login_reminder')) {
            echo '<div class="col-lg-12">';
            woocommerce_checkout_login_form();
            echo '</div>';
        }

        echo '<div class="col-lg-12">';
        woocommerce_checkout_coupon_form();
        echo '</div>';
        echo '</div>';
    }
}

// add to cart button
function woocommerce_template_loop_add_to_cart($args = array()) {
    global $product;

    if ($product) {
        $defaults = array(
            'quantity'   => 1,
            'class'      => implode(
                ' ',
                array_filter(
                    array(
                        'cart-button',
                        'product_type_' . $product->get_type(),
                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                        $product->supports('ajax_add_to_cart') && $product->is_purchasable() && $product->is_in_stock() ? 'ajax_add_to_cart' : '',
                    )
                )
            ),
            'attributes' => array(
                'data-product_id'  => $product->get_id(),
                'data-product_sku' => $product->get_sku(),
                'aria-label'       => $product->add_to_cart_description(),
                'rel'              => 'nofollow',
            ),
        );

        $args = wp_parse_args($args, $defaults);

        if (isset($args['attributes']['aria-label'])) {
            $args['attributes']['aria-label'] = wp_strip_all_tags($args['attributes']['aria-label']);
        }
    }

    echo sprintf(
        '<a href="%s" data-quantity="%s" class="%s" %s>%s</a>',
        esc_url($product->add_to_cart_url()),
        esc_attr(isset($args['quantity']) ? $args['quantity'] : 1),
        esc_attr(isset($args['class']) ? $args['class'] : 'cart-button'),
        isset($args['attributes']) ? wc_implode_html_attributes($args['attributes']) : '',
        '<i class="fal fa-cart-plus"></i>'
    );
}

function woocommerce_template_loop_add_to_cart_class_change($args = array()) {
    global $product;

    if ($product) {
        $defaults = array(
            'quantity'   => 1,
            'class'      => implode(
                ' ',
                array_filter(
                    array(
                        'product-cart-btn',
                        'product_type_' . $product->get_type(),
                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                        $product->supports('ajax_add_to_cart') && $product->is_purchasable() && $product->is_in_stock() ? 'ajax_add_to_cart' : '',
                    )
                )
            ),
            'attributes' => array(
                'data-product_id'  => $product->get_id(),
                'data-product_sku' => $product->get_sku(),
                'aria-label'       => $product->add_to_cart_description(),
                'rel'              => 'nofollow',
            ),
        );

        $args = wp_parse_args($args, $defaults);

        if (isset($args['attributes']['aria-label'])) {
            $args['attributes']['aria-label'] = wp_strip_all_tags($args['attributes']['aria-label']);
        }
    }

    echo sprintf(
        '<a href="%s" data-quantity="%s" class="%s" %s>%s</a>',
        esc_url($product->add_to_cart_url()),
        esc_attr(isset($args['quantity']) ? $args['quantity'] : 1),
        esc_attr(isset($args['class']) ? $args['class'] : 'product-cart-btn'),
        isset($args['attributes']) ? wc_implode_html_attributes($args['attributes']) : '',
        '<i class="fal fa-cart-plus"></i>'
    );
}

// add to cart button two
function woocommerce_template_loop_add_to_cart_two($args = array()) {
    global $product;

    if ($product) {
        $defaults = array(
            'quantity'   => 1,
            'class'      => implode(
                ' ',
                array_filter(
                    array(
                        'vs-btn style4 cart-btn',
                        'product_type_' . $product->get_type(),
                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                        $product->supports('ajax_add_to_cart') && $product->is_purchasable() && $product->is_in_stock() ? 'ajax_add_to_cart' : '',
                    )
                )
            ),
            'attributes' => array(
                'data-product_id'  => $product->get_id(),
                'data-product_sku' => $product->get_sku(),
                'aria-label'       => $product->add_to_cart_description(),
                'rel'              => 'nofollow',
            ),
        );

        $args = wp_parse_args($args, $defaults);

        if (isset($args['attributes']['aria-label'])) {
            $args['attributes']['aria-label'] = wp_strip_all_tags($args['attributes']['aria-label']);
        }
    }

    echo sprintf(
        '<a href="%s" data-quantity="%s" class="%s" %s>%s</a>',
        esc_url($product->add_to_cart_url()),
        esc_attr(isset($args['quantity']) ? $args['quantity'] : 1),
        esc_attr(isset($args['class']) ? $args['class'] : 'vs-btn style4 cart-btn'),
        isset($args['attributes']) ? wc_implode_html_attributes($args['attributes']) : '',
        '<i class="fal fa-cart-plus"></i> Add To Cart'
    );
}

// add to cart button Three
function woocommerce_template_loop_add_to_cart_three($args = array()) {
    global $product;

    if ($product) {
        $defaults = array(
            'quantity'   => 1,
            'class'      => implode(
                ' ',
                array_filter(
                    array(
                        'product-cart-btn',
                        'product_type_' . $product->get_type(),
                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                        $product->supports('ajax_add_to_cart') && $product->is_purchasable() && $product->is_in_stock() ? 'ajax_add_to_cart' : '',
                    )
                )
            ),
            'attributes' => array(
                'data-product_id'  => $product->get_id(),
                'data-product_sku' => $product->get_sku(),
                'aria-label'       => $product->add_to_cart_description(),
                'rel'              => 'nofollow',
            ),
        );

        $args = wp_parse_args($args, $defaults);

        if (isset($args['attributes']['aria-label'])) {
            $args['attributes']['aria-label'] = wp_strip_all_tags($args['attributes']['aria-label']);
        }
    }

    echo sprintf(
        '<a href="%s" data-quantity="%s" class="%s" %s>%s</a>',
        esc_url($product->add_to_cart_url()),
        esc_attr(isset($args['quantity']) ? $args['quantity'] : 1),
        esc_attr(isset($args['class']) ? $args['class'] : 'product-cart-btn'),
        isset($args['attributes']) ? wc_implode_html_attributes($args['attributes']) : '',
        'Add to Basket <i class="fal fa-cart-plus"></i> '
    );
}

// add to cart button Four
function woocommerce_template_loop_add_to_cart_four($args = array()) {
    global $product;

    if ($product) {
        $defaults = array(
            'quantity'   => 1,
            'class'      => implode(
                ' ',
                array_filter(
                    array(
                        'product-cart-btn',
                        'product_type_' . $product->get_type(),
                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                        $product->supports('ajax_add_to_cart') && $product->is_purchasable() && $product->is_in_stock() ? 'ajax_add_to_cart' : '',
                    )
                )
            ),
            'attributes' => array(
                'data-product_id'  => $product->get_id(),
                'data-product_sku' => $product->get_sku(),
                'aria-label'       => $product->add_to_cart_description(),
                'rel'              => 'nofollow',
            ),
        );

        $args = wp_parse_args($args, $defaults);

        if (isset($args['attributes']['aria-label'])) {
            $args['attributes']['aria-label'] = wp_strip_all_tags($args['attributes']['aria-label']);
        }
    }

    echo sprintf(
        '<a href="%s" data-quantity="%s" class="%s" %s>%s</a>',
        esc_url($product->add_to_cart_url()),
        esc_attr(isset($args['quantity']) ? $args['quantity'] : 1),
        esc_attr(isset($args['class']) ? $args['class'] : 'product-cart-btn'),
        isset($args['attributes']) ? wc_implode_html_attributes($args['attributes']) : '',
        'Add to Cart'
    );
}

// product searchform
add_filter('get_product_search_form', 'marino_custom_product_searchform');
function marino_custom_product_searchform($form) {

    $form = '<form class="search-form" role="search" method="get" action="' . esc_url(home_url('/')) . '">
        <label class="screen-reader-text" for="s">' . __('Search for:', 'marino') . '</label>
        <input type="text" value="' . get_search_query() . '" name="s" id="s" placeholder="' . __('Search', 'marino') . '" />
        <button class="submit-btn" type="submit"><i class="far fa-search"></i></button>
        <input type="hidden" name="post_type" value="product" />
    </form>';

    return $form;
}

// cart empty message
add_action('woocommerce_cart_is_empty', 'marino_wc_empty_cart_message', 10);
function marino_wc_empty_cart_message() {
    echo '<h3 class="cart-empty d-none">' . esc_html__('Your cart is currently empty.', 'marino') . '</h3>';
}
