<?php
/**
 * @Packge     : Marino
 * @Version    : 1.0
 * @Author     : Vecurosoft
 * @Author URI : https://www.vecurosoft.com/
 *
 */


// Block direct access
if( !defined( 'ABSPATH' ) ){
    exit;
}

function marino_widgets_init() {

    if( class_exists('ReduxFramework') ) {
        $marino_sidebar_widget_title_heading_tag = marino_opt('marino_sidebar_widget_title_heading_tag');
    } else {
        $marino_sidebar_widget_title_heading_tag = 'h3';
    }

    //sidebar widgets register
    register_sidebar( array(
        'name'          => esc_html__( 'Blog Sidebar', 'marino' ),
        'id'            => 'marino-blog-sidebar',
        'description'   => esc_html__( 'Add Blog Sidebar Widgets Here.', 'marino' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<'.esc_attr($marino_sidebar_widget_title_heading_tag).' class="widgettitle">',
        'after_title'   => '</'.esc_attr($marino_sidebar_widget_title_heading_tag).'>',
    ) );

    // page sidebar widgets register
    register_sidebar( array(
        'name'          => esc_html__( 'Page Sidebar', 'marino' ),
        'id'            => 'marino-page-sidebar',
        'description'   => esc_html__( 'Add Page Sidebar Widgets Here.', 'marino' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widgettitle">',
        'after_title'   => '</h3>',
    ) );
    // page sidebar widgets register
    register_sidebar( array(
        'name'          => esc_html__( 'Offcanvas Sidebar', 'marino' ),
        'id'            => 'marino-offcanvas-sidebar',
        'description'   => esc_html__( 'Add Offcanvas Sidebar Widgets Here.', 'marino' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widgettitle">',
        'after_title'   => '</h3>',
    ) );
    if( class_exists('woocommerce') ) {
        register_sidebar(
            array(
                'name'          => esc_html__( 'WooCommerce Sidebar', 'marino' ),
                'id'            => 'marino-woo-sidebar',
                'description'   => esc_html__( 'Add widgets here to appear in your woocommerce page sidebar.', 'marino' ),
                'before_widget' => '<div class="widget %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<div class="widgettitle"><h4>',
                'after_title'   => '</h4></div>',
            )
        );
    }

}

add_action( 'widgets_init', 'marino_widgets_init' );