<?php

/**
 * Include and setup custom metaboxes and fields. (make sure you copy this file to outside the CMB2 directory)
 *
 * Be sure to replace all instances of 'yourprefix_' with your project's prefix.
 * http://nacin.com/2010/05/11/in-wordpress-prefix-everything/
 *
 * @category YourThemeOrPlugin
 * @package  Demo_CMB2
 * @license  http://www.opensource.org/licenses/gpl-license.php GPL v2.0 (or later)
 * @link     https://github.com/WebDevStudios/CMB2
 */

 /**
 * Only return default value if we don't have a post ID (in the 'post' query variable)
 *
 * @param  bool  $default On/Off (true/false)
 * @return mixed          Returns true or '', the blank default
 */

add_action( 'cmb2_admin_init', 'marino_register_metabox' );

/**
 * Hook in and add a demo metabox. Can only happen on the 'cmb2_admin_init' or 'cmb2_init' hook.
 */

function marino_register_metabox() {

	$prefix = '_marino_';

	$prefixpage = '_marinopage_';

	$marino_service_meta = new_cmb2_box( array(
		'id'            => $prefixpage . 'service_page_control',
		'title'         => esc_html__( 'Service Page Controller', 'marino' ),
		'object_types'  => array( 'marino_service' ), // Post type
		'closed'        => true
	) );
	$marino_service_meta->add_field( array(
		'name' => esc_html__( 'Write Flaticon Class', 'marino' ),
	   	'desc' => esc_html__( 'Write Flaticon Class For The Icon', 'marino' ),
	   	'id'   => $prefix . 'flat_icon_class',
		'type' => 'text',
    ) );

	$marino_post_meta = new_cmb2_box( array(
		'id'            => $prefixpage . 'blog_post_control',
		'title'         => esc_html__( 'Post Thumb Controller', 'marino' ),
		'object_types'  => array( 'post' ), // Post type
		'closed'        => true
	) );
	$marino_post_meta->add_field( array(
		'name' => esc_html__( 'Post Format Video', 'marino' ),
		'desc' => esc_html__( 'Use This Field When Post Format Video', 'marino' ),
		'id'   => $prefix . 'post_format_video',
        'type' => 'text_url',
    ) );
	$marino_post_meta->add_field( array(
		'name' => esc_html__( 'Post Format Audio', 'marino' ),
		'desc' => esc_html__( 'Use This Field When Post Format Audio', 'marino' ),
		'id'   => $prefix . 'post_format_audio',
        'type' => 'oembed',
    ) );
	$marino_post_meta->add_field( array(
		'name' => esc_html__( 'Post Thumbnail For Slider', 'marino' ),
		'desc' => esc_html__( 'Use This Field When You Want A Slider In Post Thumbnail', 'marino' ),
		'id'   => $prefix . 'post_format_slider',
        'type' => 'file_list',
    ) );

	$marino_page_meta = new_cmb2_box( array(
		'id'            => $prefixpage . 'page_meta_section',
		'title'         => esc_html__( 'Page Meta', 'marino' ),
		'object_types'  => array( 'page' ), // Post type
        'closed'        => true
    ) );

    $marino_page_meta->add_field( array(
		'name' => esc_html__( 'Page Breadcrumb Area', 'marino' ),
		'desc' => esc_html__( 'check to display page breadcrumb area.', 'marino' ),
		'id'   => $prefix . 'page_breadcrumb_area',
        'type' => 'select',
        'default' => '1',
        'options'   => array(
            '1'   => esc_html__('Show','marino'),
            '2'     => esc_html__('Hide','marino'),
        )
    ) );


    $marino_page_meta->add_field( array(
		'name' => esc_html__( 'Page Breadcrumb Settings', 'marino' ),
		'id'   => $prefix . 'page_breadcrumb_settings',
        'type' => 'select',
        'default'   => 'global',
        'options'   => array(
            'global'   => esc_html__( 'Global Settings', 'marino' ),
            'page'     => esc_html__( 'Page Settings', 'marino' ),
        )
	) );

	$marino_page_meta->add_field( array(
	    'name'    => esc_html__( 'Breadcumb Image', 'marino' ),
	    'desc'    => esc_html__( 'Upload an image or enter an URL.', 'marino' ),
	    'id'      => $prefix . 'breadcumb_image',
	    'type'    => 'file',
	    // Optional:
	    'options' => array(
	        'url' => false, // Hide the text input for the url
	    ),
	    'text'    => array(
	        'add_upload_file_text' => __( 'Add File', 'marino' ) // Change upload button text. Default: "Add or Upload File"
	    ),
	    'preview_size' => 'large', // Image size to use when previewing in the admin.
	) );

    $marino_page_meta->add_field( array(
		'name' => esc_html__( 'Page Title', 'marino' ),
		'desc' => esc_html__( 'check to display Page Title.', 'marino' ),
		'id'   => $prefix . 'page_title',
        'type' => 'select',
        'default' => '1',
        'options'   => array(
            '1'   	=> esc_html__( 'Show','marino'),
            '2'     => esc_html__( 'Hide','marino'),
        )
	) );

    $marino_page_meta->add_field( array(
		'name' => esc_html__( 'Page Title Settings', 'marino' ),
		'id'   => $prefix . 'page_title_settings',
        'type' => 'select',
        'options'   => array(
            'default'  => esc_html__('Default Title','marino'),
            'custom'  => esc_html__('Custom Title','marino'),
        ),
        'default'   => 'default'
    ) );

    $marino_page_meta->add_field( array(
		'name' => esc_html__( 'Custom Page Title', 'marino' ),
		'id'   => $prefix . 'custom_page_title',
        'type' => 'text'
    ) );

    $marino_page_meta->add_field( array(
		'name' => esc_html__( 'Breadcrumb', 'marino' ),
		'desc' => esc_html__( 'Select Show to display breadcrumb area', 'marino' ),
		'id'   => $prefix . 'page_breadcrumb_trigger',
        'type' => 'checkbox',
    ) );

    $marino_layout_meta = new_cmb2_box( array(
		'id'            => $prefixpage . 'page_layout_section',
		'title'         => esc_html__( 'Page Layout', 'marino' ),
        'context' 		=> 'side',
        'priority' 		=> 'high',
        'object_types'  => array( 'page' ), // Post type
        'closed'        => true
	) );

	$marino_layout_meta->add_field( array(
		'desc'       => esc_html__( 'Set page layout container,container fluid,fullwidth or both. It\'s work only in template builder page.', 'marino' ),
		'id'         => $prefix . 'custom_page_layout',
		'type'       => 'radio',
        'options' => array(
            '1' => esc_html__( 'Container', 'marino' ),
            '2' => esc_html__( 'Container Fluid', 'marino' ),
            '3' => esc_html__( 'Fullwidth', 'marino' ),
        ),
	) );

}

add_action( 'cmb2_admin_init', 'marino_register_taxonomy_metabox' );
/**
 * Hook in and add a metabox to add fields to taxonomy terms
 */
function marino_register_taxonomy_metabox() {

    $prefix = '_marino_';
	/**
	 * Metabox to add fields to categories and tags
	 */
	$marino_term_meta = new_cmb2_box( array(
		'id'               => $prefix.'term_edit',
		'title'            => esc_html__( 'Category Metabox', 'marino' ),
		'object_types'     => array( 'term' ),
		'taxonomies'       => array( 'category'),
	) );
	$marino_term_meta->add_field( array(
		'name'     => esc_html__( 'Extra Info', 'marino' ),
		'id'       => $prefix.'term_extra_info',
		'type'     => 'title',
		'on_front' => false,
	) );
	$marino_term_meta->add_field( array(
		'name' => esc_html__( 'Category Image', 'marino' ),
		'desc' => esc_html__( 'Set Category Image', 'marino' ),
		'id'   => $prefix.'term_avatar',
        'type' => 'file',
        'text'    => array(
			'add_upload_file_text' => esc_html__('Add Image','marino') // Change upload button text. Default: "Add or Upload File"
		),
	) );
	/**
	 * Metabox to add fields to service
	 */
	$marino_service_meta = new_cmb2_box( array(
		'id'               => $prefix.'service',
		'title'            => esc_html__( 'Service Metabox', 'marino' ),
		'object_types'     => array( 'marino_service' ),
	) );
	$marino_service_meta->add_field( array(
		'name' => esc_html__( 'Service Icon', 'marino' ),
		'desc' => esc_html__( 'Set Service Icon', 'marino' ),
		'id'   => $prefix.'service_icon',
        'type' => 'file',
        'text'    => array(
			'add_upload_file_text' => esc_html__('Add Image','marino') // Change upload button text. Default: "Add or Upload File"
		),
	) );
	/**
	 * Metabox for the user profile screen
	 */
	$marino_user = new_cmb2_box( array(
		'id'               => $prefix.'user_edit',
		'title'            => esc_html__( 'User Profile Metabox', 'marino' ), // Doesn't output for user boxes
		'object_types'     => array( 'user' ), // Tells CMB2 to use user_meta vs post_meta
		'show_names'       => true,
		'new_user_section' => 'add-new-user', // where form will show on new user page. 'add-existing-user' is only other valid option.
	) );
	$marino_user->add_field( array(
		'name'     => esc_html__( 'Social Profile', 'marino' ),
		'id'       => $prefix.'user_extra_info',
		'type'     => 'title',
		'on_front' => false,
	) );

	$group_field_id = $marino_user->add_field( array(
        'id'          => $prefix .'social_profile_group',
        'type'        => 'group',
        'description' => __( 'Social Profile', 'marino' ),
        'options'     => array(
            'group_title'       => __( 'Social Profile {#}', 'marino' ), // since version 1.1.4, {#} gets replaced by row number
            'add_button'        => __( 'Add Another Social Profile', 'marino' ),
            'remove_button'     => __( 'Remove Social Profile', 'marino' ),
            'closed'         => true
        ),
    ) );

    $marino_user->add_group_field( $group_field_id, array(
        'name'        => __( 'Set Icon Class', 'marino' ),
        'id'          => $prefix .'social_profile_icon',
        'name'       => esc_html__( 'Social Profile Icon', 'marino' ),
        'type'        => 'text', // This field type
		'default'  	=> esc_html__( 'fab fa-facebook-f','marino' ),
    ) );

    $marino_user->add_group_field( $group_field_id, array(
        'desc'       => esc_html__( 'Set social profile link.', 'marino' ),
        'id'         => $prefix . 'lawyer_social_profile_link',
        'name'       => esc_html__( 'Social Profile link', 'marino' ),
        'type'       => 'text',
		'default'  	=> esc_html__( 'www.facebook.com','marino' ),
    ) );
	$marino_user->add_field( array(
		'name' => esc_html__( 'Profile Image', 'marino' ),
		'desc' => esc_html__( 'Set Profile Image', 'marino' ),
		'id'   => $prefix.'term_avatar',
        'type' => 'file',
        'text'    => array(
			'add_upload_file_text' => esc_html__('Add Image','marino') // Change upload button text. Default: "Add or Upload File"
		),
	) );
}