<?php
// Block direct access
if( !defined( 'ABSPATH' ) ){
    exit();
}
/**
 * @Packge     : Marino
 * @Version    : 1.0
 * @Author     : Vecurosoft
 * @Author URI : https://www.vecurosoft.com/
 *
 */

// enqueue css
function marino_common_custom_css(){
	wp_enqueue_style( 'marino-color-schemes', get_template_directory_uri().'/assets/css/color.schemes.css' );

    $CustomCssOpt  = marino_opt( 'marino_css_editor' );
	if( $CustomCssOpt ){
		$CustomCssOpt = $CustomCssOpt;
	}else{
		$CustomCssOpt = '';
	}

    $customcss = "";

    if( get_header_image() ){
        $marino_header_bg =  get_header_image();
    }else{
        if( marino_meta( 'page_breadcrumb_settings' ) == 'page' && is_page() ){
            if( ! empty( marino_meta( 'breadcumb_image' ) ) ){
                $marino_header_bg = marino_meta( 'breadcumb_image' );
            }
        }
    }

    if( !empty( $marino_header_bg ) ){
        $customcss .= ".breadcumb-wrapper{
            background-image:url('{$marino_header_bg}')!important;
        }";
    }

	// theme color
	$marinothemecolor  = marino_opt('marino_theme_color');
	$marinosecondcolor = marino_opt('marino_secondary_color');

	if( !empty( $marinothemecolor ) ) {
		$customcss .= ":root {
		  --theme-color: {$marinothemecolor};
		}";
	}

	if( !empty( $marinosecondcolor ) ) {
		$customcss .= ":root {
			--title-color: {$marinosecondcolor};
		}";
	}


	if( !empty( $CustomCssOpt ) ){
		$customcss .= $CustomCssOpt;
	}

    wp_add_inline_style( 'marino-color-schemes', $customcss );
}
add_action( 'wp_enqueue_scripts', 'marino_common_custom_css', 100 );