<?php
/**
 * @Packge     : Marino
 * @Version    : 1.0
 * @Author     : Vecurosoft
 * @Author URI : https://www.vecurosoft.com/
 *
 */

    // Block direct access
    if( ! defined( 'ABSPATH' ) ){
        exit();
    }


    // preloader hook function
    if( ! function_exists( 'marino_preloader_wrap_cb' ) ) {
        function marino_preloader_wrap_cb() {
            $preloader_display              =  marino_opt('marino_display_preloader');

            if( class_exists('ReduxFramework') ){
                if( $preloader_display ){
                    echo '<div class="preloader">';
                        echo '<button class="vs-btn preloaderCls">'.esc_html__( 'Cancel Preloader', 'marino' ).'</button>';
                        echo '<div class="preloader-inner">';
                            echo '<span class="loader"></span>';
                        echo '</div>';
                    echo '</div>';
                }
            }else{
                echo '<div class="preloader">';
                    echo '<button class="vs-btn preloaderCls">'.esc_html__( 'Cancel Preloader', 'marino' ).'</button>';
                    echo '<div class="preloader-inner">';
                        echo '<span class="loader"></span>';
                    echo '</div>';
                echo '</div>';
            }
        }
    }

    // Header Hook function
    if( !function_exists('marino_header_cb') ) {
        function marino_header_cb( ) {
            get_template_part('templates/header');
            get_template_part('templates/header-menu-bottom');
        }
    }

    // back top top hook function
    if( ! function_exists( 'marino_back_to_top_cb' ) ) {
        function marino_back_to_top_cb( ) {
            $backtotop_trigger = marino_opt('marino_display_bcktotop');
            $custom_bcktotop   = marino_opt('marino_custom_bcktotop');
            $custom_bcktotop_icon   = marino_opt('marino_custom_bcktotop_icon');
            if( class_exists( 'ReduxFramework' ) ) {
                if( $backtotop_trigger ) {
                    if( $custom_bcktotop ) {
                        echo '<!-- Back to Top Button -->';
                        echo '<a href="#" class="scrollToTop scroll-btn">';
                            echo '<i class="fa '.esc_attr( $custom_bcktotop_icon ).'"></i>';
                        echo '</a>';
                        echo '<!-- End of Back to Top Button -->';
                    } else {
                        echo '<!-- Back to Top Button -->';
                        echo '<a href="#" class="scrollToTop scroll-btn">';
                            echo '<i class="far fa-arrow-up"></i>';
                        echo '</a>';
                        echo '<!-- End of Back to Top Button -->';
                    }
                }
            }

        }
    }

    // Blog Start Wrapper Function
    if( !function_exists('marino_blog_start_wrap_cb') ) {
        function marino_blog_start_wrap_cb() {
            echo '<section class="vs-blog-wrapper our-blog space-top space-extra-bottom">';
                echo '<div class="container">';
                    if( is_active_sidebar( 'marino-blog-sidebar' ) ){
                        $marino_gutter_class = 'gx-40';
                    }else{
                        $marino_gutter_class = '';
                    }
                    echo '<div class="row '.esc_attr( $marino_gutter_class ).'">';
        }
    }

    // Blog End Wrapper Function
    if( !function_exists('marino_blog_end_wrap_cb') ) {
        function marino_blog_end_wrap_cb() {
                    echo '</div>';
                echo '</div>';
            echo '</section>';
        }
    }

    // Blog Column Start Wrapper Function
    if( !function_exists('marino_blog_col_start_wrap_cb') ) {
        function marino_blog_col_start_wrap_cb() {
            if( class_exists('ReduxFramework') ) {
                $marino_blog_sidebar = marino_opt('marino_blog_sidebar');
                if( $marino_blog_sidebar == '2' && is_active_sidebar('marino-blog-sidebar') ) {
                    echo '<div class="col-lg-8 order-lg-last">';
                } elseif( $marino_blog_sidebar == '3' && is_active_sidebar('marino-blog-sidebar') ) {
                    echo '<div class="col-lg-8">';
                } else {
                    echo '<div class="col-lg-12">';
                }

            } else {
                if( is_active_sidebar('marino-blog-sidebar') ) {
                    echo '<div class="col-lg-8">';
                } else {
                    echo '<div class="col-lg-12">';
                }
            }
        }
    }
    // Blog Column End Wrapper Function
    if( !function_exists('marino_blog_col_end_wrap_cb') ) {
        function marino_blog_col_end_wrap_cb() {
            echo '</div>';
        }
    }

    // Blog Sidebar
    if( !function_exists('marino_blog_sidebar_cb') ) {
        function marino_blog_sidebar_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $marino_blog_sidebar = marino_opt('marino_blog_sidebar');
            } else {
                $marino_blog_sidebar = 2;
            }
            if( $marino_blog_sidebar != 1 && is_active_sidebar('marino-blog-sidebar') ) {
                // Sidebar
                get_sidebar();
            }
        }
    }


    if( !function_exists('marino_blog_details_sidebar_cb') ) {
        function marino_blog_details_sidebar_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $marino_blog_single_sidebar = marino_opt('marino_blog_single_sidebar');
            } else {
                $marino_blog_single_sidebar = 4;
            }
            if( $marino_blog_single_sidebar != 1 ) {
                // Sidebar
                get_sidebar();
            }

        }
    }

    // Blog Pagination Function
    if( !function_exists('marino_blog_pagination_cb') ) {
        function marino_blog_pagination_cb( ) {
            get_template_part('templates/pagination');
        }
    }

    // Blog Content Function
    if( !function_exists('marino_blog_content_cb') ) {
        function marino_blog_content_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $marino_blog_grid = marino_opt('marino_blog_grid');
            } else {
                $marino_blog_grid = '1';
            }

            if( $marino_blog_grid == '1' ) {
                $marino_blog_grid_class = 'col-lg-12';
            } elseif( $marino_blog_grid == '2' ) {
                $marino_blog_grid_class = 'col-sm-6';
            } else {
                $marino_blog_grid_class = 'col-lg-4 col-sm-6';
            }

            echo '<div class="row">';
                if( have_posts() ) {
                    while( have_posts() ) {
                        the_post();
                        echo '<div class="'.esc_attr($marino_blog_grid_class).'">';
                            get_template_part('templates/content',get_post_format());
                        echo '</div>';
                    }
                    wp_reset_postdata();
                } else{
                    get_template_part('templates/content','none');
                }
            echo '</div>';
        }
    }

    // footer content Function
    if( !function_exists('marino_footer_content_cb') ) {
        function marino_footer_content_cb( ) {

            if( class_exists('ReduxFramework') && did_action( 'elementor/loaded' )  ){
                if( is_page() || is_page_template('template-builder.php') ) {
                    $post_id = get_the_ID();

                    // Get the page settings manager
                    $page_settings_manager = \Elementor\Core\Settings\Manager::get_settings_managers( 'page' );

                    // Get the settings model for current post
                    $page_settings_model = $page_settings_manager->get_model( $post_id );

                    // Retrieve the Footer Style
                    $footer_settings = $page_settings_model->get_settings( 'marino_footer_style' );

                    // Footer Local
                    $footer_local = $page_settings_model->get_settings( 'marino_footer_builder_option' );

                    // Footer Enable Disable
                    $footer_enable_disable = $page_settings_model->get_settings( 'marino_footer_choice' );

                    if( $footer_enable_disable == 'yes' ){
                        if( $footer_settings == 'footer_builder' ) {
                            // local options
                            $marino_local_footer = get_post( $footer_local );
                            echo '<footer>';
                            echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $marino_local_footer->ID );
                            echo '</footer>';
                        } else {
                            // global options
                            $marino_footer_builder_trigger = marino_opt('marino_footer_builder_trigger');
                            if( $marino_footer_builder_trigger == 'footer_builder' ) {
                                echo '<footer>';
                                $marino_global_footer_select = get_post( marino_opt( 'marino_footer_builder_select' ) );
                                $footer_post = get_post( $marino_global_footer_select );
                                echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $footer_post->ID );
                                echo '</footer>';
                            } else {
                                // wordpress widgets
                                marino_footer_global_option();
                            }
                        }
                    }
                } else {
                    // global options
                    $marino_footer_builder_trigger = marino_opt('marino_footer_builder_trigger');
                    if( $marino_footer_builder_trigger == 'footer_builder' ) {
                        echo '<footer>';
                        $marino_global_footer_select = get_post( marino_opt( 'marino_footer_builder_select' ) );
                        $footer_post = get_post( $marino_global_footer_select );
                        echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $footer_post->ID );
                        echo '</footer>';
                    } else {
                        // wordpress widgets
                        marino_footer_global_option();
                    }
                }
            } else {
                echo '<div class="footer-copyright">';
                    echo '<div class="container">';
                        echo '<p class="copyright-text">'.sprintf( 'Copyright <i class="fal fa-copyright"></i> %s <a href="%s">%s</a> All Rights Reserved by <a href="%s">%s</a>',date('Y'),esc_url('#'),__( 'Marino.','marino' ),esc_url('#'),__( 'Vecuro', 'marino' ) ).'</p>';
                    echo '</div>';
                echo '</div>';
            }

        }
    }

    // blog details wrapper start hook function
    if( !function_exists('marino_blog_details_wrapper_start_cb') ) {
        function marino_blog_details_wrapper_start_cb( ) {
            echo '<section class="vs-blog-wrapper blog-details space-top space-extra-bottom">';
                echo '<div class="container">';
                    if( is_active_sidebar( 'marino-blog-sidebar' ) ){
                        $marino_gutter_class = 'gx-40';
                    }else{
                        $marino_gutter_class = '';
                    }
                    echo '<div class="row '.esc_attr( $marino_gutter_class ).'">';
        }
    }

    // blog details column wrapper start hook function
    if( !function_exists('marino_blog_details_col_start_cb') ) {
        function marino_blog_details_col_start_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $marino_blog_single_sidebar = marino_opt('marino_blog_single_sidebar');
                if( $marino_blog_single_sidebar == '2' && is_active_sidebar('marino-blog-sidebar') ) {
                    echo '<div class="col-lg-8 order-last">';
                } elseif( $marino_blog_single_sidebar == '3' && is_active_sidebar('marino-blog-sidebar') ) {
                    echo '<div class="col-lg-8">';
                } else {
                    echo '<div class="col-lg-12">';
                }

            } else {
                if( is_active_sidebar('marino-blog-sidebar') ) {
                    echo '<div class="col-lg-8">';
                } else {
                    echo '<div class="col-lg-12">';
                }
            }
        }
    }

    // blog details post meta hook function
    if( !function_exists('marino_blog_post_meta_cb') ) {
        function marino_blog_post_meta_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $marino_display_post_comment   =  marino_opt('marino_display_post_comment');
                $marino_display_author_name    =  marino_opt('marino_display_author_name');
                $marino_display_post_views     =  marino_opt('marino_display_post_views');

            } else {
                $marino_display_post_comment   = '1';
                $marino_display_author_name    =  '1';
                $marino_display_post_views     =  '0';
            }
            echo '<div class="blog-meta">';
                if( $marino_display_author_name ){
                    echo '<span><a href="'.esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ).'"><i class="fas fa-user"></i>'.esc_html( ucfirst( get_the_author_meta('display_name') ) ).'</a></span>';
                }
                if( $marino_display_post_comment ){
                    if( get_comments_number() == 1 ){
                        $comment_text = __( ' Comment', 'marino' );
                    }else{
                        $comment_text = __( ' Comments', 'marino' );
                    }
                    echo '<span class="post-comment"><a href="'.esc_url( get_comments_link( get_the_ID() ) ).'"><i class="fas fa-comment-lines"></i>'.esc_html( get_comments_number() ).''.$comment_text.'</a></span>';
                }
                if( $marino_display_post_views ){
                    echo '<span><i class="fas fa-eye"></i>';
                        echo marino_getPostViews( get_the_ID() ).esc_html__( ' Views', 'marino' );
                    echo '</span>';
                }
            echo '</div>';
            echo '<!-- Blog Meta -->';

        }
    }

    // blog details share options hook function
    if( !function_exists('marino_blog_details_share_options_cb') ) {
        function marino_blog_details_share_options_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $marino_post_details_share_options = marino_opt('marino_post_details_share_options');
            } else {
                $marino_post_details_share_options = false;
            }
            if( function_exists( 'marino_social_sharing_buttons' ) && $marino_post_details_share_options ) {
                echo '<div class="col-xl-auto text-xl-end">';
                    echo '<span class="share-links-title">'.esc_html__( 'Share:', 'marino' ).'</span>';
                    echo '<ul class="social-links">';
                        echo marino_social_sharing_buttons();
                    echo '</ul>';
                    echo '<!-- End Social Share -->';
                echo '</div>';
            }
        }
    }

    // blog details author bio hook function
    if( !function_exists('marino_blog_details_post_navigation_cb') ) {
        function marino_blog_details_post_navigation_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $postnavigation =  marino_opt( 'marino_post_navigation' );
            } else {
                $postnavigation = '1';
            }

            $prevpost = get_previous_post();
            $nextpost = get_next_post();

            if( $postnavigation && ! empty( $prevpost ) || !empty( $nextpost ) ) {
                echo '<div class="post-pagination   ">';
                    echo '<div class="row justify-content-between align-items-center">';
                        if( ! empty( $prevpost ) ) {
                            echo '<div class="col">';
                                echo '<div class="post-pagi-box prev">';
                                    echo '<a href="'.esc_url( get_permalink( $prevpost->ID ) ).'">';
                                        echo get_the_post_thumbnail( $prevpost->ID, 'thumbnail' );
                                        echo '<span class="pagi-title">';
                                            echo esc_html__( 'Previous Post','marino' );
                                        echo '</span>';
                                    echo '</a>';
                                echo '</div>';
                            echo '</div>';
                        }
                        if( ! empty( $nextpost ) ) {
                            echo '<div class="col">';
                                echo '<div class="post-pagi-box next">';
                                    echo '<a href="'.esc_url( get_permalink( $nextpost->ID ) ).'">';
                                        echo '<span class="pagi-title">';
                                            echo esc_html__( 'Next Post','marino' );
                                        echo '</span>';
                                        echo get_the_post_thumbnail( $nextpost->ID, 'thumbnail' );
                                    echo '</a>';
                                echo '</div>';
                            echo '</div>';
                        }
                    echo '</div>';
                echo '</div>';
            }
        }
    }

    // Blog Details Comments hook function
    if( !function_exists('marino_blog_details_comments_cb') ) {
        function marino_blog_details_comments_cb( ) {
            if ( ! comments_open() ) {
                echo '<div class="blog-comment-area">';
                    echo marino_heading_tag( array(
                        "tag"   => "h3",
                        "text"  => esc_html__( 'Comments are closed', 'marino' ),
                        "class" => "inner-title"
                    ) );
                echo '</div>';
            }

            // comment template.
            if ( comments_open() || get_comments_number() ) {
                comments_template();
            }
        }
    }

    // Blog Details Column end hook function
    if( ! function_exists('marino_blog_details_col_end_cb') ) {
        function marino_blog_details_col_end_cb( ) {
            echo '</div>';
        }
    }

    // Blog Details Wrapper end hook function
    if( ! function_exists('marino_blog_details_wrapper_end_cb') ) {
        function marino_blog_details_wrapper_end_cb( ) {
                    echo '</div>';
                echo '</div>';
            echo '</section>';
        }
    }

    // page start wrapper hook function
    if( ! function_exists('marino_page_start_wrap_cb') ) {
        function marino_page_start_wrap_cb( ) {
            if( is_page( 'cart' ) ){
                $section_class = "vs-cart-wrapper space-top space-extra-bottom";
            }elseif( is_page( 'checkout' ) ){
                $section_class = "vs-checkout-wrapper space-top space-extra-bottom";
            }else{
                $section_class = "space-top space-extra-bottom";
            }
            echo '<section class="'.esc_attr( $section_class ).'">';
                echo '<div class="container">';
                    echo '<div class="row">';
        }
    }

    // page wrapper end hook function
    if( !function_exists('marino_page_end_wrap_cb') ) {
        function marino_page_end_wrap_cb( ) {
                    echo '</div>';
                echo '</div>';
            echo '</section>';
        }
    }

    // page column wrapper start hook function
    if( !function_exists('marino_page_col_start_wrap_cb') ) {
        function marino_page_col_start_wrap_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $marino_page_sidebar = marino_opt('marino_page_sidebar');
            }else {
                $marino_page_sidebar = '1';
            }
            if( $marino_page_sidebar == '2' && is_active_sidebar('marino-page-sidebar') ) {
                echo '<div class="col-lg-8 order-last">';
            } elseif( $marino_page_sidebar == '3' && is_active_sidebar('marino-page-sidebar') ) {
                echo '<div class="col-lg-8">';
            } else {
                echo '<div class="col-lg-12">';
            }

        }
    }

    // page column wrapper end hook function
    if( !function_exists('marino_page_col_end_wrap_cb') ) {
        function marino_page_col_end_wrap_cb( ) {
            echo '</div>';
        }
    }

    // page sidebar hook function
    if( !function_exists('marino_page_sidebar_cb') ) {
        function marino_page_sidebar_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $marino_page_sidebar = marino_opt('marino_page_sidebar');
            }else {
                $marino_page_sidebar = '1';
            }

            if( class_exists('ReduxFramework') ) {
                $marino_page_layoutopt = marino_opt('marino_page_layoutopt');
            }else {
                $marino_page_layoutopt = '3';
            }

            if( $marino_page_layoutopt == '1' && $marino_page_sidebar != 1 ) {
                get_sidebar('page');
            } elseif( $marino_page_layoutopt == '2' && $marino_page_sidebar != 1 ) {
                get_sidebar();
            }
        }
    }

    // page content hook function
    if( !function_exists('marino_page_content_cb') ) {
        function marino_page_content_cb( ) {
            if(  class_exists('woocommerce') && ( is_woocommerce() || is_cart() || is_checkout() || is_page('wishlist') || is_account_page() )  ) {
                echo '<div class="woocommerce--content">';
            } else {
                echo '<div class="page--content clearfix">';
            }

                the_content();

                // Link Pages
                marino_link_pages();

            echo '</div>';
            // comment template.
            if ( comments_open() || get_comments_number() ) {
                comments_template();
            }

        }
    }

    if( !function_exists('marino_blog_post_thumb_cb') ) {
        function marino_blog_post_thumb_cb( ) {
            if( get_post_format() ) {
                $format = get_post_format();
            }else{
                $format = 'standard';
            }

            $marino_post_slider_thumbnail = marino_meta( 'post_format_slider' );

            if( class_exists('ReduxFramework') ) {
                $marino_display_post_date      =  marino_opt('marino_display_post_date');

            } else {
                $marino_display_post_date      = '1';
            }

            if( !empty( $marino_post_slider_thumbnail ) ){
                echo '<div class="blog-img-slider slick-carousel blog-img">';
                    foreach( $marino_post_slider_thumbnail as $single_image ){
                        if( ! is_single() ){
                            echo '<a href="'.esc_url( get_permalink() ).'" class="post-thumbnail">';
                        }
                        echo marino_img_tag( array(
                            'url'   => esc_url( $single_image )
                        ) );
                        if( ! is_single() ){
                            echo '</a>';
                        }
                    }
                echo '</div>';
            }elseif( has_post_thumbnail() && $format == 'standard' ) {
                echo '<!-- Post Thumbnail -->';
                echo '<div class="blog-img">';
                    if( ! is_single() ){
                        echo '<a href="'.esc_url( get_permalink() ).'" class="post-thumbnail">';
                    }
                        the_post_thumbnail();
                    if( ! is_single() ){
                        echo '</a>';
                    }
                    if( $marino_display_post_date ){
                        echo '<a href="'.esc_url( marino_blog_date_permalink() ).'" class="blog-date">';
                            echo '<span class="day">'.esc_html( get_the_time( 'd' ) ).'</span>';
                            echo '<span class="month">'.esc_html( get_the_time( 'F' ) ).'</span>';
                        echo '</a>';
                    }
                echo '</div>';
                echo '<!-- End Post Thumbnail -->';
            }elseif( $format == 'video' ){
                if( has_post_thumbnail() && !empty ( marino_meta( 'post_format_video' ) ) ){
                    echo '<div class="blog-video blog-img">';
                        if( ! is_single() ){
                            echo '<a href="'.esc_url( get_permalink() ).'" class="post-thumbnail">';
                        }
                            the_post_thumbnail();
                        if( ! is_single() ){
                            echo '</a>';
                        }
                        echo '<a href="'.esc_url( marino_meta( 'post_format_video' ) ).'" class="play-btn popup-video">';
                          echo '<i class="fas fa-play"></i>';
                        echo '</a>';
                        if( $marino_display_post_date ){
                            echo '<a href="'.esc_url( marino_blog_date_permalink() ).'" class="blog-date">';
                                echo '<span class="day">'.esc_html( get_the_time( 'd' ) ).'</span>';
                                echo '<span class="month">'.esc_html( get_the_time( 'F' ) ).'</span>';
                            echo '</a>';
                        }
                    echo '</div>';
                }elseif( ! has_post_thumbnail() && ! is_single() ){
                    echo '<div class="blog-video">';
                        if( ! is_single() ){
                            echo '<a href="'.esc_url( get_permalink() ).'" class="post-thumbnail">';
                        }
                            echo marino_embedded_media( array( 'video', 'iframe' ) );
                        if( ! is_single() ){
                            echo '</a>';
                        }
                        if( $marino_display_post_date ){
                            echo '<a href="'.esc_url( marino_blog_date_permalink() ).'" class="blog-date">';
                                echo '<span class="day">'.esc_html( get_the_time( 'd' ) ).'</span>';
                                echo '<span class="month">'.esc_html( get_the_time( 'F' ) ).'</span>';
                            echo '</a>';
                        }
                    echo '</div>';
                }
            }elseif( $format == 'audio' ){
                $marino_audio = marino_meta( 'post_format_audio' );
                if( !empty( $marino_audio ) ){
                    echo '<div class="blog-audio blog-img">';
                        echo wp_oembed_get( $marino_audio );
                        if( $marino_display_post_date ){
                            echo '<a href="'.esc_url( marino_blog_date_permalink() ).'" class="blog-date">';
                                echo '<span class="day">'.esc_html( get_the_time( 'd' ) ).'</span>';
                                echo '<span class="month">'.esc_html( get_the_time( 'F' ) ).'</span>';
                            echo '</a>';
                        }
                    echo '</div>';
                }elseif( !is_single() ){
                    echo '<div class="blog-audio blog-img">';
                        echo marino_embedded_media( array( 'audio', 'iframe' ) );
                        if( $marino_display_post_date ){
                            echo '<a href="'.esc_url( marino_blog_date_permalink() ).'" class="blog-date">';
                                echo '<span class="day">'.esc_html( get_the_time( 'd' ) ).'</span>';
                                echo '<span class="month">'.esc_html( get_the_time( 'F' ) ).'</span>';
                            echo '</a>';
                        }
                    echo '</div>';
                }
            }

        }
    }

    if( !function_exists( 'marino_blog_post_content_cb' ) ) {
        function marino_blog_post_content_cb( ) {
            $allowhtml = array(
                'p'         => array(
                    'class'     => array()
                ),
                'span'      => array(),
                'a'         => array(
                    'href'      => array(),
                    'title'     => array()
                ),
                'br'        => array(),
                'em'        => array(),
                'strong'    => array(),
                'b'         => array(),
                'sup'       => array(),
                'sub'       => array(),
            );

            echo '<!-- blog-content -->';
            echo '<div class="blog-content">';
                // Blog Post Meta
                do_action( 'marino_blog_post_meta' );

                if( ! is_single() ){
                    echo '<!-- Post Title -->';
                    echo '<h2 class="blog-title h3"><a href="'.esc_url( get_permalink() ).'">'.wp_kses( get_the_title(), $allowhtml ).'</a></h2>';
                    echo '<!-- End Post Title -->';
                }

                // Excerpt And Read More Button
                do_action( 'marino_blog_postexcerpt_read_content' );

            echo '</div>';
            echo '<!-- End Post Content -->';
        }
    }

    if( ! function_exists( 'marino_blog_postexcerpt_read_content_cb') ) {
        function marino_blog_postexcerpt_read_content_cb( ) {
            if( class_exists( 'ReduxFramework' ) ) {
                $marino_excerpt_length = marino_opt('marino_blog_postExcerpt');
            } else {
                $marino_excerpt_length = '36';
            }
            $allowhtml = array(
                'p'         => array(
                    'class'     => array()
                ),
                'span'      => array(),
                'a'         => array(
                    'href'      => array(),
                    'title'     => array()
                ),
                'br'        => array(),
                'em'        => array(),
                'strong'    => array(),
                'b'         => array(),
            );

            if( class_exists( 'ReduxFramework' ) ) {
                $marino_blog_admin = marino_opt( 'marino_blog_post_author' );
                $marino_blog_readmore_setting_val = marino_opt('marino_blog_readmore_setting');
                if( $marino_blog_readmore_setting_val == 'custom' ) {
                    $marino_blog_readmore_setting = marino_opt('marino_blog_custom_readmore');
                } else {
                    $marino_blog_readmore_setting = __( 'Read More', 'marino' );
                }
            } else {
                $marino_blog_readmore_setting = __( 'Read More', 'marino' );
                $marino_blog_admin = true;
            }
            
            echo '<!-- Post Summary -->';
                echo marino_paragraph_tag( array(
                    "text"  => wp_kses( wp_trim_words( get_the_content(), $marino_excerpt_length, '' ), $allowhtml ),
                    "class" => 'blog-text',
                ) );
            echo '<!-- End Post Summary -->';

            if( $marino_blog_admin || !empty( $marino_blog_readmore_setting ) ){
                if( !empty( $marino_blog_readmore_setting ) ){
                    echo '<!-- Button -->';
                        echo '<a href="'.esc_url( get_permalink() ).'" class="vs-btn style2">'.esc_html( $marino_blog_readmore_setting ).' <i class="far fa-arrow-right"></i></a>';
                    echo '<!-- End Button -->';
                }
            }
        }
    }