<?php
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
    exit( );
}
/**
 * @Packge    : marino
 * @version   : 1.0
 * @Author    : Vecuro
 * @Author URI: https://themeforest.net/user/vecuro_themes
 */

// demo import file
function marino_import_files() {

	$demoImg = '<img src="'. MARINO_DEMO_DIR_URI  .'screen-image.jpg" alt="'.esc_attr__('Demo Preview Imgae','marino').'" />';

    return array(
        array(
            'import_file_name'             => esc_html__('Marino Demo','marino'),
            'local_import_file'            =>  MARINO_DEMO_DIR_PATH  . 'marino-demo.xml',
            'local_import_widget_file'     =>  MARINO_DEMO_DIR_PATH  . 'marino-widgets-demo.json',
            'local_import_redux'           => array(
                array(
                    'file_path'   =>  MARINO_DEMO_DIR_PATH . 'redux_options_demo.json',
                    'option_name' => 'marino_opt',
                ),
            ),
            'import_notice' => $demoImg,
        ),
    );
}
add_filter( 'pt-ocdi/import_files', 'marino_import_files' );

// demo import setup
function marino_after_import_setup() {
	// Assign menus to their locations.
	$main_menu   	= get_term_by( 'name', 'Primary Menu', 'nav_menu' );
	$mobile_menu  	= get_term_by( 'name', 'Mobile Menu', 'nav_menu' );

	set_theme_mod( 'nav_menu_locations', array(
			'primary-menu'   => $main_menu->term_id,
			'mobile-menu'    => $mobile_menu->term_id,
		)
	);

	// Assign front page and posts page (blog page).
	$front_page_id 	= get_page_by_title( 'Home' );
	$blog_page_id  	= get_page_by_title( 'Blog' );

	update_option( 'show_on_front', 'page' );
	update_option( 'page_on_front', $front_page_id->ID );
	update_option( 'page_for_posts', $blog_page_id->ID );

}
add_action( 'pt-ocdi/after_import', 'marino_after_import_setup' );


//disable the branding notice after successful demo import
add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );

//change the location, title and other parameters of the plugin page
function marino_import_plugin_page_setup( $default_settings ) {
	$default_settings['parent_slug'] = 'themes.php';
	$default_settings['page_title']  = esc_html__( 'Marino Demo Import' , 'marino' );
	$default_settings['menu_title']  = esc_html__( 'Import Demo Data' , 'marino' );
	$default_settings['capability']  = 'import';
	$default_settings['menu_slug']   = 'marino-demo-import';

	return $default_settings;
}
add_filter( 'pt-ocdi/plugin_page_setup', 'marino_import_plugin_page_setup' );

// Enqueue scripts
function marino_demo_import_custom_scripts(){
	if( isset( $_GET['page'] ) && $_GET['page'] == 'marino-demo-import' ){
		// style
		wp_enqueue_style( 'marino-demo-import', MARINO_DEMO_DIR_URI.'css/marino.demo.import.css', array(), '1.0', false );
	}
}
add_action( 'admin_enqueue_scripts', 'marino_demo_import_custom_scripts' );