(function ($) {
  ("use strict");
  /*=================================
      JS Index Here
  ==================================*/
  /*
    01. On Load Function
    02. Preloader
    03. Mobile Menu Active
    04. Sticky fix
    05. Scroll To Top
    06. Set Background Image
    07. Hero Slider Active
    08. Popup Sidemenu
    09. Magnific Popup
    11. Filter
    12. Woocommerce Toggle
    13. Slick 3D Slider
    14. Tournament Hover Height Setup
    15. Tournament Slider Area
    16. Tournament Hero Slider
    17. Quantity Added
  */
  /*=================================
      JS Index End
  ==================================*/
  /*

  /*---------- 01. On Load Function ----------*/
  $(window).on("load", function () {
      $(".preloader").fadeOut();
      slickFixer();
  });
  
  function slickFixer() {
      setTimeout(function () {
        $('.slick-slider').not('.hero-slider').each(function () {
            $(this).slick('refresh');
        });
    }, 400);
  }
  
  /*---------- 02. Preloader ----------*/
  if ($(".preloader").length > 0) {
      $(".preloaderCls").each(function () {
          $(this).on("click", function (e) {
              e.preventDefault();
              $(".preloader").css("display", "none");
          });
      });
  }
  
  /*---------- 03. Mobile Menu Active ----------*/
  $.fn.vsmobilemenu = function (options) {
      var opt = $.extend(
          {
              menuToggleBtn: ".vs-menu-toggle",
              bodyToggleClass: "vs-body-visible",
              subMenuClass: "vs-submenu",
              subMenuParent: "vs-item-has-children",
              subMenuParentToggle: "vs-active",
              meanExpandClass: "vs-mean-expand",
              appendElement: '<span class="vs-mean-expand"></span>',
              subMenuToggleClass: "vs-open",
              toggleSpeed: 400,
          },
          options
      );

      return this.each(function () {
          var menu = $(this); // Select menu

          // Menu Show & Hide
          function menuToggle() {
              menu.toggleClass(opt.bodyToggleClass);

              // collapse submenu on menu hide or show
              var subMenu = "." + opt.subMenuClass;
              $(subMenu).each(function () {
                  if ($(this).hasClass(opt.subMenuToggleClass)) {
                      $(this).removeClass(opt.subMenuToggleClass);
                      $(this).css("display", "none");
                      $(this).parent().removeClass(opt.subMenuParentToggle);
                  }
              });
          }

          // Class Set Up for every submenu
          menu.find("li").each(function () {
              var submenu = $(this).find("ul");
              submenu.addClass(opt.subMenuClass);
              submenu.css("display", "none");
              submenu.parent().addClass(opt.subMenuParent);
              submenu.prev("a").append(opt.appendElement);
              submenu.next("a").append(opt.appendElement);
          });

          // Toggle Submenu
          function toggleDropDown($element) {
              if ($($element).next("ul").length > 0) {
                  $($element).parent().toggleClass(opt.subMenuParentToggle);
                  $($element).next("ul").slideToggle(opt.toggleSpeed);
                  $($element).next("ul").toggleClass(opt.subMenuToggleClass);
              } else if ($($element).prev("ul").length > 0) {
                  $($element).parent().toggleClass(opt.subMenuParentToggle);
                  $($element).prev("ul").slideToggle(opt.toggleSpeed);
                  $($element).prev("ul").toggleClass(opt.subMenuToggleClass);
              }
          }

          // Submenu toggle Button
          var expandToggler = "." + opt.meanExpandClass;
          $(expandToggler).each(function () {
              $(this).on("click", function (e) {
                  e.preventDefault();
                  toggleDropDown($(this).parent());
              });
          });

          // Menu Show & Hide On Toggle Btn click
          $(opt.menuToggleBtn).each(function () {
              $(this).on("click", function () {
                  menuToggle();
              });
          });

          // Hide Menu On out side click
          menu.on("click", function (e) {
              e.stopPropagation();
              menuToggle();
          });

          // Stop Hide full menu on menu click
          menu.find("div").on("click", function (e) {
              e.stopPropagation();
          });
      });
  };

  $(".vs-menu-wrapper").vsmobilemenu();

  /*---------- 04. Sticky fix ----------*/
  var lastScrollTop = "";
  var scrollToTopBtn = ".scrollToTop";

  function stickyMenu($targetMenu, $toggleClass, $parentClass) {
      var st = $(window).scrollTop();
      var height = $targetMenu.css("height");
      $targetMenu.parent().css("min-height", height);
      if ($(window).scrollTop() > 800) {
          $targetMenu.parent().addClass($parentClass);

          if (st > lastScrollTop) {
              $targetMenu.removeClass($toggleClass);
          } else {
              $targetMenu.addClass($toggleClass);
          }
      } else {
          $targetMenu.parent().css("min-height", "").removeClass($parentClass);
          $targetMenu.removeClass($toggleClass);
      }
      lastScrollTop = st;
  }
    $(window).on("scroll", function () {
      stickyMenu($(".sticky-active"), "active", "will-sticky");
        if ($(this).scrollTop() > 500) {
            $(scrollToTopBtn).addClass("show");
        } else {
            $(scrollToTopBtn).removeClass("show");
        }
    });

    /*---------- 05. Scroll To Top ----------*/
    $(scrollToTopBtn).each(function () {
        $(this).on("click", function (e) {
            e.preventDefault();
            $("html, body").animate(
                {
                  scrollTop: 0,
                },
                lastScrollTop / 3
            );
          return false;
        });
    });

  /*---------- 06.Set Background Image ----------*/
    if ($("[data-bg-src]").length > 0) {
        $("[data-bg-src]").each(function () {
            var src = $(this).attr("data-bg-src");
            $(this).css("background-image", "url(" + src + ")");
            $(this).removeAttr("data-bg-src").addClass("background-image");
        });
    }

    /*---------- 08. Popup Sidemenu ----------*/
    function popupSideMenu($sideMenu, $sideMunuOpen, $sideMenuCls, $toggleCls) {
      // Sidebar Popup
      $($sideMunuOpen).on("click", function (e) {
          e.preventDefault();
          $($sideMenu).addClass($toggleCls);
      });
      $($sideMenu).on("click", function (e) {
          e.stopPropagation();
          $($sideMenu).removeClass($toggleCls);
      });
      var sideMenuChild = $sideMenu + " > div";
      $(sideMenuChild).on("click", function (e) {
          e.stopPropagation();
          $($sideMenu).addClass($toggleCls);
      });
      $($sideMenuCls).on("click", function (e) {
          e.preventDefault();
          e.stopPropagation();
          $($sideMenu).removeClass($toggleCls);
      });
    }
    popupSideMenu(
      ".sidemenu-offcanvas",
      ".sideMenuToggler",
      ".sideMenuCls",
      "show"
    );

        // Cart Offcanvas Menu
    function cartMenu($sideMenu, $sideMunuOpen, $sideMenuCls, $toggleCls) {
        // Sidebar Popup
        $($sideMunuOpen).on("click", function (e) {
            e.preventDefault();
            $($sideMenu).addClass($toggleCls);
        });
        $($sideMenu).on("click", function (e) {
            e.stopPropagation();
            $($sideMenu).removeClass($toggleCls);
        });
        var sideMenuChild = $sideMenu + " > div";
        $(sideMenuChild).on("click", function (e) {
            e.stopPropagation();
            $($sideMenu).addClass($toggleCls);
        });
        $($sideMenuCls).on("click", function (e) {
            e.preventDefault();
            e.stopPropagation();
            $($sideMenu).removeClass($toggleCls);
        });
    }
    cartMenu(
        ".cart-offcanvas",
        ".sideMenuToggler2",
        ".sideMenuCls",
        "show"
    );


  /*----------- 09. Magnific Popup ----------*/
  /* magnificPopup img view */
  $(".popup-image").magnificPopup({
      type: "image",
      gallery: {
          enabled: true,
      },
  });

  /* magnificPopup video view */
  $(".popup-video").magnificPopup({
      type: "iframe",
  });
  
  /*---------- 08. Search Box Popup ----------*/
  function popupSarchBox($searchBox, $searchOpen, $searchCls, $toggleCls) {
      $($searchOpen).on('click', function (e) {
          e.preventDefault();
          $($searchBox).addClass($toggleCls);
      });
      $($searchBox).on('click', function (e) {
          e.stopPropagation();
          $($searchBox).removeClass($toggleCls);
      });
      $($searchBox).find('form').on('click', function (e) {
          e.stopPropagation();
          $($searchBox).addClass($toggleCls);
      });
      $($searchCls).on('click', function (e) {
          e.preventDefault();
          e.stopPropagation();
          $($searchBox).removeClass($toggleCls);
      });
  };
  popupSarchBox('.popup-search-box', '.searchBoxTggler', '.searchClose', 'show');


  $('.blog-img-slider').slick({
      dots: false,
      infinite: true,
      arrows: true,
      prevArrow: '<button type="button" class="slick-prev"><i class="far fa-chevron-left"></i></button>',
      nextArrow: '<button type="button" class="slick-next"><i class="far fa-chevron-right"></i></button>',
      autoplay: true,
      autoplaySpeed: 6000,
      fade: false,
      speed: 1000,
      slidesToShow: 1,
      slidesToScroll: 1,
  });
  
  $('.product-img-slide').slick({
      dots: true,
      infinite: true,
      arrows: false,
      autoplay: true,
      autoplaySpeed: 6000,
      fade: true,
      speed: 1000,
      slidesToShow: 1,
      slidesToScroll: 1,
  });
  
  $('.related-product-slider').slick({
      dots: false,
      infinite: true,
      arrows: false,
      autoplay: true,
      autoplaySpeed: 6000,
      fade: false,
      speed: 1000,
      slidesToShow: 3,
      slidesToScroll: 1,
      responsive: [{
          breakpoint: 992,
          settings: {
              slidesToShow: 2
          }
      },{
          breakpoint: 767,
          settings: {
              slidesToShow: 1
          }
      }]
  });
  
     /*---------- 18. Quantity Added ----------*/
    $(document).on('click', '.quantity-plus,.quantity-minus', function(e) {
        e.preventDefault();
        // Get current quantity values
        var qty = $(this).closest('.product-quantity').find('.qty');
        var val = parseFloat(qty.val());
        var max = parseFloat(qty.attr('max'));
        var min = parseFloat(qty.attr('min'));
        var step = parseFloat(qty.attr('step'));

        // Change the value if plus or minus
        if ($(this).is('.quantity-plus')) {
            if (max && (max <= val)) {
                qty.val(max);
            } else {
                qty.val(val + step);
            }
        } else {
            if (min && (min >= val)) {
                qty.val(min);
            } else if (val > 0) {
                qty.val(val - step);
            }
        }
        $('.cart_table button[name="update_cart"]').prop('disabled', false);
    });
  
    // Interger Converter
    function convertInteger(str) {
        return parseInt(str, 10)
      }
      
      $.fn.sectionPosition = function (mainAttr, posAttr) {   
        $(this).each(function () {
          var section = $(this);
          
          function setPosition (){
            var sectionHeight = Math.floor(section.height() / 2), // Main Height of section
            posData = section.attr(mainAttr), // where to position
            posFor  = section.attr(posAttr), // On Which section is for positioning  
            topMark = 'top-half', // Pos top
            bottomMark = 'bottom-half', // Pos Bottom
            parentPT = convertInteger($(posFor).css('padding-top')), // Default Padding of  parent
            parentPB = convertInteger($(posFor).css('padding-bottom')); // Default Padding of  parent
    
            if (posData === topMark) {
              $(posFor).css('padding-bottom', parentPB + sectionHeight + 'px');
              section.css('margin-top', "-" + sectionHeight + 'px');
            } else if (posData === bottomMark) {
              $(posFor).css('padding-top', parentPT + sectionHeight + 'px');
              section.css('margin-bottom', "-" + sectionHeight + 'px');
            }
          }
          setPosition(); // Set Padding On Load
        });
    }
    
    
    if ($('[data-sec-pos]').length) {
        $('[data-sec-pos]').sectionPosition('data-sec-pos', 'data-pos-for');
    }

  /*----------- 13. Filter Menu ----------*/
  // $('.search-active').imagesLoaded(function() {
  //     var $filter = '.search-active',
  //         $filterItem = '.grid-item';

  //     if ($($filter).length > 0) {
  //         var $grid = $($filter).isotope({
  //             itemSelector: $filterItem,
  //             filter: '*',
  //             masonry: {
  //                 // use outer width of grid-sizer for columnWidth
  //                 columnWidth: $filterItem
  //             }
  //         });
  //     };
  // });
  
  $("[data-slick-next]").each(function () {
      $(this).on("click", function (e) {
          e.preventDefault();
          $($(this).data("slick-next")).slick("slickNext");
      });
  });

  $("[data-slick-prev]").each(function () {
      $(this).on("click", function (e) {
          e.preventDefault();
          $($(this).data("slick-prev")).slick("slickPrev");
      });
  });
  
  // Check for arrow wrapper
  var sliderElement = $('[data-slick-arrows="true"]');
  if (sliderElement.data("slick-arrows") == true) {
      if (!sliderElement.closest(".arrow-wrap").length) {
      sliderElement.closest(".elementor-container").parent().addClass("arrow-wrap");
      }
  }

})(jQuery);