<?php
/**
 * @Packge     : Marino
 * @Version    : 1.0
 * @Author     : Vecurosoft
 * @Author URI : https://themeforest.net/user/vecuro_themes
 *
 */

    // Block direct access
    if( !defined( 'ABSPATH' ) ){
        exit();
    }

    if( class_exists( 'ReduxFramework' ) ) {
        $marino404title     = marino_opt( 'marino_fof_title' );
        $marino404subtitle  = marino_opt( 'marino_fof_subtitle' );
        $marino404desc      = marino_opt( 'marino_fof_desc' );
        $marino404btntext   = marino_opt( 'marino_fof_btn_text' );
        $marino_404_image   = marino_opt( 'marino_404_image','url' );
    } else {
        $marino404title     = __( 'Oops! That Page Can\'t Be Found.', 'marino' );
        $marino404subtitle  = __( 'Error Page', 'marino' );
        $marino404btntext   = __( 'Go Back Home', 'marino');
        $marino404desc      = __( 'Unfortunately, something went wrong and this page does not exist. Try using the search or return to the previous page.', 'marino');
        $marino_404_image   = get_template_directory_uri().'/assets/img/error.svg';
    }

    // get header
    get_header();
    echo '<section class="vs-error-wrapper space">';
        echo '<div class="container">';
            echo '<div class="row  text-center justify-content-center">';
                if( ! empty( $marino_404_image ) ){
                    echo '<div class="col-xl-12 mb-5">';
                        echo '<div class="error-img">';
                            echo marino_img_tag( array(
                                'url'       => esc_url( $marino_404_image ),
                            ) );
                        echo '</div>';
                    echo '</div>';
                }
                    
                echo '<div class="col-md-8 col-lg-7 col-xl-8">';
                    echo '<div class="error-content text-center">';
                        echo '<div class="title-area text-center mb-0 wow fadeInUp wow-animated" data-wow-delay="0.3s">';
                            echo '<span class="sec-subtitle">'.esc_html( $marino404subtitle ).'</span>';
                            echo '<h3 class="sec-title">'.esc_html( $marino404title ).'</h3>';
                        echo '</div>';
                        echo '<p class="error-text">Unfortunately, something went wrong and this page does not exist. Try using the <br> search or return to the previous page.</p>';
                        echo '<a href="'.esc_url( home_url('/') ).'" class="vs-btn">'.esc_html( $marino404btntext ).'</a>';
                    echo '</div>';
                echo '</div>';

            echo '</div>';
        echo '</div>';
    echo '</section>';
    //footer
    get_footer();