; (function ($) {
    'use strict';
    $(window).on('elementor/frontend/init', function () {



        // Hero Slider
        elementorFrontend.hooks.addAction('frontend/element_ready/marinoheroslider.default', function ($scope) {
            let carousel = $scope.find('.hero-slider');
            carousel.not('.slick-initialized').slick({
                dots: carousel.data('slick-dots'),
                infinite: true,
                arrows: carousel.data('slick-arrows'),
                prevArrow: '<button type="button" class="slick-prev slick-arrow" style=""><i class="far fa-angle-left"></i></button>',
                nextArrow: '<button type="button" class="slick-next slick-arrow" style=""><i class="far fa-angle-right"></i></button>',
                autoplay: carousel.data('slick-autoplay'),
                autoplaySpeed: 6000,
                fade: true,
                speed: 1000,
                slidesToShow: carousel.data('slide-to-show'),
                slidesToScroll: 1,
                responsive: [{
                    breakpoint: 1500,
                    settings: {
                        arrows: false,
                        dots: false,
                    }
                },
                {
                    breakpoint: 768,
                    settings: {
                        arrows: false,
                        dots: false,
                    }
                }
                ]
            });

            if ($('[data-bg-src]').length > 0) {
                $('[data-bg-src]').each(function () {
                    var src = $(this).attr('data-bg-src');
                    $(this).css({
                        'background-image': 'url(' + src + ')'
                    });
                });
            };

            $(".vs-carousel2").each(function () {
                var asSlide = $(this);

                // Collect Data
                function d(data) {
                    return asSlide.data(data);
                }

                // Custom Arrow Button
                var prevButton =
                    '<button type="button" class="slick-prev"><i class="' +
                    d("prev-arrow") +
                    '"></i></button>',
                    nextButton =
                        '<button type="button" class="slick-next"><i class="' +
                        d("next-arrow") +
                        '"></i></button>';

                // Function For Custom Arrow Btn
                $("[data-slick-next]").each(function () {
                    $(this).on("click", function (e) {
                        e.preventDefault();
                        $($(this).data("slick-next")).slick("slickNext");
                    });
                });

                $("[data-slick-prev]").each(function () {
                    $(this).on("click", function (e) {
                        e.preventDefault();
                        $($(this).data("slick-prev")).slick("slickPrev");
                    });
                });

                // Check for arrow wrapper
                if (d("arrows") == true) {
                    if (!asSlide.closest(".arrow-wrap").length) {
                        asSlide.closest(".container").parent().addClass("arrow-wrap");
                    }
                }

                asSlide.slick({
                    dots: d("dots") ? true : false,
                    fade: d("fade") ? true : false,
                    arrows: d("arrows") ? true : false,
                    speed: d("speed") ? d("speed") : 1000,
                    asNavFor: d("asnavfor") ? d("asnavfor") : false,
                    autoplay: d("autoplay") == false ? false : true,
                    infinite: d("infinite") == false ? false : true,
                    slidesToShow: d("slide-show") ? d("slide-show") : 1,
                    adaptiveHeight: d("adaptive-height") ? true : false,
                    centerMode: d("center-mode") ? true : false,
                    autoplaySpeed: d("autoplay-speed") ? d("autoplay-speed") : 8000,
                    centerPadding: d("center-padding") ? d("center-padding") : "0",
                    focusOnSelect: d("focuson-select") ? true : false,
                    pauseOnFocus: d("pauseon-focus") ? true : false,
                    pauseOnHover: d("pauseon-hover") ? true : false,
                    variableWidth: d("variable-width") ? true : false,
                    vertical: d("vertical") ? true : false,
                    verticalSwiping: d("vertical") ? true : false,
                    prevArrow: d("prev-arrow")
                        ? prevButton
                        : '<button type="button" class="slick-prev"><svg width="71" height="70" viewBox="0 0 71 70" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M32.2511 65.0002L35.5845 65.0002C52.153 65.0002 65.5845 51.5688 65.5845 35.0002C65.5845 18.4316 52.153 5.00025 35.5845 5.00025L32.2511 5.00025M18.9178 48.3336L5.58447 35.0002M5.58447 35.0002L18.9178 21.6669M5.58447 35.0002L45.5845 35.0002" stroke="#37AFE3" stroke-width="10" stroke-linecap="round" stroke-linejoin="round"/></svg></button>',
                    nextArrow: d("next-arrow")
                        ? nextButton
                        : '<button type="button" class="slick-next"><svg width="70" height="70" viewBox="0 0 70 70" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M38.3333 5H35C18.4315 5 5 18.4315 5 35C5 51.5687 18.4315 65 35 65H38.3333M51.6667 21.6667L65 35M65 35L51.6667 48.3333M65 35H25" stroke="#37AFE3" stroke-width="10" stroke-linecap="round" stroke-linejoin="round" /></svg></button>',
                    rtl: $("html").attr("dir") == "rtl" ? true : false,
                    responsive: [
                        {
                            breakpoint: 1600,
                            settings: {
                                arrows: d("xl-arrows") ? true : false,
                                dots: d("xl-dots") ? true : false,
                                slidesToShow: d("xl-slide-show")
                                    ? d("xl-slide-show")
                                    : d("slide-show"),
                                centerMode: d("xl-center-mode") ? true : false,
                                centerPadding: 0,
                            },
                        },
                        {
                            breakpoint: 1400,
                            settings: {
                                arrows: d("ml-arrows") ? true : false,
                                dots: d("ml-dots") ? true : false,
                                slidesToShow: d("ml-slide-show")
                                    ? d("ml-slide-show")
                                    : d("slide-show"),
                                centerMode: d("ml-center-mode") ? true : false,
                                centerPadding: 0,
                            },
                        },
                        {
                            breakpoint: 1200,
                            settings: {
                                arrows: d("lg-arrows") ? true : false,
                                dots: d("lg-dots") ? true : false,
                                slidesToShow: d("lg-slide-show") ? d("lg-slide-show") : 1,
                                centerMode: d("lg-center-mode") ? d("lg-center-mode") : false,
                                centerPadding: 0,
                            },
                        },
                        {
                            breakpoint: 992,
                            settings: {
                                arrows: d("md-arrows") ? true : false,
                                dots: d("md-dots") ? true : false,
                                slidesToShow: d("md-slide-show") ? d("md-slide-show") : 1,
                                centerMode: d("md-center-mode") ? d("md-center-mode") : false,
                                centerPadding: 0,
                            },
                        },
                        {
                            breakpoint: 767,
                            settings: {
                                arrows: d("sm-arrows") ? true : false,
                                dots: d("sm-dots") ? true : false,
                                slidesToShow: d("sm-slide-show") ? d("sm-slide-show") : 1,
                                centerMode: d("sm-center-mode") ? d("sm-center-mode") : false,
                                centerPadding: 0,
                            },
                        },
                        {
                            breakpoint: 576,
                            settings: {
                                arrows: d("xs-arrows") ? true : false,
                                dots: d("xs-dots") ? true : false,
                                slidesToShow: d("xs-slide-show") ? d("xs-slide-show") : 1,
                                centerMode: d("xs-center-mode") ? d("xs-center-mode") : false,
                                centerPadding: 0,
                            },
                        },
                        // You can unslick at a given breakpoint now by adding:
                        // settings: "unslick"
                        // instead of a settings object
                    ],
                });
            });
        });
        // Service Slider
        elementorFrontend.hooks.addAction('frontend/element_ready/marinoservice.default', function ($scope) {
            let $slickcarousels = $scope.find('.service-carousel');
            $slickcarousels.not('.slick-initialized').slick({
                dots: $slickcarousels.data('slick-dots'),
                infinite: true,
                arrows: $slickcarousels.data('slick-arrows'),
                prevArrow: '<button type="button" class="slick-prev"><i class="far fa-arrow-left"></i></button>',
                nextArrow: '<button type="button" class="slick-next"><i class="far fa-arrow-right"></i></button>',
                autoplay: $slickcarousels.data('slick-autoplay'),
                autoplaySpeed: 6000,
                fade: false,
                speed: 1000,
                slidesToShow: $slickcarousels.data('slide-to-show'),
                slidesToScroll: 1,
                responsive: [{
                    breakpoint: 1500,
                    settings: {
                        slidesToShow: 3,
                        arrows: false
                    }
                }, {
                    breakpoint: 1350,
                    settings: {
                        slidesToShow: 3,
                        arrows: false
                    }
                }, {
                    breakpoint: 992,
                    settings: {
                        slidesToShow: 2,
                        arrows: false
                    }
                }, {
                    breakpoint: 768,
                    settings: {
                        slidesToShow: 1,
                        arrows: false
                    }
                }
                ]
            });

            $(".vs-carousel-service").each(function () {
                var asSlide = $(this);

                // Collect Data
                function d(data) {
                    return asSlide.data(data);
                }

                // Custom Arrow Button
                var prevButton =
                    '<button type="button" class="slick-prev"><i class="' +
                    d("prev-arrow") +
                    '"></i></button>',
                    nextButton =
                        '<button type="button" class="slick-next"><i class="' +
                        d("next-arrow") +
                        '"></i></button>';

                // Function For Custom Arrow Btn
                $("[data-slick-next]").each(function () {
                    $(this).on("click", function (e) {
                        e.preventDefault();
                        $($(this).data("slick-next")).slick("slickNext");
                    });
                });

                $("[data-slick-prev]").each(function () {
                    $(this).on("click", function (e) {
                        e.preventDefault();
                        $($(this).data("slick-prev")).slick("slickPrev");
                    });
                });

                // Check for arrow wrapper
                if (d("arrows") == true) {
                    if (!asSlide.closest(".arrow-wrap").length) {
                        asSlide.closest(".container").parent().addClass("arrow-wrap");
                    }
                }

                asSlide.slick({
                    dots: d("dots") ? true : false,
                    fade: d("fade") ? true : false,
                    arrows: d("arrows") ? true : false,
                    speed: d("speed") ? d("speed") : 1000,
                    asNavFor: d("asnavfor") ? d("asnavfor") : false,
                    autoplay: d("autoplay") == false ? false : true,
                    infinite: d("infinite") == false ? false : true,
                    slidesToShow: d("slide-show") ? d("slide-show") : 1,
                    adaptiveHeight: d("adaptive-height") ? true : false,
                    centerMode: d("center-mode") ? true : false,
                    autoplaySpeed: d("autoplay-speed") ? d("autoplay-speed") : 8000,
                    centerPadding: d("center-padding") ? d("center-padding") : "0",
                    focusOnSelect: d("focuson-select") ? true : false,
                    pauseOnFocus: d("pauseon-focus") ? true : false,
                    pauseOnHover: d("pauseon-hover") ? true : false,
                    variableWidth: d("variable-width") ? true : false,
                    vertical: d("vertical") ? true : false,
                    verticalSwiping: d("vertical") ? true : false,
                    prevArrow: d("prev-arrow")
                        ? prevButton
                        : '<button type="button" class="slick-prev"><i class="fas fa-chevron-left"></i></button>',
                    nextArrow: d("next-arrow")
                        ? nextButton
                        : '<button type="button" class="slick-next"><i class="fas fa-chevron-right"></i></button>',
                    rtl: $("html").attr("dir") == "rtl" ? true : false,
                    responsive: [
                        {
                            breakpoint: 1600,
                            settings: {
                                arrows: d("xl-arrows") ? true : false,
                                dots: d("xl-dots") ? true : false,
                                slidesToShow: d("xl-slide-show")
                                    ? d("xl-slide-show")
                                    : d("slide-show"),
                                centerMode: d("xl-center-mode") ? true : false,
                                centerPadding: 0,
                            },
                        },
                        {
                            breakpoint: 1400,
                            settings: {
                                arrows: d("ml-arrows") ? true : false,
                                dots: d("ml-dots") ? true : false,
                                slidesToShow: d("ml-slide-show")
                                    ? d("ml-slide-show")
                                    : d("slide-show"),
                                centerMode: d("ml-center-mode") ? true : false,
                                centerPadding: 0,
                            },
                        },
                        {
                            breakpoint: 1200,
                            settings: {
                                arrows: d("lg-arrows") ? true : false,
                                dots: d("lg-dots") ? true : false,
                                slidesToShow: d("lg-slide-show") ? d("lg-slide-show") : 1,
                                centerMode: d("lg-center-mode") ? d("lg-center-mode") : false,
                                centerPadding: 0,
                            },
                        },
                        {
                            breakpoint: 992,
                            settings: {
                                arrows: d("md-arrows") ? true : false,
                                dots: d("md-dots") ? true : false,
                                slidesToShow: d("md-slide-show") ? d("md-slide-show") : 1,
                                centerMode: d("md-center-mode") ? d("md-center-mode") : false,
                                centerPadding: 0,
                            },
                        },
                        {
                            breakpoint: 767,
                            settings: {
                                arrows: d("sm-arrows") ? true : false,
                                dots: d("sm-dots") ? true : false,
                                slidesToShow: d("sm-slide-show") ? d("sm-slide-show") : 1,
                                centerMode: d("sm-center-mode") ? d("sm-center-mode") : false,
                                centerPadding: 0,
                            },
                        },
                        {
                            breakpoint: 576,
                            settings: {
                                arrows: d("xs-arrows") ? true : false,
                                dots: d("xs-dots") ? true : false,
                                slidesToShow: d("xs-slide-show") ? d("xs-slide-show") : 1,
                                centerMode: d("xs-center-mode") ? d("xs-center-mode") : false,
                                centerPadding: 0,
                            },
                        },
                        // You can unslick at a given breakpoint now by adding:
                        // settings: "unslick"
                        // instead of a settings object
                    ],
                });
            });
        });
        // Product Slider
        elementorFrontend.hooks.addAction('frontend/element_ready/marinoproductslider.default', function ($scope) {
            let $slickcarousels = $scope.find('.vs-carousel');
            $slickcarousels.not('.slick-initialized').slick({
                dots: false,
                infinite: true,
                arrows: $slickcarousels.data('slick-arrows'),
                prevArrow: '<button type="button" class="slick-prev"><i class="far fa-arrow-left"></i></button>',
                nextArrow: '<button type="button" class="slick-next"><i class="far fa-arrow-right"></i></button>',
                autoplay: $slickcarousels.data('slick-autoplay'),
                autoplaySpeed: 6000,
                fade: false,
                speed: 1000,
                slidesToShow: $slickcarousels.data('slide-to-show'),
                slidesToScroll: 1,
                responsive: [{
                    breakpoint: 1500,
                    settings: {
                        slidesToShow: 3,
                        arrows: false,
                    }
                }, {
                    breakpoint: 992,
                    settings: {
                        slidesToShow: 2,
                        arrows: false,
                    }
                },
                {
                    breakpoint: 768,
                    settings: {
                        slidesToShow: 1,
                        arrows: false,
                    }
                }
                ]
            });

        });

        // Testimonials
        elementorFrontend.hooks.addAction('frontend/element_ready/marinotestimonialslider.default', function ($scope) {

            let $testsliderone = $scope.find('#testis_4_1');
            $testsliderone.not('.slick-initialized').slick({
                dots: false,
                arrows: false,
                infinite: true,
                autoplay: true,
                autoplaySpeed: 6000,
                fade: false,
                speed: 1000,
                slidesToShow: 1,
                slidesToScroll: 1,
                fade: true,
                asNavFor: '#testis_4_2, #testis_4_3,#testis_4_4',
                responsive: [{
                    breakpoint: 1500,
                    settings: {
                        arrows: false
                    }
                }]
            });

            let $testslidertwo = $scope.find('#testis_4_2');
            $testslidertwo.not('.slick-initialized').slick({
                dots: false,
                infinite: true,
                arrows: false,
                autoplay: true,
                autoplaySpeed: 6000,
                fade: false,
                speed: 1000,
                slidesToShow: 4,
                vertical: true,
                slidesToScroll: 1,
                centerMode: true,
                centerPadding: "0",
                focusOnSelect: true,
                asNavFor: "#testis_4_1, #testis_4_3",
                responsive: [
                    {
                        breakpoint: 1199,
                        settings: {
                            slidesToShow: 4,
                        },
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            vertical: false,
                            slidesToShow: 4,
                        },
                    }, {
                        breakpoint: 767,
                        settings: {
                            vertical: false,
                            slidesToShow: 3,
                        },
                    },
                ],
            });

            let $testsliderthree = $scope.find('#testis_4_3');
            $testsliderthree.not('.slick-initialized').slick({
                dots: false,
                infinite: true,
                arrows: false,
                autoplay: true,
                autoplaySpeed: 6000,
                speed: 1000,
                slidesToShow: 1,
                slidesToScroll: 1,
                fade: true,
                asNavFor: '#testis_4_2, #testis_4_1'
            });
            let $testsliderfoour = $scope.find('#testis_4_4');
            $testsliderfoour.not('.slick-initialized').slick({
                autoplay: true,
                arrows: false,
                dots: false,
                slidesToShow: 2,
                centerPadding: "10px",
                draggable: false,
                infinite: true,
                pauseOnHover: false,
                swipe: false,
                touchMove: false,
                vertical: true,
                verticalScrolling: true,
                speed: 1000,
                autoplaySpeed: 3000,
                useTransform: true,
                cssEase: 'cubic-bezier(0.645, 0.045, 0.355, 1.000)',
                adaptiveHeight: true,
                asNavFor: "#testis_4_2, #testis_4_1",
            });

            let $testsliderfive = $scope.find('.vs-carousel');
            $testsliderfive.not('.slick-initialized').slick({
                infinite: true,
                arrows: $testsliderfive.data('arrows'),
                prevArrow: '<button type="button" class="slick-prev"><i class="far fa-arrow-left"></i></button>',
                nextArrow: '<button type="button" class="slick-next"><i class="far fa-arrow-right"></i></button>',
                autoplay: true,
                autoplaySpeed: 5000,
                speed: 1000,
                fade: false,
                slidesToScroll: 1,
                slidesToShow: 2,
                responsive: [{
                    breakpoint: 1500,
                    settings: {
                        slidesToShow: 2,
                        slidesToScroll: 1
                    }
                }, {
                    breakpoint: 1350,
                    settings: {
                        slidesToShow: 2,
                        slidesToScroll: 1
                    }
                }, {
                    breakpoint: 992,
                    settings: {
                        slidesToShow: 1,
                        slidesToScroll: 1
                    }
                }, {
                    breakpoint: 768,
                    settings: {
                        slidesToShow: 1,
                        slidesToScroll: 1
                    }
                }
                ]
            });


        });

        // Client Logo
        elementorFrontend.hooks.addAction('frontend/element_ready/marinoclientlogo.default', function ($scope) {
            let $logoslider = $scope.find('.vs-carousel');
            $logoslider.not('.slick-initialized').slick({
                infinite: true,
                arrows: false,
                autoplay: true,
                autoplaySpeed: 5000,
                speed: 1000,
                fade: false,
                slidesToShow: $logoslider.data('data-slide-show'),
                slidesToScroll: 1,
                slidesToShow: 5,
                centerMode: $logoslider.data('centermode'),
                centerPadding: $logoslider.data('centerpadding'),
                responsive: [{
                    breakpoint: 1500,
                    settings: {
                        slidesToShow: 5,
                        slidesToScroll: 1
                    }
                }, {
                    breakpoint: 1350,
                    settings: {
                        slidesToShow: 5,
                        slidesToScroll: 1
                    }
                }, {
                    breakpoint: 992,
                    settings: {
                        slidesToShow: 3,
                        slidesToScroll: 1
                    }
                }, {
                    breakpoint: 768,
                    settings: {
                        slidesToShow: 1,
                        slidesToScroll: 1
                    }
                }
                ]
            });
        });


        // blog post type
        elementorFrontend.hooks.addAction('frontend/element_ready/marinoblogpost.default', function ($scope) {
            let $blog_post = $scope.find('.vs-carousel');
            // Blog Layout 1 Slider
            $blog_post.not('.slick-initialized').slick({
                dots: false,
                infinite: true,
                arrows: $blog_post.data('slick-arrows'),
                prevArrow: '<button type="button" class="slick-prev slick-arrow" style=""><i class="far fa-angle-left"></i></button>',
                nextArrow: '<button type="button" class="slick-next slick-arrow" style=""><i class="far fa-angle-right"></i></button>',
                autoplay: $blog_post.data('slick-autoplay'),
                autoplaySpeed: 8000,
                fade: false,
                speed: 1300,
                slidesToShow: $blog_post.data('slide-to-show'),
                slidesToScroll: 1,
                responsive: [{
                    breakpoint: 1500,
                    settings: {
                        slidesToShow: 3,
                    }
                }, {
                    breakpoint: 1200,
                    settings: {
                        slidesToShow: 2,
                        arrows: false,
                    }
                }, {
                    breakpoint: 992,
                    settings: {
                        slidesToShow: 2,
                        arrows: false,
                    }
                }, {
                    breakpoint: 768,
                    settings: {
                        slidesToShow: 1,
                        arrows: false,
                    }
                }
                ]
            });

        });

        // Counter Up
        elementorFrontend.hooks.addAction('frontend/element_ready/marinocounterup.default', function ($scope) {
            var $counter = $scope.find('.counter');
            $counter.counterUp({
                delay: 10,
                time: 1000
            });

        });
        // Team Member
        elementorFrontend.hooks.addAction('frontend/element_ready/marinoteammember.default', function ($scope) {
            let $slickcarousels = $scope.find('.vs-carousel');
            $slickcarousels.not('.slick-initialized').slick({
                dots: $slickcarousels.data('slick-dots'),
                infinite: true,
                arrows: $slickcarousels.data('slick-arrows'),
                prevArrow: '<button type="button" class="slick-prev"><i class="far fa-arrow-left"></i></button>',
                nextArrow: '<button type="button" class="slick-next"><i class="far fa-arrow-right"></i></button>',
                autoplay: $slickcarousels.data('slick-autoplay'),
                autoplaySpeed: 6000,
                fade: false,
                speed: 1000,
                slidesToShow: $slickcarousels.data('slide-to-show'),
                slidesToScroll: 1,
                responsive: [{
                    breakpoint: 1500,
                    settings: {
                        slidesToShow: $slickcarousels.data('slide-to-show1500'),
                        arrows: false,
                    }
                }, {
                    breakpoint: 1200,
                    settings: {
                        slidesToShow: $slickcarousels.data('slide-to-show1200'),
                        arrows: false,
                    }
                }, {
                    breakpoint: 992,
                    settings: {
                        slidesToShow: $slickcarousels.data('slide-to-show992'),
                        dots: false,
                        arrows: false,
                    }
                }, {
                    breakpoint: 768,
                    settings: {
                        slidesToShow: $slickcarousels.data('slide-to-show768'),
                        dots: false,
                        arrows: false,
                    }
                }
                ]
            });
        });
        // Service Slider
        elementorFrontend.hooks.addAction('frontend/element_ready/marinohuntarspot.default', function ($scope) {
            let $slickcarousels = $scope.find('.vs-carousel');
            $slickcarousels.not('.slick-initialized').slick({
                dots: $slickcarousels.data('slick-dots'),
                infinite: true,
                arrows: $slickcarousels.data('slick-arrows'),
                prevArrow: '<button type="button" class="slick-prev"><i class="far fa-arrow-left"></i></button>',
                nextArrow: '<button type="button" class="slick-next"><i class="far fa-arrow-right"></i></button>',
                autoplay: true,
                autoplaySpeed: 6000,
                fade: false,
                speed: 1000,
                slidesToShow: $slickcarousels.data('slide-show'),
                slidesToScroll: 1,
                responsive: [{
                    breakpoint: 1500,
                    settings: {
                        slidesToShow: $slickcarousels.data('slide-show'),
                        arrows: false,
                    }
                }, {
                    breakpoint: 1200,
                    settings: {
                        slidesToShow: $slickcarousels.data('lg-slide-show'),
                        arrows: false,
                    }
                }, {
                    breakpoint: 992,
                    settings: {
                        slidesToShow: $slickcarousels.data('md-slide-show'),
                        dots: false,
                        arrows: false,
                    }
                }, {
                    breakpoint: 768,
                    settings: {
                        slidesToShow: 1,
                        dots: false,
                        arrows: false,
                    }
                }
                ]
            });
        });


    });
}(jQuery));

