<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Image_Size;

/**
 *
 * Woking Step Widget .
 *
 */
class Marino_Woking_Step extends Widget_Base {

	public function get_name() {
		return 'marinowokingstep';
	}

	public function get_title() {
		return __('Woking Step', 'marino');
	}

	public function get_icon() {
		return 'eicon-code';
	}

	public function get_categories() {
		return ['marino'];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'woking_step',
			[
				'label'		=> __('Woking Step', 'marino'),
				'tab'		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'woking_style',
			[
				'label'     => __('Style', 'marino'),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => '1',
				'options'   => [
					'1'         => __('Style One', 'marino'),
					'2'         => __('Style Two', 'marino'),
				],
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'image',
			[
				'label'     => __('Hunting Image', 'marino'),
				'type'      => Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater->add_control(
			'step_text',
			[
				'label' 		=> esc_html__('Step Text', 'marino'),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __('1', 'marino'),
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'title',
			[
				'label' 		=> __('Title', 'marino'),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __('Make a Plan', 'marino'),
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'desc',
			[
				'label' 		=> __('Content', 'marino'),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __('Safe Cleaning SuppliesLorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi in metus justo.consectetur adipiscing elit. Morbi in metus justo.', 'marino'),
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'desc_two',
			[
				'label' 		=> __('Details', 'marino'),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __('Safe Cleaning SuppliesLorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi in metus justo.consectetur adipiscing elit. Morbi in metus justo.', 'marino'),
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'hunting_spot',
			[
				'label' 		=> __('Huntings', 'marino'),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __('Make a Plan', 'marino'),
					],
				],
				'title_field' 	=> '{{{ title }}}',
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'title_styling',
			[
				'label' 	=> __('Title Styling', 'marino'),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'working_step_title_color',
			[
				'label' 		=> __('Title Color', 'marino'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .media-style2 .media-title,{{WRAPPER}} .service_style4 .service_left .service_title'	=> 'color: {{VALUE}}!important;',
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'working_step_title_typography',
				'label' 		=> esc_html__('Title Typography', 'marino'),
				'selector' 		=> '{{WRAPPER}} .media-style2 .media-title,{{WRAPPER}} .service_style4 .service_left .service_title',
			]
		);

		$this->add_responsive_control(
			'working_step_title_margin',
			[
				'label' 		=> __('Title Margin', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .media-style2 .media-title,{{WRAPPER}} .service_style4 .service_left .service_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'working_step_title_padding',
			[
				'label' 		=> __('Title Padding', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .media-style2 .media-title,{{WRAPPER}} .service_style4 .service_left .service_title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'desc_styling',
			[
				'label' 	=> __('Description Styling', 'marino'),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'working_step_desc_color',
			[
				'label' 		=> __('Description Color', 'marino'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .media-style2 .media-text,{{WRAPPER}} .service_style4 .service_inner .service_content .service_text,{{WRAPPER}} .service_style4 .accordion-body p'	=> 'color: {{VALUE}}!important;',
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'working_step_desc_typography',
				'label' 		=> esc_html__('Description Typography', 'marino'),
				'selector' 		=> '{{WRAPPER}} .media-style2 .media-text,{{WRAPPER}} .service_style4 .service_inner .service_content .service_text,{{WRAPPER}} .service_style4 .accordion-body p',
			]
		);

		$this->add_responsive_control(
			'working_step_desc_margin',
			[
				'label' 		=> __('Description Margin', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .media-style2 .media-text,{{WRAPPER}} .service_style4 .service_inner .service_content .service_text,{{WRAPPER}} .service_style4 .accordion-body p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'working_step_desc_padding',
			[
				'label' 		=> __('Description Padding', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .media-style2 .media-text,{{WRAPPER}} .service_style4 .service_inner .service_content .service_text,{{WRAPPER}} .service_style4 .accordion-body p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
	}

	protected function render() {

		$settings = $this->get_settings_for_display();
		if ($settings['woking_style'] == '1') {
			echo '<div class="working_step">';
			foreach ($settings['hunting_spot'] as $data) {
				echo '<div class="media-style2">';
				echo '<div class="media-icon">';
				if (!empty($data['image']['url'])) {
					echo marino_img_tag(array(
						'url'   => esc_url($data['image']['url']),
					));
				}
				if (!empty($data['step_text'])) {
					echo '<span class="number">' . esc_html($data['step_text']) . '</span>';
				}
				echo '</div>';
				echo '<div class="media-body">';
				if (!empty($data['title'])) {
					echo '<h3 class="media-title">' . esc_html($data['title']) . '</h3>';
				}
				if (!empty($data['desc'])) {
					echo '<p class="media-text">' . esc_html($data['desc']) . '</p>';
				}
				echo '</div>';
				echo '</div>';
			}
			echo '</div>';
		} elseif ($settings['woking_style'] == '2') { ?>
			<div id="faqVersion1" class="service_style4 accordion g-5">
				<?php foreach ($settings['hunting_spot'] as $index => $data) : ?>
					<div class="service_inner accordion-item">
						<?php if (!empty($data['image']['url'])) : ?>
							<div class="background-image image-hover" data-bg-src="<?php echo esc_url($data['image']['url']); ?>"></div>
						<?php endif; ?>
						<div class="accordion-header" id="headingOne">
							<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne-<?php echo esc_attr($index); ?>" aria-expanded="false" aria-controls="collapseOne-<?php echo esc_attr($index); ?>">
								<div class="service-top">
									<div class="service_left">
										<?php if (!empty($data['step_text'])) {
											echo '<span class="number">' . esc_html($data['step_text']) . '</span>';
										}; ?>
										<?php if (!empty($data['title'])) {
											echo '<h3 class="service_title">' . esc_html($data['title']) . '</h3>';
										} ?>
									</div>
									<div class="service_content">
										<?php if (!empty($data['desc'])) {
											echo '<p class="service_text">' . esc_html($data['desc']) . '</p>';
										} ?>
									</div>
								</div>
							</button>
						</div>
						<div id="collapseOne-<?php echo esc_attr($index); ?>" class="accordion-collapse collapse" aria-labelledby="headingOne-<?php echo esc_attr($index); ?>" data-bs-parent="#faqVersion1">
							<div class="accordion-body">
								<?php if (!empty($data['desc_two'])) {
									echo '<p>' . esc_html($data['desc_two']) . '</p>';
								} ?>
							</div>
						</div>
					</div>
				<?php endforeach; ?>
			</div>
<?php }
	}
}
