<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Gallery Widget .
 *
 */
class Marino_Gallery_Widget extends Widget_Base {

	public function get_name() {
		return 'marinogallery';
	}

	public function get_title() {
		return esc_html__( 'Marino Gallery', 'marino' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'marino' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'gallery_img_section',
			[
				'label' 	=> esc_html__( 'Gallery', 'marino' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

        $repeater = new Repeater();

		$repeater->add_control(
			'gallery_img',
			[
				'label' 	=> esc_html__( 'Gallery', 'marino' ),
				'type' 		=> Controls_Manager::MEDIA,
				'default' => [
					'url' 	=> Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'gallery_imgs',
			[
				'label' 		=> esc_html__( 'Gallerys', 'marino' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'gallery_img' => Utils::get_placeholder_image_src(),
					],
					[
						'gallery_img' => Utils::get_placeholder_image_src(),
					],
					[
						'gallery_img' => Utils::get_placeholder_image_src(),
					],
					[
						'gallery_img' => Utils::get_placeholder_image_src(),
					],
					[
						'gallery_img' => Utils::get_placeholder_image_src(),
					],
				]
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'slider_control_section',
			[
				'label' 		=> esc_html__( 'Gallery Control', 'marino' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'icon_color',
			[
				'label' 		=> esc_html__( 'Icon Color', 'marino' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .sidebar-gallery .gallery-thumb .gal-btn' => 'color: {{VALUE}}!important;',
				],
			]
        );
        $this->add_control(
			'bg_color',
			[
				'label' 		=> esc_html__( 'Background Color', 'marino' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .sidebar-gallery .gallery-thumb:before' => 'background-color: {{VALUE}}!important;',
				],
			]
        );

        $this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        echo '<div class="footer-widget">';
            echo '<div class="sidebar-gallery">';
                foreach( $settings['gallery_imgs'] as $singlelogo ) {
                    echo '<div class="gallery-thumb">';
                        if( ! empty( $singlelogo['gallery_img'] ) ){
                            echo marino_img_tag( array(
                                'url'   => esc_url( $singlelogo['gallery_img']['url'] ),
                                'class' => 'w-100',
                            ) );
                        }
                        echo '<a href="'.esc_url( $singlelogo['gallery_img']['url'] ).'" class="popup-image gal-btn"><i class="far fa-search-plus"></i></a>';
                    echo '</div>';
                }
            echo '</div>';
        echo '</div>';

	}

}