<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Image_Size;
/**
 *
 * Fishing Spot Widget .
 *
 */
class Marino_Fishing_Spot_Widget extends Widget_Base{

	public function get_name() {
		return 'marinofishingspot';
	}

	public function get_title() {
		return __( 'Fishing Spot', 'marino' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'marino' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'fishing_spot',
			[
				'label'		=> __( 'Fishing Spot','marino' ),
				'tab'		=> Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'image',
            [
                'label'     => __( 'Fishing Image', 'marino' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
            ]
        );

        $this->add_control(
			'title', [
				'label' 		=> __( 'Title', 'marino' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Safe Cleaning Supplies' , 'marino' ),
				'label_block' 	=> true,
			]
        );
       
        $this->add_control(
			'desc', [
				'label' 		=> __( 'Content', 'marino' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Safe Cleaning Supplies' , 'marino' ),
				'label_block' 	=> true,
			]
        );

		$this->add_control(
			'button_text',
			[
				'label' 		=> esc_html__( 'Button Text', 'marino' ),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> __( 'Read More' , 'marino' ),
				'label_block' 	=> true,
			]
		);
		
        $this->add_control(
			'button_link',
			[
				'label' 		=> esc_html__( 'Link', 'marino' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'marino' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

        $this->add_control(
			'reverse_style',
			[
				'label' 		=> __( 'Reverse?', 'marino' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'marino' ),
				'label_off' 	=> __( 'No', 'marino' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);

        $this->end_controls_section();
		/*-----------------------------------------title styling------------------------------------*/

		
		$this->start_controls_section(
			'title_styling',
			[
				'label' 	=> __( 'Title Styling', 'marino' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'title_color',
			[
				'label' 		=> __( 'Title Color', 'marino' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .feature-style2 .feature-body .feature-title'	=> 'color: {{VALUE}}!important;',
				]
			]
        );
        $this->add_group_control(
		    Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'title_typography',
		 		'label' 		=> esc_html__( 'Title Typography', 'marino' ),
		 		'selector' 		=> '{{WRAPPER}} .feature-style2 .feature-body .feature-title',
		 	]
		);

        $this->add_responsive_control(
			'title_margin',
			[
				'label' 		=> __( 'Title Margin', 'marino' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .feature-style2 .feature-body .feature-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'title_padding',
			[
				'label' 		=> __( 'Description Padding', 'marino' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .feature-style2 .feature-body .feature-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->end_controls_section();

		$this->start_controls_section(
			'desc_styling',
			[
				'label' 	=> __( 'Description Styling', 'marino' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'description_color',
			[
				'label' 		=> __( 'Description Color', 'marino' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .feature-style2 .feature-body .feature-text'	=> 'color: {{VALUE}}!important;',
				]
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'description_typography',
		 		'label' 		=> esc_html__( 'Description Typography', 'marino' ),
		 		'selector' 		=> '{{WRAPPER}} .feature-style2 .feature-body .feature-text',
		 	]
		);

        $this->add_responsive_control(
			'description_margin',
			[
				'label' 		=> __( 'Description Margin', 'marino' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .feature-style2 .feature-body .feature-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'description_padding',
			[
				'label' 		=> __( 'Description Padding', 'marino' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .feature-style2 .feature-body .feature-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->end_controls_section();


        
        /*-----------------------------------------Button styling------------------------------------*/

        $this->start_controls_section(
			'button_style_section',
			[
				'label' 	=> __( 'Button Style', 'marino' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'button_color',
			[
				'label' 		=> __( 'Color', 'marino' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .feature-content .vs-btn' => 'background-color: {{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_txt_color',
			[
				'label' 		=> __( 'Text Color', 'marino' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .feature-content .vs-btn' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_color_hover',
			[
				'label' 		=> __( 'Hover Color', 'marino' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .feature-content .vs-btn:hover' => 'background-color: {{VALUE}}',
                ],
			]
        );
        $this->add_control(
			'button_hover_txt_color',
			[
				'label' 		=> __( 'Hover Text Color', 'marino' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .feature-content .vs-btn:hover' => 'color: {{VALUE}}',
                ],
			]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'button_typography',
				'label' 	=> __( 'Typography', 'marino' ),
                'selector' 	=> '{{WRAPPER}} .feature-content .vs-btn',
			]
        );
        $this->end_controls_section();
	}

	protected function render() {

		$settings = $this->get_settings_for_display();

        if( $settings['reverse_style'] == 'yes' ){
            $reverse = 'reverse-style';
            $row_reverse = 'flex-row-reverse';
        }else{
            $reverse = '';
            $row_reverse = '';
        }

        echo '<div class="fishing-spot">';

            $link = ! empty( $settings['button_link']['url'] ) ? $settings['button_link']['url'] : '#';

            echo '<div class="feature-style2">';
                echo '<div class="feature-body '.$reverse.'">';
                    echo '<div class="row align-items-center '.$row_reverse.'">';
                        if( ! empty( $settings['image']['url'] ) ){
                            echo '<div class="col-lg-6">';
                                echo '<div class="feature-img mega-hover">';
                                    echo '<a href="'.esc_url( $link ).'">';
                                        echo marino_img_tag( array(
                                            'url'   => esc_url( $settings['image']['url'] ),
                                        ) );
                                    echo '</a>';
                                echo '</div>';
                            echo '</div>';
                        }
                        echo '<div class="col-lg-6">';
                            echo '<div class="feature-content text-center">';
                                if( ! empty( $settings['title'] ) ){
                                    echo '<h4 class="feature-title">'.esc_html( $settings['title'] ).'</h4>';
                                }
                                if( ! empty( $settings['desc'] ) ){
                                    echo '<p class="feature-text">';
                                        echo esc_html( $settings['desc'] );
                                    echo '</p>';
                                }
                                if( ! empty( $settings['button_text'] ) ){
                                    echo '<a href="'.esc_url( $link ).'" class="vs-btn style3">'.esc_html( $settings['button_text'] ).' <i class="far fa-arrow-right"></i></a>';
                                }
                            echo '</div>';
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        echo '</div>';
	}
}