<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
/**
 *
 * Single Contact Info Widget .
 *
 */
class Marino_Contact_Info extends Widget_Base{

	public function get_name() {
		return 'marinosinglecontactinfo';
	}

	public function get_title() {
		return __( 'Marino Contact Info', 'marino' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'marino' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'chose_us_title',
			[
				'label'		=> __( 'Contact Info','marino' ),
				'tab'		=> Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'icon_class',
            [
                'label'     => __( 'Chose Icon', 'marino' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
            ]
        );
		
        $this->add_control(
			'heading_area',
            [
				'label'         => __( 'Heading Area', 'marino' ),
				'type'          => Controls_Manager::TEXT,
				'default'       => __( 'Address' , 'marino' ),
				'label_block'   => true,
			]
		);

		$this->add_control(
			'info_area',
            [
				'label'         => __( 'Info Area', 'marino' ),
				'type'          => Controls_Manager::WYSIWYG,
				'default'       => __( '272 Rodney St, Brooklyn, East Houston Street New York City' , 'marino' ),
				'label_block'   => true,
			]
		);

		
		$this->end_controls_section();


		/*-----------------------------------------title styling------------------------------------*/

		$this->start_controls_section(
			'general',
			[
				'label' 	=> __( 'General Styling', 'marino' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' 		=> 'background',
				'label' 	=> __( 'Background', 'marino' ),
				'types' 	=> [ 'classic', 'gradient', 'video' ],
				'selector' 	=> '{{WRAPPER}} .info-bg',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' 		=> 'box_shadow',
				'label' 	=> __( 'Box Shadow', 'marino' ),
				'selector' 	=> '{{WRAPPER}} .info-bg',
			]
		);
		$this->add_control(
			'width',
			[
				'label' 	=> __( 'Box Radious', 'marino' ),
				'type' 		=> Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .info-bg' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
				],
			]
		);
        
        $this->end_controls_section();

        $this->start_controls_section(
			'title_styling',
			[
				'label' 	=> __( 'Title Styling', 'marino' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'title_color',
			[
				'label' 		=> __( 'Title Color', 'marino' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .info-box-title'	=> 'color: {{VALUE}};',
				],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'title_typography',
		 		'label' 		=> __( 'Title Typography', 'marino' ),
		 		'selectors' 	=> [
		 			'{{WRAPPER}} .info-box-title',
		 		]
			]
		);

        $this->add_responsive_control(
			'title_margin',
			[
				'label' 		=> __( 'Title Margin', 'marino' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .info-box-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'title_padding',
			[
				'label' 		=> __( 'Title Padding', 'marino' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .info-box-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->end_controls_section();


        $this->start_controls_section(
			'description_styling',
			[
				'label' 	=> __( 'Description Styling', 'marino' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'description_color',
			[
				'label' 		=> __( 'Description Color', 'marino' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .contact-info-box .media-info'	=> 'color: {{VALUE}};',
				],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'description_typography',
		 		'label' 		=> __( 'Description Typography', 'marino' ),
		 		'selectors' 	=> [
		 			'{{WRAPPER}} .contact-info-box .media-info',
		 		]
			]
		);

        $this->add_responsive_control(
			'description_margin',
			[
				'label' 		=> __( 'Description Margin', 'marino' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .contact-info-box .media-info' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'description_padding',
			[
				'label' 		=> __( 'Description Padding', 'marino' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .contact-info-box .media-info' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->end_controls_section();
 

	}

	protected function render() {

		$settings = $this->get_settings_for_display();

        echo '<div class="contact-info-box">';
            echo '<div class="vs-media align-items-center">';
                if( ! empty( $settings['icon_class'] ) ){
                    echo '<div class="media-icon">';
                        echo '<i class="'.esc_attr( $settings['icon_class'] ).'"></i>';
                    echo '</div>';
                }
                
                echo '<div class="media-body">';
                    if( ! empty( $settings['heading_area'] ) ){
                        echo '<h3 class="info-box-title">'.esc_html( $settings['heading_area'] ).'</h3>';
                    }
                    if( ! empty( $settings['info_area'] ) ){
                        echo wp_kses_post( $settings['info_area'] );
                    }
                    
                echo '</div>';
            echo '</div>';
        echo '</div>';
	}
}