<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;

/**
 *
 * Blog Post Widget .
 *
 */
class Marino_Blog_Post extends Widget_Base {

	public function get_name() {
		return 'marinoblogpost';
	}

	public function get_title() {
		return __('Blog Post', 'marino');
	}

	public function get_icon() {
		return 'eicon-code';
	}

	public function get_categories() {
		return ['marino'];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'blog_post_section',
			[
				'label' => __('Blog Post', 'marino'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'blog_style',
			[
				'label' 	=> __('Blog Style', 'marino'),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __('Style One', 'marino'),
					'2' 		=> __('Style Two', 'marino'),
					'3' 		=> __('Style Three', 'marino'),
					'4' 		=> __('Style Four', 'marino'),
				],
			]
		);
		$this->add_control(
			'arrow_position',
			[
				'label' 	=> __('Arrow Style', 'marino'),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __('Style One', 'marino'),
					'2' 		=> __('Style Two', 'marino'),
				],
			]
		);

		$this->add_control(
			'blog_post_count',
			[
				'label' 	=> __('No of Post to show', 'marino'),
				'type' 		=> Controls_Manager::TEXT,
				'default'  	=> __('4', 'marino')
			]
		);

		$this->add_control(
			'title_count',
			[
				'label' 	=> __('Title Length', 'marino'),
				'type' 		=> Controls_Manager::TEXT,
				'default'  	=> __('5', 'marino'),
			]
		);

		$this->add_control(
			'excerpt_count',
			[
				'label' 	=> __('Excerpt Length', 'marino'),
				'type' 		=> Controls_Manager::TEXT,
				'default'  	=> __('16', 'marino'),
			]
		);

		$this->add_control(
			'blog_post_order',
			[
				'label' 	=> __('Order', 'marino'),
				'type' 		=> Controls_Manager::SELECT,
				'options'   => [
					'ASC'   	=> __('ASC', 'marino'),
					'DESC'   	=> __('DESC', 'marino'),
				],
				'default'  	=> 'DESC'
			]
		);

		$this->add_control(
			'blog_post_order_by',
			[
				'label' 	=> __('Order By', 'marino'),
				'type' 		=> Controls_Manager::SELECT,
				'options'   => [
					'ID'    	=> __('ID', 'marino'),
					'author'    => __('Author', 'marino'),
					'title'    	=> __('Title', 'marino'),
					'date'    	=> __('Date', 'marino'),
					'rand'    	=> __('Random', 'marino'),
				],
				'default'  	=> 'ID'
			]
		);

		$this->add_control(
			'exclude_cats',
			[
				'label' 		=> __('Exclude Categories', 'marino'),
				'type' 			=> Controls_Manager::SELECT2,
				'multiple' 		=> true,
				'options' 		=> $this->marino_get_categories(),
			]
		);

		$this->add_control(
			'exclude_tags',
			[
				'label' 		=> __('Exclude Tags', 'marino'),
				'type' 			=> Controls_Manager::SELECT2,
				'multiple' 		=> true,
				'options' 		=> $this->marino_get_tags(),
			]
		);

		$this->add_control(
			'exclude_post_id',
			[
				'label'         => __('Exclude Post', 'marino'),
				'type'          => Controls_Manager::SELECT2,
				'multiple'      => true,
				'options'       => $this->marino_post_id(),
			]
		);

		$this->add_control(
			'button_text',
			[
				'label' 	=> esc_html__('Button Text', 'marino'),
				'type' 		=> Controls_Manager::TEXT,
				'default'  	=> esc_html__('Read More', 'marino'),
			]
		);


		$this->end_controls_section();

		$this->start_controls_section(
			'slider_control_section',
			[
				'label' 		=> __('Slider Control', 'marino'),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'slide_to_show',
			[
				'label' 		=> __('Slide To Show', 'marino'),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> ['px'],
				'range' 		=> [
					'px' 			=> [
						'min' 			=> 0,
						'max' 			=> 10,
						'step'			=> 1,
					],
				],
				'default' 	=> [
					'unit' 		=> 'px',
					'size' 		=> 3,
				],
			]
		);

		$this->add_control(
			'slider_autoplay',
			[
				'label' 		=> __('AutoPlay', 'marino'),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __('Yes', 'marino'),
				'label_off' 	=> __('No', 'marino'),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);
		$this->add_control(
			'slider_arrows',
			[
				'label' 		=> __('Arrows', 'marino'),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __('Yes', 'marino'),
				'label_off' 	=> __('No', 'marino'),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'post_title_style_section',
			[
				'label' 	=> __('Title', 'marino'),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'post_title_color',
			[
				'label' 		=> __('Title Color', 'marino'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-title a, {{WRAPPER}} .blog-style2 .blog-title a' => 'color: {{VALUE}}!important;',
				],
			]
		);

		$this->add_control(
			'post_title_color_hover',
			[
				'label' 		=> __('Title Color Hover', 'marino'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-title a:hover, {{WRAPPER}} .blog-style2 .blog-title a' => 'color: {{VALUE}}!important;',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'post_title_typography',
				'label' 	=> __('Title Typography', 'marino'),
				'selector' 	=> '{{WRAPPER}} .blog-title, {{WRAPPER}} .blog-style2 .blog-title a',
			]
		);

		$this->add_responsive_control(
			'post_title_margin',
			[
				'label' 		=> __('Title Margin', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .blog-title, {{WRAPPER}} .blog-style2 .blog-title a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'post_title_padding',
			[
				'label' 		=> __('Title Padding', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .blog-title, {{WRAPPER}} .blog-style2 .blog-title a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'post_content_style_section',
			[
				'label' 	=> __('Content', 'marino'),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'post_content_color',
			[
				'label' 		=> __('Content Color', 'marino'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-para' => 'color: {{VALUE}}!important;',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'post_content_typography',
				'label' 	=> __('Content Typography', 'marino'),
				'selector' 	=> '{{WRAPPER}} .blog-para',
			]
		);

		$this->add_responsive_control(
			'post_content_margin',
			[
				'label' 		=> __('Content Margin', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .blog-para' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'post_content_padding',
			[
				'label' 		=> __('Content Padding', 'marino'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%', 'em'],
				'selectors' 	=> [
					'{{WRAPPER}} .blog-para' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'meta_style',
			[
				'label' 	=> __('Meta', 'marino'),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'meta_color',
			[
				'label' 		=> __('Meta Color', 'marino'),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .blog-meta a,{{WRAPPER}} .blog-steped .blog-date' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'meta_typography',
				'label' 	=> __('Meta Typography', 'marino'),
				'selector' 	=> '{{WRAPPER}} .blog-meta a,{{WRAPPER}} .blog-steped .blog-date',
			]
		);
		$this->end_controls_section();
	}

	public function marino_get_categories() {
		$cats = get_terms(array(
			'taxonomy' 		=> 'category',
			'hide_empty' 	=> true,
		));

		$catarr = [];

		foreach ($cats as $singlecat) {
			$catarr[$singlecat->term_id] = __($singlecat->name, 'marino');
		}

		return $catarr;
	}

	public function marino_get_tags() {
		$cats = get_terms(array(
			'taxonomy' => 'post_tag',
			'hide_empty' => true,
		));

		$catarr = [];

		foreach ($cats as $singlecat) {
			$catarr[$singlecat->term_id] = __($singlecat->name, 'marino');
		}

		return $catarr;
	}

	// Get Specific Post
	public function marino_post_id() {
		$args = array(
			'post_type'         => 'post',
			'posts_per_page'    => -1,
		);

		$marino_post = new WP_Query($args);

		$postarray = [];

		while ($marino_post->have_posts()) {
			$marino_post->the_post();
			$postarray[get_the_Id()] = get_the_title();
		}
		wp_reset_postdata();
		return $postarray;
	}

	protected function render() {

		$settings = $this->get_settings_for_display();
		$exclude_post = $settings['exclude_post_id'];

		if (!empty($settings['exclude_cats']) && empty($settings['exclude_tags']) && empty($settings['exclude_post_id'])) {
			$args = array(
				'post_type'             => 'post',
				'posts_per_page'        => esc_attr($settings['blog_post_count']),
				'order'                 => esc_attr($settings['blog_post_order']),
				'orderby'               => esc_attr($settings['blog_post_order_by']),
				'ignore_sticky_posts'   => true,
				'category__not_in'      => $settings['exclude_cats']
			);
		} elseif (!empty($settings['exclude_cats']) && !empty($settings['exclude_tags']) && empty($settings['exclude_post_id'])) {
			$args = array(
				'post_type'             => 'post',
				'posts_per_page'        => esc_attr($settings['blog_post_count']),
				'order'                 => esc_attr($settings['blog_post_order']),
				'orderby'               => esc_attr($settings['blog_post_order_by']),
				'ignore_sticky_posts'   => true,
				'category__not_in'      => $settings['exclude_cats'],
				'tag__not_in'           => $settings['exclude_tags']
			);
		} elseif (!empty($settings['exclude_cats']) && !empty($settings['exclude_tags']) && !empty($settings['exclude_post_id'])) {
			$args = array(
				'post_type'             => 'post',
				'posts_per_page'        => esc_attr($settings['blog_post_count']),
				'order'                 => esc_attr($settings['blog_post_order']),
				'orderby'               => esc_attr($settings['blog_post_order_by']),
				'ignore_sticky_posts'   => true,
				'category__not_in'      => $settings['exclude_cats'],
				'tag__not_in'           => $settings['exclude_tags'],
				'post__not_in'          => $exclude_post
			);
		} elseif (!empty($settings['exclude_cats']) && empty($settings['exclude_tags']) && !empty($settings['exclude_post_id'])) {
			$args = array(
				'post_type'             => 'post',
				'posts_per_page'        => esc_attr($settings['blog_post_count']),
				'order'                 => esc_attr($settings['blog_post_order']),
				'orderby'               => esc_attr($settings['blog_post_order_by']),
				'ignore_sticky_posts'   => true,
				'category__not_in'      => $settings['exclude_cats'],
				'post__not_in'          => $exclude_post
			);
		} elseif (empty($settings['exclude_cats']) && !empty($settings['exclude_tags']) && !empty($settings['exclude_post_id'])) {
			$args = array(
				'post_type'             => 'post',
				'posts_per_page'        => esc_attr($settings['blog_post_count']),
				'order'                 => esc_attr($settings['blog_post_order']),
				'orderby'               => esc_attr($settings['blog_post_order_by']),
				'ignore_sticky_posts'   => true,
				'tag__not_in'           => $settings['exclude_tags'],
				'post__not_in'          => $exclude_post
			);
		} elseif (empty($settings['exclude_cats']) && !empty($settings['exclude_tags']) && empty($settings['exclude_post_id'])) {
			$args = array(
				'post_type'             => 'post',
				'posts_per_page'        => esc_attr($settings['blog_post_count']),
				'order'                 => esc_attr($settings['blog_post_order']),
				'orderby'               => esc_attr($settings['blog_post_order_by']),
				'ignore_sticky_posts'   => true,
				'tag__not_in'           => $settings['exclude_tags'],
			);
		} elseif (empty($settings['exclude_cats']) && empty($settings['exclude_tags']) && !empty($settings['exclude_post_id'])) {
			$args = array(
				'post_type'             => 'post',
				'posts_per_page'        => esc_attr($settings['blog_post_count']),
				'order'                 => esc_attr($settings['blog_post_order']),
				'orderby'               => esc_attr($settings['blog_post_order_by']),
				'ignore_sticky_posts'   => true,
				'post__not_in'          => $exclude_post
			);
		} else {
			$args = array(
				'post_type'             => 'post',
				'posts_per_page'        => esc_attr($settings['blog_post_count']),
				'order'                 => esc_attr($settings['blog_post_order']),
				'orderby'               => esc_attr($settings['blog_post_order_by']),
				'ignore_sticky_posts'   => true
			);
		}

		$blogpost = new WP_Query($args);

		$this->add_render_attribute('wrapper', 'class', 'row vs-carousel');

		if ($settings['slider_arrows'] == 'yes') {
			$this->add_render_attribute('wrapper', 'data-slick-arrows', 'true');
		} else {
			$this->add_render_attribute('wrapper', 'data-slick-arrows', 'false');
		}

		if ($settings['slider_autoplay'] == 'yes') {
			$this->add_render_attribute('wrapper', 'data-slick-autoplay', 'true');
		} else {
			$this->add_render_attribute('wrapper', 'data-slick-autoplay', 'false');
		}


		$this->add_render_attribute('wrapper', 'data-slide-to-show', $settings['slide_to_show']['size']);

		if ($settings['arrow_position'] == '1') {
			$this->add_render_attribute('wrapper', 'class', 'slick-arrow2');
		}
		if ($settings['blog_style'] == '4') {
			$this->add_render_attribute('wrapper', 'class', 'blog-layout1');
		}

		if ($blogpost->have_posts()) {
			echo '<div class="blog-wrapper arrow-wrap">';
			echo '<div class="container">';
			echo '<div ' . $this->get_render_attribute_string('wrapper') . '>';
			while ($blogpost->have_posts()) {
				$blogpost->the_post();
				echo '<div class="col-lg-4">';
				if ($settings['blog_style'] == '1') {
					echo '<div class="vs-blog blog-style2">';
					if (has_post_thumbnail()) {
						echo '<div class="blog-img">';
						echo '<a href="' . esc_url(get_permalink()) . '">';
						the_post_thumbnail('full', array('class' => 'w-100'));
						echo '</a>';
						echo '<a href="' . esc_url(marino_blog_date_permalink()) . '" class="blog-meta2">';
						echo '<span class="day">' . esc_html(get_the_date('d')) . '</span>';
						echo '<span class="month">' . esc_html(get_the_date('F')) . '</span>';
						echo '</a>';
						echo '</div>';
					}
					echo '<div class="blog-content">';
					echo '<h4 class="blog-title h4"><a href="' . esc_url(get_permalink()) . '">' . esc_html(wp_trim_words(get_the_title(), $settings['title_count'], '')) . '</a></h4>';
					echo '<p class="blog-text">' . esc_html(wp_trim_words(get_the_content(), $settings['excerpt_count'], '')) . '</p>';
					echo '<div class="blog-bottom">';
					echo '<div class="blog-author">';
					echo '<a href="' . esc_url(get_author_posts_url(get_the_author_meta('ID'))) . '"><i class="fas fa-user"></i>' . esc_html(get_the_author()) . '</a>';
					echo '</div>';
					if (!empty($settings['button_text'])) {
						echo '<a href="' . esc_url(get_permalink()) . '" class="vs-btn style3">' . esc_html($settings['button_text']) . '</a>';
					}
					echo '</div>';
					echo '</div>';
					echo '</div>';
				} elseif ($settings['blog_style'] == '2') {
					echo '<div class="vs-blog blog-style1">';
					if (has_post_thumbnail()) {
						echo '<div class="blog-img">';
						echo '<a href="' . esc_url(get_permalink()) . '">';
						the_post_thumbnail('full', array('class' => 'w-100'));
						echo '</a>';
						echo '<a href="' . esc_url(marino_blog_date_permalink()) . '" class="blog-meta2">';
						echo '<span class="day">' . esc_html(get_the_date('d')) . '</span>';
						echo '<span class="month">' . esc_html(get_the_date('F')) . '</span>';
						echo '</a>';
						echo '</div>';
					}
					echo '<div class="blog-content">';
					echo '<div class="blog-meta">';
					echo '<a href="' . esc_url(get_author_posts_url(get_the_author_meta('ID'))) . '"><i class="fas fa-user"></i>' . esc_html(get_the_author()) . '</a>';
					if (get_comments_number() == 1) {
						$comment_text = __(' Comment', 'marino');
					} else {
						$comment_text = __(' Comments', 'marino');
					}
					echo '<a href="' . esc_url(get_comments_link(get_the_ID())) . '"><i class="fas fa-comment-dots"></i>' . esc_html(get_comments_number()) . '' . $comment_text . '</a>';
					echo '</div>';
					echo '<h4 class="blog-title"><a href="' . esc_url(get_permalink()) . '">' . esc_html(wp_trim_words(get_the_title(), $settings['title_count'], '')) . '</a></h4>';
					if (!empty($settings['excerpt_count'])) {
						echo '<p class="blog-text">' . esc_html(wp_trim_words(get_the_content(), $settings['excerpt_count'], '')) . '</p>';
					}
					if (!empty($settings['button_text'])) {
						echo '<a href="' . esc_url(get_permalink()) . '" class="link-btn">' . esc_html($settings['button_text']) . ' <i class="far fa-arrow-right"></i></a>';
					}
					echo '</div>';
					echo '</div>';
				} elseif ($settings['blog_style'] == '3') { ?>
					<div class="vs-blog blog-style3">
						<div class="blog-img">
							<a href="<?php echo esc_url(get_permalink()); ?>">
								<?php
								the_post_thumbnail('full', array('class' => 'w-100'));
								?>
							</a>
							<div class="blog-meta2">
								<span class="day"><?php echo get_the_date('d') ?></span>
								<span class="month"><?php echo get_the_date('M Y') ?></span>
							</div>
						</div>
						<div class="blog-content">
							<div class="blog-meta">
								<?php
								if (get_comments_number() == 1) {
									$comment_text = __(' Comment', 'marino');
								} else {
									$comment_text = __(' Comments', 'marino');
								}
								echo '<a href="' . esc_url(get_comments_link(get_the_ID())) . '"><i class="fal fa-comments"></i>' . esc_html(get_comments_number()) . '' . $comment_text . '</a>';
								?>
								<a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><i class="fas fa-user-circle"></i><?php echo esc_html(get_the_author()); ?></a>
							</div>
							<h4 class="blog-title">
								<a href="<?php the_permalink(); ?>"><?php echo esc_html(wp_trim_words(get_the_title(), $settings['title_count'], '')); ?></a>
							</h4>
							<?php if (!empty($settings['button_text'])) {
								echo '<a href="' . esc_url(get_permalink()) . '" class="link-btn">' . esc_html($settings['button_text']) . ' <i class="far fa-long-arrow-right"></i></a>';
							} ?>
						</div>
					</div>
				<?php } elseif ($settings['blog_style'] == '4') { ?>
					<div class="vs-blog blog-style3">
						<div class="blog-img">
							<a href="<?php echo esc_url(get_permalink()); ?>">
								<?php
								the_post_thumbnail('full', array('class' => 'w-100'));
								?>
							</a>
							<div class="blog-meta2">
								<span class="day"><?php echo get_the_date('d') ?></span>
								<span class="month"><?php echo get_the_date('M Y') ?></span>
							</div>
						</div>
						<div class="blog-content">
							<div class="blog-meta">
								<?php
								if (get_comments_number() == 1) {
									$comment_text = __(' Comment', 'marino');
								} else {
									$comment_text = __(' Comments', 'marino');
								}
								echo '<a href="' . esc_url(get_comments_link(get_the_ID())) . '"><i class="fal fa-comments"></i>' . esc_html(get_comments_number()) . '' . $comment_text . '</a>';
								?>
								<a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><i class="fas fa-user-circle"></i><?php echo esc_html(get_the_author()); ?></a>
							</div>
							<h4 class="blog-title">
								<a href="<?php the_permalink(); ?>"><?php echo esc_html(wp_trim_words(get_the_title(), $settings['title_count'], '')); ?></a>
							</h4>
						</div>
					</div>
<?php }
				echo '</div>';
			}
			wp_reset_postdata();
			echo '</div>';
			echo '</div>';
			echo '</div>';
		}
	}
}
