
<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;

/**
 *
 * Header Widget .
 *
 */
class Marino_Gtranslate extends Widget_Base {

    public function get_name() {
        return 'marinogtranslate';
    }

    public function get_title() {
        return __('Gtranslate', 'marino');
    }

    public function get_icon() {
        return 'eicon-code';
    }

    public function get_categories() {
        return ['marino_header_elements'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'gtranslate',
            [
                'label'     => __('Gtranslate', 'marino'),
                'tab'       => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'color',
            [
                'label'         => __('Color', 'marino'),
                'type'          => Controls_Manager::COLOR,
                'selectors'     => [
                    '{{WRAPPER}} .marino-gtranslate .dropdown-toggle' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();
    }


    protected function render() {

        $settings = $this->get_settings_for_display();

        if (class_exists('GTranslate')) {
            echo '<ul class="marino-gtranslate">';
            echo '<li>';
            echo '<!-- Dropdown -->';
            echo '<a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink1" data-bs-toggle="dropdown" aria-expanded="false">';
            echo esc_html__('Language', 'marino');
            echo '</a>';
            echo '<ul class="dropdown-menu" aria-labelledby="dropdownMenuLink1">';
            echo '<li>';
            echo do_shortcode('[gtranslate]');
            echo '</li>';
            echo '</ul>';
            echo '</li>';
            echo '</ul>';
        }
    }
}
